/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.utility;

import com.ibm.ws.kernel.service.util.UtilityTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DDLGenerationUtility
extends UtilityTemplate {
    private static final String SCRIPT_NAME = "ddlGen";
    private static final ResourceBundle messages = ResourceBundle.getBundle("com.ibm.ws.persistence.utility.resources.UtilityMessages");
    private final PrintStream stdout;
    private final PrintStream stderr;
    private static final int RC_INVALID_OPTION = 20;
    private static final int RC_SERVER_NOT_FOUND = 21;
    private static final int RC_LOCAL_CONNECTOR_URL_NOT_FOUND = 22;
    private static final int RC_MBEAN_NOT_FOUND = 23;
    private static final int RC_MBEAN_INVALID_RESULT = 24;
    private static final int RC_SERVER_OUTPUT_NOT_FOUND = 25;
    private static final int RC_UNEXPECTED_ERROR = 255;

    protected DDLGenerationUtility() {
        this(System.out, System.err);
    }

    private DDLGenerationUtility(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private String getMessage(String key, Object ... args) {
        String message = messages.getString(key);
        return args.length == 0 ? message : MessageFormat.format(message, args);
    }

    private String getScriptUsage() {
        return this.getMessage("usage", SCRIPT_NAME, this.getMessage("action.all", new Object[0]));
    }

    private String getActions() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage("actions", new Object[0]));
        sb.append(this.getMessage("action-key.generate", new Object[0]));
        sb.append(this.getMessage("action-desc.generate", new Object[0]));
        sb.append(this.getMessage("action-key.help", new Object[0]));
        sb.append(this.getMessage("action-desc.help", new Object[0]));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected int runProgram(String[] args) {
        block56: {
            block54: {
                block55: {
                    block52: {
                        block53: {
                            block50: {
                                block51: {
                                    block48: {
                                        block49: {
                                            block46: {
                                                block47: {
                                                    block44: {
                                                        block45: {
                                                            block42: {
                                                                block43: {
                                                                    if (args == null || args.length == 0) {
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 0;
                                                                    }
                                                                    action = args[0];
                                                                    v0 = actionTarget = args.length >= 2 ? args[1] : "";
                                                                    if (action == null || action.isEmpty() || action.toLowerCase().equals("help")) {
                                                                        if (actionTarget.isEmpty() || "help".equalsIgnoreCase(actionTarget)) {
                                                                            this.stdout.println(this.getScriptUsage());
                                                                            this.stdout.println(this.getActions());
                                                                            return 0;
                                                                        }
                                                                        if ("generate".equalsIgnoreCase(actionTarget)) {
                                                                            this.stderr.println(this.getMessage("generate.help", new Object[0]));
                                                                            return 0;
                                                                        }
                                                                        this.stderr.println(this.getMessage("action.unrecognized", new Object[]{actionTarget}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 20;
                                                                    }
                                                                    if (!"generate".equalsIgnoreCase(action)) {
                                                                        this.stderr.println(this.getMessage("action.unrecognized", new Object[]{action}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 20;
                                                                    }
                                                                    userDir = this.getUserDir();
                                                                    serverName = actionTarget;
                                                                    serverDirectory = new File(userDir + File.separator + "servers" + File.separator + serverName);
                                                                    if (serverName.isEmpty() || !serverDirectory.exists() || !serverDirectory.isDirectory()) {
                                                                        this.stderr.println(this.getMessage("server.not.found", new Object[]{serverName, serverDirectory.getAbsolutePath()}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 21;
                                                                    }
                                                                    logsDir = new File(this.getOutputDir(serverName) + serverName + File.separator + "logs");
                                                                    if (!logsDir.exists()) {
                                                                        this.stderr.println(this.getMessage("server.output.logs.dir.not.found", new Object[]{serverName, logsDir.getAbsolutePath()}));
                                                                        return 25;
                                                                    }
                                                                    jmxLocalConnectorUrlFile = new File(this.getOutputDir(serverName) + serverName + File.separator + "logs" + File.separator + "state" + File.separator + "/com.ibm.ws.jmx.local.address");
                                                                    if (!jmxLocalConnectorUrlFile.exists()) {
                                                                        this.stderr.println(this.getMessage("local.connector.not.found", new Object[]{serverName}));
                                                                        return 22;
                                                                    }
                                                                    connector = null;
                                                                    br = new BufferedReader(new FileReader(jmxLocalConnectorUrlFile));
                                                                    urlString = br.readLine();
                                                                    br.close();
                                                                    if (urlString != null) break block42;
                                                                    this.stderr.println(this.getMessage("local.connector.url.empty", new Object[]{serverName}));
                                                                    var12_15 = 255;
                                                                    if (connector == null) break block43;
                                                                    try {
                                                                        connector.close();
                                                                        connector = null;
                                                                    }
                                                                    catch (Throwable var13_18) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                return var12_15;
                                                            }
                                                            url = new JMXServiceURL(urlString);
                                                            connector = JMXConnectorFactory.connect(url);
                                                            con = connector.getMBeanServerConnection();
                                                            name = new ObjectName("WebSphere:feature=persistence,type=DDLGenerationMBean,name=DDLGenerationMBean");
                                                            objects = con.queryMBeans(name, null);
                                                            if (objects == null || objects.size() <= 0) ** GOTO lbl144
                                                            i = objects.iterator();
                                                            o = i.next();
                                                            instanceName = o.getObjectName();
                                                            generateResults = (Map)con.invoke(instanceName, "generateDDL", new Object[0], new String[0]);
                                                            if (generateResults != null) break block44;
                                                            this.stderr.println(this.getMessage("mbean.null.result", new Object[0]));
                                                            var20_28 = 24;
                                                            if (connector == null) break block45;
                                                            try {
                                                                connector.close();
                                                                connector = null;
                                                            }
                                                            catch (Throwable var21_31) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return var20_28;
                                                    }
                                                    if (!generateResults.containsKey("success")) ** GOTO lbl96
                                                    success = (Boolean)generateResults.get("success");
                                                    if (success != null && success.booleanValue()) break block46;
                                                    this.stderr.println(this.getMessage("mbean.bad.result", new Object[0]));
                                                    var21_32 = 24;
                                                    if (connector == null) break block47;
                                                    try {
                                                        connector.close();
                                                        connector = null;
                                                    }
                                                    catch (Throwable var22_37) {
                                                        // empty catch block
                                                    }
                                                }
                                                return var21_32;
                                            }
                                            break block48;
lbl96:
                                            // 1 sources

                                            this.stderr.println(this.getMessage("mbean.missing.result", new Object[0]));
                                            success = 24;
                                            if (connector == null) break block49;
                                            try {
                                                connector.close();
                                                connector = null;
                                            }
                                            catch (Throwable var21_33) {
                                                // empty catch block
                                            }
                                        }
                                        return success;
                                    }
                                    outputDirectory = null;
                                    if (!generateResults.containsKey("output.directory")) ** GOTO lbl130
                                    outputDirectory = (String)generateResults.get("output.directory");
                                    if (outputDirectory != null && outputDirectory.length() > 0) break block50;
                                    this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                                    var21_34 = 24;
                                    if (connector == null) break block51;
                                    try {
                                        connector.close();
                                        connector = null;
                                    }
                                    catch (Throwable var22_38) {
                                        // empty catch block
                                    }
                                }
                                return var21_34;
                            }
                            this.stdout.println(this.getMessage("mbean.output.dir", new Object[]{outputDirectory}));
                            if (generateResults.containsKey("file.count") && (fileCount = (Integer)generateResults.get("file.count")) != null && fileCount == 0) {
                                this.stdout.println(this.getMessage("no.output.generated", new Object[]{serverName}));
                            }
                            break block52;
lbl130:
                            // 1 sources

                            this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                            var21_36 = 24;
                            if (connector == null) break block53;
                            try {
                                connector.close();
                                connector = null;
                            }
                            catch (Throwable var22_39) {
                                // empty catch block
                            }
                        }
                        return var21_36;
                    }
                    break block54;
lbl144:
                    // 1 sources

                    this.stderr.println(this.getMessage("mbean.not.found", new Object[]{serverName}));
                    var16_23 = 23;
                    if (connector == null) break block55;
                    try {
                        connector.close();
                        connector = null;
                    }
                    catch (Throwable var17_25) {
                        // empty catch block
                    }
                }
                return var16_23;
            }
            if (connector != null) {
                try {
                    connector.close();
                    connector = null;
                }
                catch (Throwable br) {}
            }
            break block56;
            catch (Throwable t) {
                try {
                    this.stderr.println(this.getMessage("exception.catch", new Object[]{t.toString()}));
                    t.printStackTrace(this.stderr);
                    var11_14 = 255;
                    return var11_14;
                }
                catch (Throwable var23_40) {
                    throw var23_40;
                }
                finally {
                    if (connector != null) {
                        try {
                            connector.close();
                            connector = null;
                        }
                        catch (Throwable var12_17) {}
                    }
                }
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        DDLGenerationUtility util = new DDLGenerationUtility();
        int rc = util.runProgram(args);
        System.exit(rc);
    }
}

