/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.util.ImageInfo;
import com.ibm.ws.kernel.feature.internal.util.Images;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ImageReader {
    public static final String FEATURES_FILE_NAME = "features.xml";
    public static final String XML_INPUT_FEATURE_OPEN = "<feature>";
    public static final String XML_INPUT_FEATURE_CLOSE = "</feature>";
    static final long serialVersionUID = -1609049531489534654L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static List<File[]> selectImageDirs(File rootFile) {
        File[] imageFiles = rootFile.listFiles();
        ArrayList<File[]> imageDirs = new ArrayList<File[]>(imageFiles.length);
        for (File imageFile : imageFiles) {
            File featuresFile;
            if (!imageFile.isDirectory() || !(featuresFile = new File(imageFile, FEATURES_FILE_NAME)).exists()) continue;
            imageDirs.add(new File[]{imageFile, featuresFile});
        }
        return imageDirs;
    }

    public static Images readImages(Collection<File[]> imageDirs) throws IOException {
        Images images = new Images(imageDirs.size());
        for (File[] imageFiles : imageDirs) {
            File imageDir = imageFiles[0];
            File imageFile = imageFiles[1];
            String imageName = imageDir.getName();
            List<String> features = ImageReader.readFeatures(imageFile);
            images.put(new ImageInfo(imageName, features));
        }
        return images;
    }

    public static List<String> readFeatures(File imageFile) throws IOException {
        ArrayList<String> features = new ArrayList<String>();
        FileInputStream inputStream = new FileInputStream(imageFile);
        try {
            InputStreamReader baseReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            try {
                BufferedReader reader = new BufferedReader(baseReader);
                try {
                    String nextLine;
                    while ((nextLine = reader.readLine()) != null) {
                        if ((nextLine = nextLine.trim()).isEmpty() || !nextLine.startsWith(XML_INPUT_FEATURE_OPEN) || !nextLine.endsWith(XML_INPUT_FEATURE_CLOSE)) continue;
                        int startPos = XML_INPUT_FEATURE_OPEN.length();
                        int endPos = nextLine.length() - XML_INPUT_FEATURE_CLOSE.length();
                        String feature = nextLine.substring(startPos, endPos);
                        features.add(feature);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
                try {
                    baseReader.close();
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            baseReader.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
            try {
                ((InputStream)inputStream).close();
            }
            catch (Throwable throwable4) {
                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", (String)"78", null, (Object[])new Object[]{imageFile});
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        ((InputStream)inputStream).close();
        return features;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.ImageReader", ImageReader.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }
}

