/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;

public final class PKCS7 {
    String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.PKCS7";

    public PKCS7() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7");
            debug.exit(16384L, className, "PKCS7");
        }
    }

    public PKCS7(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7");
        }
    }

    public static boolean isData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isData", oidString);
            debug.exit(16384L, (Object)className, "isData", new Boolean(oidString.equals(PKCSOID.DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.DATA_OID.toString());
    }

    public static boolean isSignedData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedData", oidString);
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(oidString.equals(PKCSOID.SIGNED_DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.SIGNED_DATA_OID.toString());
    }

    public static boolean isEnvelopedData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEnvelopedData", oidString);
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(oidString.equals(PKCSOID.ENVELOPED_DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.ENVELOPED_DATA_OID.toString());
    }

    public static boolean isSignedAndEnvelopedData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedAndEnvelopedData", oidString);
            debug.exit(16384L, (Object)className, "isSignedAndEnvelopedData", new Boolean(oidString.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID.toString());
    }

    public static boolean isDigestedData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isDigestedData", oidString);
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(oidString.equals(PKCSOID.DIGESTED_DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.DIGESTED_DATA_OID.toString());
    }

    public static boolean isEncryptedData(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEncryptedData", oidString);
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(oidString.equals(PKCSOID.ENCRYPTED_DATA_OID.toString())));
        }
        return oidString.equals(PKCSOID.ENCRYPTED_DATA_OID.toString());
    }

    public static boolean isNetscapeCertSequence(String oidString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isNetscapeCertSequence", oidString);
            debug.exit(16384L, (Object)className, "isNetscapeCertSequence", new Boolean(oidString.equals(PKCSOID.NETSCAPE_CERT_SEQUENCE_OID.toString())));
        }
        return oidString.equals(PKCSOID.NETSCAPE_CERT_SEQUENCE_OID.toString());
    }

    public static boolean isData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isData", oid);
            debug.exit(16384L, (Object)className, "isData", new Boolean(PKCS7.isData(oid.toString())));
        }
        return PKCS7.isData(oid.toString());
    }

    public static boolean isSignedData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedData", oid);
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(PKCS7.isSignedData(oid.toString())));
        }
        return PKCS7.isSignedData(oid.toString());
    }

    public static boolean isEnvelopedData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEnvelopedData", oid);
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(PKCS7.isEnvelopedData(oid.toString())));
        }
        return PKCS7.isEnvelopedData(oid.toString());
    }

    public static boolean isSignedAndEnvelopedData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedAndEnvelopedData", oid);
            debug.exit(16384L, (Object)className, "isSignedAndEnvelopedData", new Boolean(PKCS7.isSignedAndEnvelopedData(oid.toString())));
        }
        return PKCS7.isSignedAndEnvelopedData(oid.toString());
    }

    public static boolean isDigestedData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isDigestedData", oid);
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(PKCS7.isDigestedData(oid.toString())));
        }
        return PKCS7.isDigestedData(oid.toString());
    }

    public static boolean isEncryptedData(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEncryptedData", oid);
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(PKCS7.isEncryptedData(oid.toString())));
        }
        return PKCS7.isEncryptedData(oid.toString());
    }

    public static boolean isNetscapeCertSequence(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isNetscapeCertSequence", oid);
            debug.exit(16384L, (Object)className, "isNetscapeCertSequence", new Boolean(PKCS7.isNetscapeCertSequence(oid.toString())));
        }
        return PKCS7.isNetscapeCertSequence(oid.toString());
    }

    public static String getDigestAlgorithm(String digestSignatureAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", digestSignatureAlgorithm);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId alg = AlgorithmId.get(digestSignatureAlgorithm);
        try {
            String result = PKCS7.getDigestAlgorithm(alg);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestAlgorithm", e2);
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
        }
    }

    public static String getDigestAlgorithm(String digestSignatureAlgorithm, String provider) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", digestSignatureAlgorithm);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId alg = AlgorithmId.get(digestSignatureAlgorithm);
        try {
            String result = PKCS7.getDigestAlgorithm(alg, provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestAlgorithm", e2);
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
        }
    }

    public static String getDigestAlgorithm(AlgorithmId alg) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", alg);
        }
        String result = PKCS7.getDigestAlgorithm(alg, null);
        if (debug != null) {
            debug.text(16384L, className, "getDigestAlgorithm", result);
        }
        return result;
    }

    public static String getDigestAlgorithm(AlgorithmId alg, String provider) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm", alg, provider);
        }
        if (alg == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        ObjectIdentifier oid = alg.getOID();
        if (oid.equals(AlgorithmId.MD5_oid) || oid.equals(AlgorithmId.MD2_oid) || oid.equals(AlgorithmId.SHA_oid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm_1", alg.getName());
            }
            return alg.getName();
        }
        String result = null;
        if (oid.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
            result = new AlgorithmId(AlgorithmId.MD5_oid, provider).getName();
        } else if (oid.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
            result = new AlgorithmId(AlgorithmId.MD2_oid, provider).getName();
        } else if (oid.equals(AlgorithmId.sha1WithDSA_oid)) {
            result = new AlgorithmId(AlgorithmId.SHA_oid, provider).getName();
        } else if (oid.equals(AlgorithmId.sha1WithRSAEncryption_oid) || oid.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) {
            result = new AlgorithmId(AlgorithmId.SHA_oid, provider).getName();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + alg + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + alg + ".");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
        }
        return result;
    }

    public static String getSignatureAlgorithm(String digestSignatureAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignatureAlgorithm", digestSignatureAlgorithm);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId alg = AlgorithmId.get(digestSignatureAlgorithm);
        try {
            String result = PKCS7.getSignatureAlgorithm(alg);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignatureAlgorithm", result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getSignatureAlgorithm", e2);
                debug.text(16384L, className, "getSignatureAlgorithm", "Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + digestSignatureAlgorithm + ".");
        }
    }

    public static String getSignatureAlgorithm(AlgorithmId alg) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignatureAlgorithm", alg);
        }
        if (alg == null) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        ObjectIdentifier oid = alg.getOID();
        String result = null;
        if (!(oid.equals(AlgorithmId.RSAEncryption_oid) || oid.equals(AlgorithmId.DSA_oid) || oid.equals(AlgorithmId.md5WithRSAEncryption_oid) || oid.equals(AlgorithmId.md2WithRSAEncryption_oid) || oid.equals(AlgorithmId.sha1WithDSA_oid) || oid.equals(AlgorithmId.sha1WithRSAEncryption_oid) || oid.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Unrecognized algorithm name: " + alg + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + alg + ".");
        }
        result = alg.getName();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", result);
        }
        return result;
    }

    public static String getMACAlgorithm(String macAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getMACAlgorithm", macAlgorithm);
        }
        if (macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "MAC algorithm must be specified.");
            }
            throw new IllegalArgumentException("MAC algorithm must be specified.");
        }
        AlgorithmId alg = AlgorithmId.get(macAlgorithm);
        try {
            String result = PKCS7.getMACAlgorithm(alg);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMACAlgorithm", result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "Unrecognized MAC algorithm name: " + macAlgorithm + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized MAC algorithm name: " + macAlgorithm + ".");
        }
    }

    public static String getMACAlgorithm(AlgorithmId alg) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getMACAlgorithm", alg);
        }
        if (alg == null) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "MAC algorithm must be specified.");
            }
            throw new IllegalArgumentException("MAC algorithm must be specified.");
        }
        ObjectIdentifier oid = alg.getOID();
        if (oid.equals(AlgorithmId.HmacSHA1_oid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMACAlgorithm", alg.getName());
            }
            return alg.getName();
        }
        if (debug != null) {
            debug.text(16384L, className, "getMACAlgorithm", "Unrecognized MAC algorithm name: " + alg + ".");
        }
        throw new NoSuchAlgorithmException("Unrecognized MAC algorithm name: " + alg + ".");
    }

    public static String getDigestSignatureAlgorithm(String digestAlgorithm, String signatureAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestSignatureAlgorithm", digestAlgorithm, signatureAlgorithm);
        }
        String result = PKCS7.getDigestSignatureAlgorithm(digestAlgorithm, signatureAlgorithm, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", result);
        }
        return result;
    }

    public static String getDigestSignatureAlgorithm(String digestAlgorithm, String signatureAlgorithm, String provider) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{digestAlgorithm, signatureAlgorithm, provider};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", parms);
        }
        if (signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Signature algorithm must be specified.");
        }
        AlgorithmId digestAlg = AlgorithmId.get(digestAlgorithm);
        AlgorithmId signatureAlg = AlgorithmId.get(signatureAlgorithm);
        try {
            String result = PKCS7.getDigestSignatureAlgorithm(digestAlg, signatureAlg, provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestSignatureAlgorithm", e2);
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Unrecognized combination for digest algorithm " + digestAlgorithm + " and signature algorithm " + signatureAlgorithm + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized combination for digest algorithm " + digestAlgorithm + " and signature algorithm " + signatureAlgorithm + ".");
        }
    }

    public static String getDigestSignatureAlgorithm(AlgorithmId digestAlg, AlgorithmId signatureAlg) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{digestAlg, signatureAlg};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", parms);
        }
        String result = PKCS7.getDigestSignatureAlgorithm(digestAlg, signatureAlg, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", result);
        }
        return result;
    }

    public static String getDigestSignatureAlgorithm(AlgorithmId digestAlg, AlgorithmId signatureAlg, String provider) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{digestAlg, signatureAlg, provider};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", parms);
        }
        if (signatureAlg == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Signature algorithm must be specified.");
        }
        ObjectIdentifier digestOID = null;
        if (digestAlg != null) {
            digestOID = digestAlg.getOID();
        }
        ObjectIdentifier signatureOID = signatureAlg.getOID();
        String result = null;
        if (digestOID == null && signatureOID.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
            result = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, provider).getName();
        } else if (digestOID == null && signatureOID.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
            result = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, provider).getName();
        } else if (digestOID == null && signatureOID.equals(AlgorithmId.sha1WithDSA_oid)) {
            result = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, provider).getName();
        } else if (digestOID == null && (signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_oid) || signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
            result = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, provider).getName();
        } else if (digestOID != null) {
            if (digestOID.equals(AlgorithmId.MD2_oid) && signatureOID.equals(AlgorithmId.RSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.MD2_oid) && signatureOID.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.md2WithRSAEncryption_oid) && signatureOID.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.MD5_oid) && signatureOID.equals(AlgorithmId.RSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.MD5_oid) && signatureOID.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.md5WithRSAEncryption_oid) && signatureOID.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
                result = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.SHA_oid) && signatureOID.equals(AlgorithmId.DSA_oid)) {
                result = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.SHA_oid) && signatureOID.equals(AlgorithmId.sha1WithDSA_oid)) {
                result = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.sha1WithDSA_oid) && signatureOID.equals(AlgorithmId.sha1WithDSA_oid)) {
                result = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, provider).getName();
            } else if (digestOID.equals(AlgorithmId.SHA_oid)) {
                if (signatureOID.equals(AlgorithmId.RSAEncryption_oid) || signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_oid) || signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) {
                    result = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, provider).getName();
                }
            } else if ((digestOID.equals(AlgorithmId.sha1WithRSAEncryption_oid) || digestOID.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) && (signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_oid) || signatureOID.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
                result = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, provider).getName();
            }
        }
        if (result == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Unrecognized combination for digest algorithm " + digestAlg + " and signature algorithm " + signatureAlg + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized combination for digest algorithm " + digestAlg + " and signature algorithm " + signatureAlg + ".");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", result);
        }
        return result;
    }

    static byte[] stripOctetTags(byte[] encryptedContents) {
        byte[] processedContents;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "stripOctetTags", encryptedContents);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DerInputStream in = new DerInputStream(encryptedContents);
            while (in.available() != 0) {
                byte[] data = in.getOctetString();
                if (data == null) continue;
                out.write(data, 0, data.length);
            }
            processedContents = out.toByteArray();
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "stripOctetTags", e2);
            }
            processedContents = encryptedContents;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "stripOctetTags", processedContents);
        }
        return processedContents;
    }
}

