/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileUtility
implements IFileUtility {
    static final String SLASH = String.valueOf(File.separatorChar);
    private final String WLP_INSTALL_DIR;
    private final String WLP_USER_DIR;
    private final String WLP_OUTPUT_DIR;
    static final String NL = System.getProperty("line.separator");

    public FileUtility(String WLP_INSTALL_DIR, String WLP_USER_DIR, String WLP_OUTPUT_DIR) {
        File collectiveUtilityJarFile;
        this.getCollectiveUtilityJar();
        this.WLP_INSTALL_DIR = WLP_INSTALL_DIR == null ? ((collectiveUtilityJarFile = this.getCollectiveUtilityJar()) == null ? System.getProperty("user.dir") + SLASH : collectiveUtilityJarFile.getParentFile().getParentFile().getAbsolutePath() + SLASH) : (WLP_INSTALL_DIR.endsWith("/") || WLP_INSTALL_DIR.endsWith("\\") ? WLP_INSTALL_DIR : WLP_INSTALL_DIR + SLASH);
        this.WLP_USER_DIR = WLP_USER_DIR == null ? this.WLP_INSTALL_DIR + "usr" + SLASH : (WLP_USER_DIR.endsWith("/") || WLP_USER_DIR.endsWith("\\") ? WLP_USER_DIR : WLP_USER_DIR + SLASH);
        this.WLP_OUTPUT_DIR = WLP_OUTPUT_DIR == null ? this.WLP_USER_DIR + "servers" + SLASH : (WLP_OUTPUT_DIR.endsWith("/") || WLP_OUTPUT_DIR.endsWith("\\") ? WLP_OUTPUT_DIR : WLP_OUTPUT_DIR + SLASH);
    }

    @Override
    public String getInstallDir() {
        return this.WLP_INSTALL_DIR;
    }

    @Override
    public String getUserDir() {
        return this.WLP_USER_DIR;
    }

    @Override
    public String getOutputDirectory() {
        return this.WLP_OUTPUT_DIR;
    }

    @Override
    public boolean createParentDirectory(PrintStream stdout, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.exists()) {
            if (!this.createParentDirectory(stdout, parent)) {
                return false;
            }
            if (!parent.mkdir()) {
                stdout.println(CommandUtils.getMessage("fileUtility.failedDirCreate", this.resolvePath(parent)));
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public String resolvePath(String path) {
        return this.resolvePath(new File(path));
    }

    @Override
    public String resolvePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    @Override
    public boolean delete(String path) {
        File fPath = new File(path);
        return fPath.delete();
    }

    @Override
    public boolean exists(String path) {
        File fPath = new File(path);
        return fPath.exists();
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean recurisveDelete(String path) {
        return FileUtils.deleteQuietly((File)new File(path));
    }

    @Override
    public boolean recurisveDelete(File path) {
        return FileUtils.deleteQuietly((File)path);
    }

    @Override
    public boolean renameFile(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToFile(PrintStream stderr, String toWrite, File outFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            fos.write(toWrite.getBytes(Charset.forName("UTF-8")));
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            stderr.println(e.getMessage());
        }
        catch (IOException e) {
            stderr.println(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeBytesToFile(PrintStream stderr, byte[] bytesToWrite, File outputFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            fos.write(bytesToWrite);
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            stderr.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    private String getPath(URL url) {
        String encodedPath = RepositoryPathUtility.getURLEncodedPath((String)url.toString());
        return RepositoryPathUtility.decodeURLEncodedDir((String)encodedPath);
    }

    private File getCollectiveUtilityJar() {
        File launchHome = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.collective.utility.CollectiveUtility");
        }
        catch (Exception e) {
            return null;
        }
        URL home = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!home.getProtocol().equals("file")) {
            return null;
        }
        String path = this.getPath(home);
        launchHome = new File(path);
        return launchHome;
    }

    @Override
    public boolean isDirectoryEmpty(File file) {
        File[] files = file.listFiles();
        return files != null && files.length == 0;
    }

    @Override
    public Map<String, Integer> parseDeployVariablesXML(PrintStream stderr, File file) {
        HashMap<String, Integer> deployVars = new HashMap<String, Integer>();
        if (file.exists() && file.getName().equals("deployVariables.xml")) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = factory.newDocumentBuilder();
                Document document = db.parse(file);
                if (document != null) {
                    document.getDocumentElement().normalize();
                    NodeList nList = document.getElementsByTagName("variable");
                    for (int i = 0; i < nList.getLength(); ++i) {
                        Node node = nList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element element = (Element)node;
                        String name = element.getAttribute("name");
                        String value = element.getAttribute("value");
                        deployVars.put(name, Integer.parseInt(value));
                    }
                }
            }
            catch (SAXException e) {
                stderr.println(e.getMessage());
            }
            catch (Exception e) {
                stderr.println(e.getMessage());
            }
        }
        return deployVars;
    }

    @Override
    public String fixServerNameCase(String serverName) {
        String correctName = serverName;
        if (System.getProperty("os.name", "").toLowerCase().contains("win")) {
            File f = new File(this.getUserDir() + "servers" + SLASH + serverName);
            try {
                String dir = f.getCanonicalPath();
                correctName = dir.substring(dir.lastIndexOf(SLASH) + 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return correctName;
    }
}

