/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.IRepositoryConfigurationMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class RemoveReplicaTask
extends BaseCommandTask {
    private static final String className = RemoveReplicaTask.class.getName();
    private final IRepositoryConfigurationMBeanConnection repositoryMBean;

    public RemoveReplicaTask(String scriptName, IRepositoryConfigurationMBeanConnection repositoryMBean) {
        super(scriptName, null);
        this.repositoryMBean = repositoryMBean;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.addAutoAcceptAndDisableHostnameVerificationArguments();
    }

    @Override
    public String getTaskName() {
        return "removeReplica";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("removeReplica.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + this.buildScriptOptions("certProps.option-key.disableHostnameVerification", "certProps.option-desc.disableHostnameVerification");
        return this.getTaskHelp("removeReplica.desc", "removeReplica.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("removeReplica.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        Trlog.debug(className, methodName, "Validating command arguments...");
        this.validateArgumentList(args, false);
        Trlog.debug(className, methodName, "Parsing command arguments...");
        String endpoint = this.getTaskTarget(args);
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        this.handleAutoAcceptAndDisableHostnameVerificationArgs(args);
        this.removeReplica(endpoint, controllerHost, controllerPort, user, password);
    }

    private void removeReplica(String endpoint, String controllerHost, int controllerPort, String user, String password) throws TaskErrorException {
        String methodName = "removeReplica";
        Trlog.enter(password, methodName, new Object[]{endpoint, controllerHost, controllerPort, user, password.replaceAll(".", "*")});
        Trlog.debug(className, methodName, "Attempting to remove the endpoint from the replica set: " + endpoint);
        this.stdout.println(this.getMessage("removeReplica.attemptUnregister", new Object[0]));
        try {
            boolean successful = this.repositoryMBean.removeReplica(controllerHost, controllerPort, user, password, endpoint);
            if (successful) {
                Trlog.debug(className, methodName, "Successfully removed replica from the collective. endpoint: " + endpoint);
                this.stdout.println(this.getMessage("removeReplica.success", endpoint));
            } else {
                Trlog.debug(className, methodName, "Failed to remove replica, perhaps it was already removed. endpoint: " + endpoint);
                this.stdout.println(this.getMessage("removeReplica.alreadyRemoved", endpoint));
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", controllerHost), methodName);
        }
        catch (ConnectException e) {
            this.abort(this.getMessage("common.portError", String.valueOf(controllerPort)), methodName);
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
        }
        catch (KeyManagementException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
        }
        catch (InstanceNotFoundException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
        }
        catch (NoSuchAlgorithmException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
        }
        catch (ReflectionException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
        }
        catch (MBeanException e) {
            Trlog.debug(className, methodName, "Caught MBeanException, this happens if a declared exception is thrown.");
            if (e.getCause() instanceof UnknownHostException) {
                this.abort(this.getMessage("common.hostError", this.getEndpointHost(endpoint)), methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
            }
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.invalidEndpoint", endpoint), methodName);
            }
            if (e.getCause() instanceof UnknownHostException) {
                this.abort(this.getMessage("common.hostError", this.getEndpointHost(endpoint)), methodName);
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint), methodName);
        }
    }
}

