function buildLinksButton(linksURL) {
	linksURL.forEach(function(linkObj, index) {
		buildLinkButton(linkObj);
	});
}

function buildLinkButton(linkURL) {
	var desc = linkURL.name;
	var urls = linkURL.urls;

	if (urls.length > 0) {
		var url = urls[0];
		var updateUrl = getUpdateUrl(url);
		if (urls.length < 2) {
			// if it's the only url in the list
			// create the link without checking if the link is valid
			buildButtonLink(desc, updateUrl);
		} else {
			var request = new XMLHttpRequest();
			request.open('HEAD', updateUrl, true);
			request.onreadystatechange = function() {
				if (request.readyState === 4) {
					if (request.status === 200) {
						buildButtonLink(desc, updateUrl);
					} else {
						url = urls[1];
						updateUrl = getUpdateUrl(url);
						buildButtonLink(desc, updateUrl);
					}
				}
			};
			request.send();
		}
	}
}

function getUpdateUrl(url) {
	var updateUrl = url;
	if (url.startsWith("/")) {
		updateUrl = window.location.protocol + "//" + window.location.host
				+ url;
	} else if (url.startsWith("http")) {
		// leave as is		
	} else {
		// if url does not start with http for example openlibety.io then
		// it get appends to http://localhost:9080/openlibety.io instead of
		// just http://openliberty.io
		updateUrl = "http://" + url;
	}
	return updateUrl;
}

function buildButtonLink(desc, url) {
	var element = document.getElementById("welcome-section-content");
	var button = buildButton(url, desc);
	element.appendChild(button);
}

function buildButtonDirectLink(desc, url) {
	var updateURL = window.location.protocol + "//" + window.location.host
			+ url;
	var element = document.getElementById("welcome-section-content");
	var button = buildButton(updateURL, desc);
	element.appendChild(button);
}

function buildButton(url, description) {
	var anchor = document.createElement("div");
	anchor.setAttribute("class", "linkButton");
	var button = document.createElement("a");
	button.href = url;
	button.setAttribute("class", "btn btn-info");
	button.setAttribute("role", "button");
	var buttonText = document.createElement("h3");
	buttonText.innerHTML = description;
	var arrowImage = document.createElement("div");
	arrowImage.className = "right-carrot";
	button.appendChild(buttonText).appendChild(arrowImage);
	anchor.appendChild(button);
	return anchor;
}

function closeUpdateBanner() {
	var updateBanner = document.getElementById("update-banner");
	updateBanner.setAttribute("style", "display: none");
	var welcomeSection = document.getElementById("welcome-section");
	welcomeSection.setAttribute("style", "margin-top: 75px");
}

function updateBannerTabOrder(media) {
	var section = document.getElementById("update-banner");
	var firstChild = (section != null) ? section.firstChild : null;
	if (media.matches) { // If media query matches width <= 850px
		if (firstChild) {
			if (firstChild.id === "banner-container") {
				section.removeChild(firstChild);
				section.appendChild(firstChild);
			}
		}
	} else {
		if (firstChild) {
			if (firstChild.id !== "banner-container") {
				section.removeChild(firstChild);
				section.appendChild(firstChild);
			}
		}
	}
}

function buildUpdateBanner(messages) {
	if (isLibertyUpdateAvailable) {
		var section = document.createElement("section");
		section.setAttribute("id", "update-banner");
		section.setAttribute("aria-label", messages.UPDATE_BANNER_SECTION);

		var media = window.matchMedia("(max-width : 850px)");
		if (media.matches) {
			createCloseButton(section, messages);
			createDownloadLink(section, messages);
		} else {
			createDownloadLink(section, messages);
			createCloseButton(section, messages);
		}
		media.addListener(updateBannerTabOrder);

		var welcomeSection = document.getElementById("welcome-section");
		document.body.insertBefore(section, document.body.firstChild);
	}
}

function createCloseButton(section, messages) {
	var button = document.createElement("button");
	button.setAttribute("class", "x-close");
	button.setAttribute("onclick", "closeUpdateBanner()");
	button.setAttribute("aria-label", messages.UPDATE_BANNER_CLOSE_BUTTON);

	var right = document.createElement("div");
	right.setAttribute("class", "x-close-right-tilt");

	var left = document.createElement("div");
	left.setAttribute("class", "x-close-left-tilt");

	section.appendChild(button);
	button.appendChild(right);
	button.appendChild(left);
}

function createDownloadLink(section, messages) {
	var article = document.createElement("article");
	article.setAttribute("id", "banner-container");
	article.setAttribute("aria-label", messages.UPDATE_BANNER_SECTION);

	var h3 = document.createElement("article");
	h3.setAttribute("id", "banner-text");
	h3.setAttribute("class", "banner-text");
	h3.setAttribute("aria-label", messages.UPDATE_BANNER_SECTION_CONTENT);

	var span = document.createElement("span");
	span.setAttribute("class", "bolded");
	span.innerHTML = messages.HEADER_UPDATE_AVAILABLE;

	article.appendChild(h3);
	h3.appendChild(span);

	var msgDownload = formatString(messages.HEADER_DOWNLOAD_LINK,
			[ latestReleasedVersion.productName ]);
	var msgDownloadLink = "<a class='banner-downloadLink' href='"
			+ latestReleasedVersion.availableFrom + "'>" + msgDownload + "</a>";
	h3.innerHTML += msgDownloadLink;

	section.appendChild(article);
}

function updateTitleVersion(messages, version) {
	var msg = messages.WELCOME_TITLE;
	var title = formatString(msg, [ version ]);
	document.title = title;
}

function formatString(value, args) {
	for (var i = 0; i < args.length; i++) {
		var regexp = new RegExp('\\{' + i + '\\}', 'gi');
		value = value.replace(regexp, args[i]);
	}
	return value;
}

function updateCopyright(messages, id) {
	var msg = messages.IBM_LICENSED;
	var copyLink = '<a href="http://www.ibm.com/legal/copytrade.shtml">'
			+ messages.COPYRIGHT_URL + '</a>'
	msg = formatString(msg, [ copyLink ]);
	document.getElementById(id).innerHTML = msg;
}

function getVariableLinks(languageCode, links) {
    var varLinks = links;
    try {
        if (languageCode === "cs") {
            varLinks = links_cs;
	    } else if (languageCode === "de") {
	        varLinks = links_de;
		} else if (languageCode === "es") {
		    varLinks = links_es;
		} else if (languageCode === "fr") {
		    varLinks = links_fr;
		} else if (languageCode === "hu") {
		    varLinks = links_hu;
		} else if (languageCode === "it") {
		    varLinks = links_it;
		} else if (languageCode === "ja") {
		    varLinks = links_ja;
		} else if (languageCode === "ko") {
		    varLinks = links_ko;
		} else if (languageCode === "pl") {
		    varLinks = links_pl;
		} else if (languageCode === "pt-br") {
		    varLinks = links_pt-br;
		} else if (languageCode === "ro") {
		    varLinks = links_ro;
		} else if (languageCode === "ru") {
		    varLinks = links_ru;
        } else if (languageCode === "zh") {
            varLinks = links_zh;
        } else if (languageCode === "zh-tw") {
            varLinks = links_zh-tw;
        }
    } catch (err) {
        // if the variable is not define in wlp_links.js then default to variable links (english version)
    }
    return varLinks;
}

function buildContent(messages, linksURL) {
	buildUpdateBanner(messages);
    buildLinksButton(linksURL);
    updateCopyright(messages, "footer-copy");
}