/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.DefaultServletContextHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class WrappedHttpContext
extends DefaultServletContextHelper {
    private final HttpContext httpContext;
    private final Bundle bundle;

    public WrappedHttpContext(HttpContext httpContext, Bundle bundle) {
        super(bundle);
        this.httpContext = httpContext;
        this.bundle = bundle;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.httpContext.handleSecurity(request, response);
    }

    @Override
    public URL getResource(String name) {
        return this.httpContext.getResource(name);
    }

    @Override
    public String getMimeType(String name) {
        return this.httpContext.getMimeType(name);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        if (path == null || this.bundle == null) {
            return null;
        }
        Enumeration enumeration = this.bundle.findEntries(path, null, false);
        if (enumeration == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            result.add(((URL)enumeration.nextElement()).getPath());
        }
        return result;
    }
}

