/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.internal.DefaultServletContextHelperFactory;
import org.eclipse.equinox.http.servlet.internal.HttpServiceObjectRegistration;
import org.eclipse.equinox.http.servlet.internal.PreprocessorCustomizer;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.HttpContextHolder;
import org.eclipse.equinox.http.servlet.internal.dto.ExtendedErrorPageDTO;
import org.eclipse.equinox.http.servlet.internal.dto.ExtendedFailedServletContextDTO;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.error.PatternInUseException;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredFilterException;
import org.eclipse.equinox.http.servlet.internal.error.ServletAlreadyRegisteredException;
import org.eclipse.equinox.http.servlet.internal.registration.PreprocessorRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpSessionTracker;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.util.DTOUtil;
import org.eclipse.equinox.http.servlet.internal.util.Path;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.eclipse.equinox.http.servlet.internal.util.Throw;
import org.eclipse.equinox.http.servlet.internal.util.UMDictionaryMap;
import org.eclipse.equinox.http.servlet.session.HttpSessionInvalidator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.PreprocessorDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.service.http.whiteboard.Preprocessor;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpServiceRuntimeImpl
implements HttpServiceRuntime,
ServiceTrackerCustomizer<ServletContextHelper, AtomicReference<ContextController>> {
    private final Map<String, Object> attributes;
    private final String targetFilter;
    final ServiceRegistration<ServletContextHelper> defaultContextReg;
    private final ServletContext parentServletContext;
    private final BundleContext trackingContext;
    private final BundleContext consumingContext;
    private final org.osgi.framework.Filter errorPageServiceFilter;
    private final org.osgi.framework.Filter servletServiceFilter;
    private final org.osgi.framework.Filter resourceServiceFilter;
    private final org.osgi.framework.Filter filterServiceFilter;
    private final org.osgi.framework.Filter listenerServiceFilter;
    final ConcurrentMap<HttpContext, HttpContextHolder> legacyContextMap = new ConcurrentHashMap<HttpContext, HttpContextHolder>();
    private final Map<Object, HttpServiceObjectRegistration> legacyMappings = Collections.synchronizedMap(new HashMap());
    private final Map<Bundle, Set<HttpServiceObjectRegistration>> bundleRegistrations = new HashMap<Bundle, Set<HttpServiceObjectRegistration>>();
    private final Map<Bundle, Map<String, String>> bundleAliasCustomizations = new HashMap<Bundle, Map<String, String>>();
    private final ConcurrentMap<ServiceReference<ServletContextHelper>, ContextController> controllerMap = new ConcurrentSkipListMap(Collections.reverseOrder());
    private final ConcurrentMap<ServiceReference<Preprocessor>, PreprocessorRegistration> preprocessorMap = new ConcurrentSkipListMap(Collections.reverseOrder());
    final ConcurrentMap<ServiceReference<?>, FailedErrorPageDTO> failedErrorPageDTOs = new ConcurrentHashMap();
    final ConcurrentMap<ServiceReference<Filter>, FailedFilterDTO> failedFilterDTOs = new ConcurrentHashMap<ServiceReference<Filter>, FailedFilterDTO>();
    final ConcurrentMap<ServiceReference<EventListener>, FailedListenerDTO> failedListenerDTOs = new ConcurrentHashMap<ServiceReference<EventListener>, FailedListenerDTO>();
    final ConcurrentMap<ServiceReference<?>, FailedResourceDTO> failedResourceDTOs = new ConcurrentHashMap();
    final ConcurrentMap<ServiceReference<ServletContextHelper>, ExtendedFailedServletContextDTO> failedServletContextDTOs = new ConcurrentHashMap<ServiceReference<ServletContextHelper>, ExtendedFailedServletContextDTO>();
    final ConcurrentMap<ServiceReference<?>, FailedServletDTO> failedServletDTOs = new ConcurrentHashMap();
    final ConcurrentMap<ServiceReference<?>, FailedPreprocessorDTO> failedPreprocessorDTOs = new ConcurrentHashMap();
    private final Set<Object> registeredObjects = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ServiceTracker<LoggerFactory, Logger> loggerFactoryTracker;
    private final ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
    private final ServiceTracker<Preprocessor, AtomicReference<PreprocessorRegistration>> preprocessorServiceTracker;
    private final ServiceTracker<ContextPathCustomizer, ContextPathCustomizer> contextPathAdaptorTracker;
    private final ContextPathCustomizerHolder contextPathCustomizerHolder;
    private final HttpSessionTracker httpSessionTracker;
    private final ServiceRegistration<HttpSessionInvalidator> invalidatorReg;
    private final AtomicReference<ServiceRegistration<HttpServiceRuntime>> hsrRegistration = new AtomicReference();
    private final AtomicLong serviceChangecount = new AtomicLong();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Semaphore semaphore = new Semaphore(1);

    public HttpServiceRuntimeImpl(BundleContext trackingContext, BundleContext consumingContext, ServletContext parentServletContext, Dictionary<String, Object> attributes) {
        this.trackingContext = trackingContext;
        this.consumingContext = consumingContext;
        this.errorPageServiceFilter = HttpServiceRuntimeImpl.createErrorPageFilter(consumingContext);
        this.servletServiceFilter = HttpServiceRuntimeImpl.createServletFilter(consumingContext);
        this.resourceServiceFilter = HttpServiceRuntimeImpl.createResourceFilter(consumingContext);
        this.filterServiceFilter = HttpServiceRuntimeImpl.createFilterFilter(consumingContext);
        this.listenerServiceFilter = HttpServiceRuntimeImpl.createListenerFilter(consumingContext, parentServletContext);
        this.parentServletContext = parentServletContext;
        this.attributes = new UMDictionaryMap<String, Object>(attributes);
        this.targetFilter = "(equinox.http.id=" + this.attributes.get("equinox.http.id") + ")";
        this.httpSessionTracker = new HttpSessionTracker(this);
        this.invalidatorReg = trackingContext.registerService(HttpSessionInvalidator.class, (Object)this.httpSessionTracker, attributes);
        this.loggerFactoryTracker = new ServiceTracker(consumingContext, LoggerFactory.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<LoggerFactory, Logger>(){

            public Logger addingService(ServiceReference<LoggerFactory> reference) {
                return ((LoggerFactory)HttpServiceRuntimeImpl.this.getConsumingContext().getService(reference)).getLogger(HttpServiceRuntimeImpl.class);
            }

            public void modifiedService(ServiceReference<LoggerFactory> reference, Logger service) {
            }

            public void removedService(ServiceReference<LoggerFactory> reference, Logger service) {
            }
        });
        this.loggerFactoryTracker.open();
        this.contextServiceTracker = new ServiceTracker(trackingContext, ServletContextHelper.class, (ServiceTrackerCustomizer)this);
        this.preprocessorServiceTracker = new ServiceTracker(trackingContext, Preprocessor.class, (ServiceTrackerCustomizer)new PreprocessorCustomizer(this));
        this.contextPathCustomizerHolder = new ContextPathCustomizerHolder(consumingContext, this.contextServiceTracker);
        this.contextPathAdaptorTracker = new ServiceTracker(consumingContext, ContextPathCustomizer.class, (ServiceTrackerCustomizer)this.contextPathCustomizerHolder);
        Hashtable<String, Object> defaultContextProps = new Hashtable<String, Object>();
        defaultContextProps.put("osgi.http.whiteboard.context.name", "default");
        defaultContextProps.put("service.ranking", Integer.MIN_VALUE);
        defaultContextProps.put("osgi.http.whiteboard.context.path", "/");
        defaultContextProps.put("osgi.http.whiteboard.target", this.targetFilter);
        defaultContextProps.put("equinox.http.whiteboard.context.helper.default", Boolean.TRUE);
        this.defaultContextReg = consumingContext.registerService(ServletContextHelper.class, (ServiceFactory)new DefaultServletContextHelperFactory(), defaultContextProps);
    }

    public synchronized void open() {
        this.contextPathAdaptorTracker.open();
        this.contextServiceTracker.open();
        this.preprocessorServiceTracker.open();
    }

    public synchronized AtomicReference<ContextController> addingService(ServiceReference<ServletContextHelper> serviceReference) {
        AtomicReference<ContextController> result = new AtomicReference<ContextController>();
        if (!this.matches(serviceReference)) {
            return result;
        }
        try {
            try {
                ContextController contextController = new ContextController(this.trackingContext, this.consumingContext, serviceReference, this.parentServletContext, this);
                this.controllerMap.put(serviceReference, contextController);
                result.set(contextController);
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.debug(hwfe.getMessage(), hwfe);
                this.recordFailedServletContextDTO(serviceReference, 0L, hwfe.getFailureReason());
                this.incrementServiceChangecount();
            }
            catch (Throwable t) {
                this.error(t.getMessage(), t);
                this.recordFailedServletContextDTO(serviceReference, 0L, 4);
                this.incrementServiceChangecount();
            }
        }
        finally {
            this.incrementServiceChangecount();
        }
        return result;
    }

    public String adaptContextPath(String contextPath, ServiceReference<ServletContextHelper> helper) {
        String contextPrefix;
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null && (contextPrefix = pathAdaptor.getContextPathPrefix(helper)) != null && !contextPrefix.isEmpty() && !contextPrefix.equals("/")) {
            if (!contextPrefix.startsWith("/")) {
                contextPrefix = "/" + contextPrefix;
            }
            if (contextPath == null || contextPath.equals("/")) {
                contextPath = "";
            }
            return String.valueOf(contextPrefix) + contextPath;
        }
        return contextPath;
    }

    public BundleContext getConsumingContext() {
        return this.consumingContext;
    }

    public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null) {
            return pathAdaptor.getDefaultContextSelectFilter(httpWhiteBoardService);
        }
        return null;
    }

    public boolean isDefaultContext(ContextController contextController) {
        ServiceReference thisReference = this.defaultContextReg.getReference();
        ServiceReference<ServletContextHelper> contextReference = contextController.getServiceReference();
        if (thisReference == null) {
            throw new NullPointerException("Default Context Service reference is null. " + this);
        }
        if (contextReference == null) {
            throw new NullPointerException("Context Service reference is null. " + contextController);
        }
        return thisReference.equals(contextReference);
    }

    public boolean isFailedResourceDTO(ServiceReference<?> serviceReference) {
        return this.failedResourceDTOs.containsKey(serviceReference);
    }

    public boolean isFailedServletDTO(ServiceReference<?> serviceReference) {
        return this.failedServletDTOs.containsKey(serviceReference);
    }

    public boolean isFailedErrorPageDTO(ServiceReference<?> serviceReference) {
        return this.failedErrorPageDTOs.containsKey(serviceReference);
    }

    @Override
    public synchronized RequestInfoDTO calculateRequestInfoDTO(String path) {
        RequestInfoDTO requestInfoDTO = new RequestInfoDTO();
        requestInfoDTO.path = path;
        try {
            this.getDispatchTargets(path, requestInfoDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return requestInfoDTO;
    }

    public synchronized void destroy() {
        this.invalidatorReg.unregister();
        try {
            this.defaultContextReg.unregister();
        }
        catch (IllegalStateException illegalStateException) {}
        this.contextServiceTracker.close();
        this.contextPathAdaptorTracker.close();
        this.preprocessorServiceTracker.close();
        this.controllerMap.clear();
        this.preprocessorMap.clear();
        this.registeredObjects.clear();
        this.legacyContextMap.clear();
        this.failedErrorPageDTOs.clear();
        this.failedFilterDTOs.clear();
        this.failedListenerDTOs.clear();
        this.failedPreprocessorDTOs.clear();
        this.failedResourceDTOs.clear();
        this.failedServletContextDTOs.clear();
        this.failedServletDTOs.clear();
        this.httpSessionTracker.clear();
        this.registeredObjects.clear();
        this.scheduledExecutor.shutdown();
        this.loggerFactoryTracker.close();
    }

    public DispatchTargets getDispatchTargets(String pathString, RequestInfoDTO requestInfoDTO) {
        Path path = new Path(pathString);
        String queryString = path.getQueryString();
        String requestURI = path.getRequestURI();
        DispatchTargets dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.EXACT, requestInfoDTO);
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, path.getExtension(), queryString, Match.EXTENSION, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.REGEX, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.DEFAULT_SERVLET, requestInfoDTO);
        }
        if (dispatchTargets == null && "/".equals(pathString)) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.CONTEXT_ROOT, requestInfoDTO);
        }
        return dispatchTargets;
    }

    public HttpSessionTracker getHttpSessionTracker() {
        return this.httpSessionTracker;
    }

    public Set<Object> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public String getTargetFilter() {
        return this.targetFilter;
    }

    public ServletContext getParentServletContext() {
        return this.parentServletContext;
    }

    public List<String> getHttpServiceEndpoints() {
        return StringPlus.from(this.attributes.get("osgi.http.endpoint"));
    }

    @Override
    public synchronized RuntimeDTO getRuntimeDTO() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        runtimeDTO.failedErrorPageDTOs = this.getFailedErrorPageDTOs();
        runtimeDTO.failedFilterDTOs = this.getFailedFilterDTOs();
        runtimeDTO.failedListenerDTOs = this.getFailedListenerDTOs();
        runtimeDTO.failedPreprocessorDTOs = this.getFailedPreprocessorDTOs();
        runtimeDTO.failedResourceDTOs = this.getFailedResourceDTOs();
        runtimeDTO.failedServletContextDTOs = this.getFailedServletContextDTO();
        runtimeDTO.failedServletDTOs = this.getFailedServletDTOs();
        runtimeDTO.preprocessorDTOs = this.getPreprocessorDTOs();
        runtimeDTO.serviceDTO = this.getServiceDTO();
        runtimeDTO.servletContextDTOs = this.getServletContextDTOs();
        return runtimeDTO;
    }

    private FailedErrorPageDTO[] getFailedErrorPageDTOs() {
        Collection fepDTOs = this.failedErrorPageDTOs.values();
        ArrayList<FailedErrorPageDTO> copies = new ArrayList<FailedErrorPageDTO>();
        for (FailedErrorPageDTO failedErrorPageDTO : fepDTOs) {
            copies.add(DTOUtil.clone(failedErrorPageDTO));
        }
        return copies.toArray(new FailedErrorPageDTO[0]);
    }

    private ServiceReferenceDTO getServiceDTO() {
        ServiceReferenceDTO[] services;
        ServiceReferenceDTO[] serviceReferenceDTOArray = services = (ServiceReferenceDTO[])this.consumingContext.getBundle().adapt(ServiceReferenceDTO[].class);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            String[] serviceTypes;
            ServiceReferenceDTO serviceDTO = serviceReferenceDTOArray[n2];
            String[] stringArray = serviceTypes = (String[])serviceDTO.properties.get("objectClass");
            int n3 = serviceTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray[n4];
                if (HttpServiceRuntime.class.getName().equals(type)) {
                    return serviceDTO;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void debug(String message) {
        Logger logger = (Logger)this.loggerFactoryTracker.getService();
        if (logger == null) {
            this.parentServletContext.log(String.valueOf(message));
        } else {
            logger.debug(String.valueOf(message));
        }
    }

    public void debug(String message, Throwable t) {
        Logger logger = (Logger)this.loggerFactoryTracker.getService();
        if (logger == null) {
            this.parentServletContext.log(String.valueOf(message), t);
        } else {
            logger.debug(String.valueOf(message), (Object)t);
        }
    }

    public void error(String message, Throwable t) {
        Logger logger = (Logger)this.loggerFactoryTracker.getService();
        if (logger == null) {
            this.parentServletContext.log(String.valueOf(message), t);
        } else {
            logger.error(String.valueOf(message), (Object)t);
        }
    }

    public boolean matches(ServiceReference<?> serviceReference) {
        org.osgi.framework.Filter whiteboardTargetFilter;
        String target = (String)serviceReference.getProperty("osgi.http.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            whiteboardTargetFilter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return whiteboardTargetFilter.matches(this.attributes);
    }

    public boolean matchesAnyContext(ServiceReference<?> serviceReference) {
        for (ContextController contextController : this.controllerMap.values()) {
            if (!contextController.matches(serviceReference)) continue;
            return true;
        }
        return false;
    }

    public synchronized void modifiedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextController) {
        this.removedService(serviceReference, contextController);
        Object added = this.addingService((ServiceReference)serviceReference);
        contextController.set((ContextController)((AtomicReference)added).get());
    }

    public synchronized void removedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextControllerRef) {
        try {
            ContextController contextController = contextControllerRef.get();
            if (contextController != null) {
                Iterator iterator = this.failedServletContextDTOs.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (((ExtendedFailedServletContextDTO)((Object)iterator.next().getValue())).shadowingServiceId != contextController.getServiceId()) continue;
                    iterator.remove();
                }
                contextController.destroy();
            }
            this.failedServletContextDTOs.remove(serviceReference);
            this.controllerMap.remove(serviceReference);
            this.trackingContext.ungetService(serviceReference);
        }
        finally {
            this.incrementServiceChangecount();
        }
    }

    Collection<ContextController> getContextControllers(String requestURI) {
        int pos = requestURI.lastIndexOf(47);
        while (true) {
            ArrayList<ContextController> contextControllers = new ArrayList<ContextController>();
            for (ContextController contextController : this.controllerMap.values()) {
                if (!contextController.getContextPath().equals(requestURI)) continue;
                contextControllers.add(contextController);
            }
            if (!contextControllers.isEmpty()) {
                return contextControllers;
            }
            if (pos <= -1) break;
            requestURI = requestURI.substring(0, pos);
            pos = requestURI.lastIndexOf(47);
        }
        return null;
    }

    public Collection<ContextController> getContextControllers() {
        return this.controllerMap.values();
    }

    public DispatchTargets getDispatchTargets(String requestURI, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        Collection<ContextController> contextControllers = this.getContextControllers(requestURI);
        if (contextControllers == null || contextControllers.isEmpty()) {
            return null;
        }
        String contextPath = contextControllers.iterator().next().getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.CONTEXT_ROOT) {
            pathInfo = "/";
            servletPath = "";
        }
        while (true) {
            for (ContextController contextController : contextControllers) {
                DispatchTargets dispatchTargets = contextController.getDispatchTargets(null, requestURI, servletPath, pathInfo, extension, queryString, match, requestInfoDTO);
                if (dispatchTargets == null) continue;
                return dispatchTargets;
            }
            if (match == Match.EXACT || match == Match.CONTEXT_ROOT || match == Match.DEFAULT_SERVLET || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    private FailedFilterDTO[] getFailedFilterDTOs() {
        Collection ffDTOs = this.failedFilterDTOs.values();
        ArrayList<FailedFilterDTO> copies = new ArrayList<FailedFilterDTO>();
        for (FailedFilterDTO failedFilterDTO : ffDTOs) {
            copies.add(DTOUtil.clone(failedFilterDTO));
        }
        return copies.toArray(new FailedFilterDTO[0]);
    }

    private FailedListenerDTO[] getFailedListenerDTOs() {
        Collection flDTOs = this.failedListenerDTOs.values();
        ArrayList<FailedListenerDTO> copies = new ArrayList<FailedListenerDTO>();
        for (FailedListenerDTO failedListenerDTO : flDTOs) {
            copies.add(DTOUtil.clone(failedListenerDTO));
        }
        return copies.toArray(new FailedListenerDTO[0]);
    }

    private FailedResourceDTO[] getFailedResourceDTOs() {
        Collection frDTOs = this.failedResourceDTOs.values();
        ArrayList<FailedResourceDTO> copies = new ArrayList<FailedResourceDTO>();
        for (FailedResourceDTO failedResourceDTO : frDTOs) {
            copies.add(DTOUtil.clone(failedResourceDTO));
        }
        return copies.toArray(new FailedResourceDTO[0]);
    }

    private FailedServletContextDTO[] getFailedServletContextDTO() {
        Collection fscDTOs = this.failedServletContextDTOs.values();
        ArrayList<FailedServletContextDTO> copies = new ArrayList<FailedServletContextDTO>();
        for (FailedServletContextDTO failedServletContextDTO : fscDTOs) {
            copies.add(DTOUtil.clone(failedServletContextDTO));
        }
        return copies.toArray(new FailedServletContextDTO[0]);
    }

    private FailedServletDTO[] getFailedServletDTOs() {
        Collection fsDTOs = this.failedServletDTOs.values();
        ArrayList<FailedServletDTO> copies = new ArrayList<FailedServletDTO>();
        for (FailedServletDTO failedServletDTO : fsDTOs) {
            copies.add(DTOUtil.clone(failedServletDTO));
        }
        return copies.toArray(new FailedServletDTO[0]);
    }

    private FailedPreprocessorDTO[] getFailedPreprocessorDTOs() {
        Collection fpDTOs = this.failedPreprocessorDTOs.values();
        ArrayList<FailedPreprocessorDTO> copies = new ArrayList<FailedPreprocessorDTO>();
        for (FailedPreprocessorDTO failedPreprocessorDTO : fpDTOs) {
            copies.add(DTOUtil.clone(failedPreprocessorDTO));
        }
        return copies.toArray(new FailedPreprocessorDTO[0]);
    }

    public ServletContextDTO[] getServletContextDTOs() {
        ArrayList<ServletContextDTO> servletContextDTOs = new ArrayList<ServletContextDTO>();
        for (ContextController contextController : this.controllerMap.values()) {
            servletContextDTOs.add(contextController.getServletContextDTO());
        }
        return servletContextDTOs.toArray(new ServletContextDTO[0]);
    }

    public PreprocessorDTO[] getPreprocessorDTOs() {
        ArrayList<PreprocessorDTO> pDTOs = new ArrayList<PreprocessorDTO>();
        for (PreprocessorRegistration registration : this.preprocessorMap.values()) {
            pDTOs.add((PreprocessorDTO)((Object)registration.getD()));
        }
        return pDTOs.toArray(new PreprocessorDTO[0]);
    }

    public Map<ServiceReference<Preprocessor>, PreprocessorRegistration> getPreprocessorRegistrations() {
        return this.preprocessorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceFilter(Bundle bundle, String alias, Filter filter, Dictionary<String, String> initparams, HttpContextHolder httpContextHolder) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        ContextController.checkPattern(alias);
        if (!(alias.endsWith("/*") || alias.startsWith("*.") || alias.contains("/*."))) {
            alias = alias.endsWith("/") ? String.valueOf(alias) + '*' : String.valueOf(alias) + "/*";
        }
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            if (this.getRegisteredObjects().contains(filter)) {
                throw new RegisteredFilterException(filter);
            }
            HttpServiceObjectRegistration existing = this.legacyMappings.get(filter);
            if (existing != null) {
                throw new RegisteredFilterException(filter);
            }
            String filterName = filter.getClass().getName();
            if (initparams != null && initparams.get("filter-name") != null) {
                filterName = initparams.get("filter-name");
            }
            HttpServiceObjectRegistration objectRegistration = null;
            ServiceRegistration registration = null;
            try {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", alias);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.name", filterName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(equinox.legacy.context.helper=true)");
                ((Dictionary)props).put("equinox.context.select", this.getFilter(httpContextHolder.getServiceReference()));
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                ((Dictionary)props).put("service.ranking", HttpServiceRuntimeImpl.findFilterPriority(initparams));
                this.fillInitParams(props, initparams, "filter.init.");
                LegacyFilterFactory filterFactory = new LegacyFilterFactory(filter);
                registration = bundle.getBundleContext().registerService(Filter.class, (ServiceFactory)filterFactory, props);
                filterFactory.checkForError();
                objectRegistration = new HttpServiceObjectRegistration(filter, registration, httpContextHolder, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(httpContextHolder);
                    if (registration != null) {
                        registration.unregister();
                    }
                }
            }
        }
    }

    private void fillInitParams(Dictionary<String, Object> props, Dictionary<?, ?> initparams, String prefix) {
        if (initparams != null) {
            Enumeration<?> eKeys = initparams.keys();
            while (eKeys.hasMoreElements()) {
                String key = String.valueOf(eKeys.nextElement());
                String value = String.valueOf(initparams.get(key));
                if (value == null) continue;
                props.put(String.valueOf(prefix) + key, value);
            }
        }
    }

    private static int findFilterPriority(Dictionary<String, String> initparams) {
        if (initparams == null) {
            return 0;
        }
        String filterPriority = initparams.get("filter-priority");
        if (filterPriority == null) {
            return 0;
        }
        try {
            int result = Integer.parseInt(filterPriority);
            if (result >= -1000 && result <= 1000) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("filter-priority must be an integer between -1000 and 1000 but was: " + filterPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceResources(Bundle bundle, String alias, String name, HttpContextHolder httpContextHolder) throws NamespaceException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String pattern = alias;
        if (pattern.startsWith("/*.")) {
            pattern = pattern.substring(1);
        }
        if (!(pattern.endsWith("/*") || pattern.startsWith("*.") || pattern.contains("/*."))) {
            pattern = pattern.endsWith("/") ? String.valueOf(pattern) + '*' : String.valueOf(pattern) + "/*";
        }
        ContextController.checkPattern(alias);
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = null;
            ServiceRegistration registration = null;
            try {
                String fullAlias = this.getFullAlias(alias, httpContextHolder);
                HttpServiceObjectRegistration existing = this.legacyMappings.get(fullAlias);
                if (existing != null) {
                    throw new PatternInUseException(alias);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.pattern", pattern);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.prefix", name);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", this.getFilter(httpContextHolder.getServiceReference()));
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                registration = bundle.getBundleContext().registerService(String.class, (Object)"resource", props);
                objectRegistration = new HttpServiceObjectRegistration(fullAlias, registration, httpContextHolder, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
                if (aliasCustomizations == null) {
                    aliasCustomizations = new HashMap<String, String>();
                    this.bundleAliasCustomizations.put(bundle, aliasCustomizations);
                }
                aliasCustomizations.put(alias, fullAlias);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(httpContextHolder);
                    if (registration != null) {
                        registration.unregister();
                    }
                }
            }
        }
    }

    private Object getFilter(ServiceReference<? extends ServletContextHelper> serviceReference) {
        String ctxName = (String)serviceReference.getProperty("osgi.http.whiteboard.context.name");
        return String.format("(&(%s=%s)(%s=%s))", "osgi.http.whiteboard.context.httpservice", ctxName, "osgi.http.whiteboard.context.name", ctxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceServlet(Bundle bundle, String alias, Servlet servlet, Dictionary<?, ?> initparams, HttpContextHolder httpContextHolder) throws NamespaceException, ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ContextController.checkPattern((String)alias);
        String[] pattern = alias;
        if (!(alias.endsWith("/*") || alias.startsWith("*.") || alias.contains("/*."))) {
            pattern = alias.endsWith("/") ? new String[]{alias, String.valueOf(alias) + '*'} : new String[]{alias, String.valueOf(alias) + "/*"};
        }
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            LegacyServlet legacyServlet = new LegacyServlet(servlet);
            if (this.getRegisteredObjects().contains(legacyServlet)) {
                throw new ServletAlreadyRegisteredException(servlet);
            }
            HttpServiceObjectRegistration objectRegistration = null;
            ServiceRegistration registration = null;
            try {
                String fullAlias = this.getFullAlias((String)alias, httpContextHolder);
                HttpServiceObjectRegistration existing = this.legacyMappings.get(fullAlias);
                if (existing != null) {
                    throw new PatternInUseException((String)alias);
                }
                String servletName = servlet.getClass().getName();
                if (initparams != null && initparams.get("servlet-name") != null) {
                    servletName = String.valueOf(initparams.get("servlet-name"));
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", pattern);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", servletName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", this.getFilter(httpContextHolder.getServiceReference()));
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                this.fillInitParams(props, initparams, "servlet.init.");
                registration = bundle.getBundleContext().registerService(Servlet.class, (Object)legacyServlet, props);
                legacyServlet.checkForError();
                objectRegistration = new HttpServiceObjectRegistration(fullAlias, registration, httpContextHolder, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
                if (aliasCustomizations == null) {
                    aliasCustomizations = new HashMap<String, String>();
                    this.bundleAliasCustomizations.put(bundle, aliasCustomizations);
                }
                aliasCustomizations.put((String)alias, fullAlias);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(httpContextHolder);
                    if (registration != null) {
                        registration.unregister();
                    }
                }
            }
        }
    }

    private String getFullAlias(String alias, HttpContextHolder httpContextHolder) {
        ContextController controller;
        AtomicReference controllerRef = (AtomicReference)this.contextServiceTracker.getService(httpContextHolder.getServiceReference());
        if (controllerRef != null && (controller = (ContextController)controllerRef.get()) != null) {
            return String.valueOf(controller.getContextPath()) + alias;
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceAlias(Bundle bundle, String alias) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            String aliasCustomization;
            Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
            String string = aliasCustomization = aliasCustomizations == null ? null : aliasCustomizations.remove(alias);
            if (aliasCustomization == null) {
                throw new IllegalArgumentException("The bundle did not register the alias: " + alias);
            }
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(aliasCustomization);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for alias: " + alias);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the alias: " + alias);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.httpContextHolder);
            this.legacyMappings.remove(aliasCustomization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceFilter(Bundle bundle, Filter filter) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(filter);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for filter: " + filter);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the filter: " + filter);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.httpContextHolder);
            this.legacyMappings.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceObjects(Bundle bundle) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            this.bundleAliasCustomizations.remove(bundle);
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.remove(bundle);
            if (objectRegistrations != null) {
                for (HttpServiceObjectRegistration objectRegistration : objectRegistrations) {
                    try {
                        objectRegistration.registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    this.decrementFactoryUseCount(objectRegistration.httpContextHolder);
                    this.legacyMappings.remove(objectRegistration.serviceKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementFactoryUseCount(HttpContextHolder holder) {
        ConcurrentMap<HttpContext, HttpContextHolder> concurrentMap = this.legacyContextMap;
        synchronized (concurrentMap) {
            if (holder.decrementUseCount() == 0L) {
                this.legacyContextMap.remove(holder.getHttpContext());
            }
        }
    }

    private static org.osgi.framework.Filter createErrorPageFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("osgi.http.whiteboard.servlet.errorPage");
        sb.append("=*)");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createResourceFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.resource.pattern");
        sb.append("=*))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createServletFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.servlet.name");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createFilterFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Filter.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.filter.pattern");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.regex");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.servlet");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createListenerFilter(BundleContext context, ServletContext servletContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&");
        sb.append("(").append("osgi.http.whiteboard.listener").append("=*)");
        sb.append("(|");
        sb.append("(objectClass=").append(ServletContextListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletContextAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionAttributeListener.class.getName()).append(")");
        if (servletContext.getMajorVersion() >= 3 && servletContext.getMinorVersion() > 0) {
            sb.append("(objectClass=").append(HttpSessionIdListener.class.getName()).append(")");
        }
        sb.append(")");
        sb.append(")");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public org.osgi.framework.Filter getListenerFilter() {
        return this.listenerServiceFilter;
    }

    public org.osgi.framework.Filter getErrorPageFilter() {
        return this.errorPageServiceFilter;
    }

    public org.osgi.framework.Filter getFilterFilter() {
        return this.filterServiceFilter;
    }

    public org.osgi.framework.Filter getServletFilter() {
        return this.servletServiceFilter;
    }

    public org.osgi.framework.Filter getResourceFilter() {
        return this.resourceServiceFilter;
    }

    public void recordFailedErrorPageDTO(ServiceReference<?> serviceReference, FailedErrorPageDTO failedErrorPageDTO) {
        if (this.failedErrorPageDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedErrorPageDTOs.put(serviceReference, failedErrorPageDTO);
    }

    public void recordFailedFilterDTO(ServiceReference<Filter> serviceReference, FailedFilterDTO failedFilterDTO) {
        if (this.failedFilterDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedFilterDTOs.put(serviceReference, failedFilterDTO);
    }

    public void recordFailedListenerDTO(ServiceReference<EventListener> serviceReference, FailedListenerDTO failedListenerDTO) {
        if (this.failedListenerDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedListenerDTOs.put(serviceReference, failedListenerDTO);
    }

    public void recordFailedResourceDTO(ServiceReference<?> serviceReference, FailedResourceDTO failedResourceDTO) {
        if (this.failedResourceDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedResourceDTOs.put(serviceReference, failedResourceDTO);
    }

    public void recordFailedServletContextDTO(ServiceReference<ServletContextHelper> serviceReference, long shadowingServiceId, int failureReason) {
        ExtendedFailedServletContextDTO failedServletContextDTO = new ExtendedFailedServletContextDTO();
        failedServletContextDTO.attributes = Collections.emptyMap();
        failedServletContextDTO.contextPath = String.valueOf(serviceReference.getProperty("osgi.http.whiteboard.context.path"));
        failedServletContextDTO.errorPageDTOs = new ExtendedErrorPageDTO[0];
        failedServletContextDTO.failureReason = failureReason;
        failedServletContextDTO.filterDTOs = new FilterDTO[0];
        failedServletContextDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "context.init.");
        failedServletContextDTO.listenerDTOs = new ListenerDTO[0];
        failedServletContextDTO.name = String.valueOf(serviceReference.getProperty("osgi.http.whiteboard.context.name"));
        failedServletContextDTO.resourceDTOs = new ResourceDTO[0];
        failedServletContextDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedServletContextDTO.servletDTOs = new ServletDTO[0];
        failedServletContextDTO.shadowingServiceId = shadowingServiceId;
        this.failedServletContextDTOs.put(serviceReference, failedServletContextDTO);
    }

    public void recordFailedServletDTO(ServiceReference<?> serviceReference, FailedServletDTO failedServletDTO) {
        if (this.failedServletDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedServletDTOs.put(serviceReference, failedServletDTO);
    }

    public void recordFailedPreprocessorDTO(ServiceReference<Preprocessor> serviceReference, FailedPreprocessorDTO failedPreprocessorDTO) {
        if (this.failedPreprocessorDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedPreprocessorDTOs.put(serviceReference, failedPreprocessorDTO);
    }

    public void removeFailedErrorPageDTO(ServiceReference<Servlet> serviceReference) {
        this.failedErrorPageDTOs.remove(serviceReference);
    }

    public void removeFailedFilterDTO(ServiceReference<Filter> serviceReference) {
        this.failedFilterDTOs.remove(serviceReference);
    }

    public void removeFailedListenerDTO(ServiceReference<EventListener> serviceReference) {
        this.failedListenerDTOs.remove(serviceReference);
    }

    public void removeFailedResourceDTO(ServiceReference<Object> serviceReference) {
        this.failedResourceDTOs.remove(serviceReference);
    }

    public void removeFailedServletDTO(ServiceReference<Servlet> serviceReference) {
        this.failedServletDTOs.remove(serviceReference);
    }

    public void removeFailedPreprocessorDTO(ServiceReference<Preprocessor> serviceReference) {
        this.failedPreprocessorDTOs.remove(serviceReference);
    }

    public synchronized void fireSessionIdChanged(String oldSessionId) {
        for (ContextController contextController : this.controllerMap.values()) {
            contextController.fireSessionIdChanged(oldSessionId);
        }
    }

    public void sessionDestroyed(String sessionId) {
        this.httpSessionTracker.invalidate(sessionId, false);
    }

    public void setHsrRegistration(ServiceRegistration<HttpServiceRuntime> hsrRegistration) {
        this.hsrRegistration.set(hsrRegistration);
    }

    ServiceRegistration<HttpServiceRuntime> getHsrRegistration() {
        return this.hsrRegistration.get();
    }

    long getServiceChangecount() {
        return this.serviceChangecount.get();
    }

    public void incrementServiceChangecount() {
        this.serviceChangecount.incrementAndGet();
        if (this.hsrRegistration.get() != null && !this.scheduledExecutor.isShutdown() && this.semaphore.tryAcquire()) {
            this.scheduledExecutor.schedule(new ChangeCountTimer(), 100L, TimeUnit.MILLISECONDS);
        }
    }

    Semaphore getSemaphore() {
        return this.semaphore;
    }

    class ChangeCountTimer
    implements Callable<Void> {
        ChangeCountTimer() {
        }

        @Override
        public Void call() {
            try {
                Dictionary properties = HttpServiceRuntimeImpl.this.getHsrRegistration().getReference().getProperties();
                properties.put("service.changecount", HttpServiceRuntimeImpl.this.getServiceChangecount());
                HttpServiceRuntimeImpl.this.getHsrRegistration().setProperties(properties);
                return null;
            }
            finally {
                HttpServiceRuntimeImpl.this.getSemaphore().release();
            }
        }
    }

    static class ContextPathCustomizerHolder
    implements ServiceTrackerCustomizer<ContextPathCustomizer, ContextPathCustomizer> {
        private final BundleContext context;
        private final ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
        private final NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> pathCustomizers = new TreeMap(Collections.reverseOrder());

        public ContextPathCustomizerHolder(BundleContext context, ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker) {
            this.context = context;
            this.contextServiceTracker = contextServiceTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContextPathCustomizer addingService(ServiceReference<ContextPathCustomizer> reference) {
            ContextPathCustomizer service = (ContextPathCustomizer)this.context.getService(reference);
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                this.pathCustomizers.put(reference, service);
                reset = ((ServiceReference)this.pathCustomizers.firstKey()).equals(reference);
            }
            if (reset) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            return service;
        }

        public void modifiedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                ServiceReference currentFirst = (ServiceReference)this.pathCustomizers.firstKey();
                this.pathCustomizers.remove(reference);
                reset = currentFirst.equals(reference);
            }
            if (reset && this.contextServiceTracker.getTrackingCount() >= 0) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            this.context.ungetService(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ContextPathCustomizer getHighestRanked() {
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                Map.Entry<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> firstEntry = this.pathCustomizers.firstEntry();
                return firstEntry == null ? null : firstEntry.getValue();
            }
        }
    }

    public static class LegacyFilterFactory
    extends LegacyServiceObject
    implements PrototypeServiceFactory<Filter> {
        final Filter filter;

        public LegacyFilterFactory(Filter filter) {
            this.filter = filter;
        }

        public Filter getService(Bundle bundle, ServiceRegistration<Filter> registration) {
            return new LegacyFilter();
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Filter> registration, Filter service) {
        }

        class LegacyFilter
        implements Filter {
            LegacyFilter() {
            }

            public void init(FilterConfig filterConfig) throws ServletException {
                try {
                    LegacyFilterFactory.this.filter.init(filterConfig);
                    LegacyFilterFactory.this.error.set(null);
                }
                catch (Exception e) {
                    LegacyFilterFactory.this.error.set(e);
                    Throw.unchecked(e);
                }
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                LegacyFilterFactory.this.filter.doFilter(request, response, chain);
            }

            public void destroy() {
                LegacyFilterFactory.this.filter.destroy();
            }
        }
    }

    static class LegacyServiceObject {
        final AtomicReference<Exception> error = new AtomicReference<ServletException>(new ServletException("The init() method was never called."));

        LegacyServiceObject() {
        }

        public void checkForError() {
            Exception result = this.error.get();
            if (result != null) {
                Throw.unchecked(result);
            }
        }
    }

    static class LegacyServlet
    extends LegacyServiceObject
    implements Servlet {
        final Servlet servlet;

        public LegacyServlet(Servlet servlet) {
            this.servlet = servlet;
        }

        public void init(ServletConfig config) throws ServletException {
            try {
                this.servlet.init(config);
                this.error.set(null);
            }
            catch (Exception e) {
                this.error.set(e);
                Throw.unchecked(e);
            }
        }

        public ServletConfig getServletConfig() {
            return this.servlet.getServletConfig();
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            this.servlet.service(req, res);
        }

        public String getServletInfo() {
            return this.servlet.getServletInfo();
        }

        public void destroy() {
            this.servlet.destroy();
        }

        public int hashCode() {
            return this.servlet.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof LegacyServlet) {
                other = ((LegacyServlet)other).servlet;
            }
            return this.servlet.equals(other);
        }
    }
}

