/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal.blueprint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleBlueprintParser {
    public static final String DEFAULT_HEADER = "OSGI-INF/blueprint/*.xml";
    String _mfHeader = null;
    List<Path> _paths;
    static final long serialVersionUID = -962744960711758299L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BundleBlueprintParser(BundleManifest bundleMf) {
        String bundleBPHeader = bundleMf.getRawAttributes().getValue("Bundle-Blueprint");
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser(String bundleBPHeader) {
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser() {
        this.setup(null);
    }

    private void setup(String bundleBPHeader) {
        this._paths = new LinkedList<Path>();
        this._mfHeader = bundleBPHeader == null ? DEFAULT_HEADER : bundleBPHeader;
        List files = ManifestHeaderProcessor.split((String)this._mfHeader, (String)",");
        for (String fileClause : files) {
            String f;
            List yetMoreFiles = ManifestHeaderProcessor.split((String)fileClause, (String)";");
            Iterator iterator = yetMoreFiles.iterator();
            while (iterator.hasNext() && !(f = (String)iterator.next()).contains("=")) {
                if ((f = f.trim()).startsWith("\"") && f.endsWith("\"")) {
                    f = f.substring(1, f.length() - 1);
                }
                int index = f.lastIndexOf(47);
                String path = "";
                String file = f;
                if (index != -1) {
                    path = f.substring(0, index);
                    file = f.substring(index + 1);
                }
                this._paths.add(new Path(path, file));
            }
        }
    }

    public boolean isBPFile(String directory, String filename) {
        for (Path path : this._paths) {
            if (!path.matches(directory, filename)) continue;
            return true;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.BundleBlueprintParser", BundleBlueprintParser.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Path {
        String directory;
        String filename;
        Pattern filenamePattern;
        static final long serialVersionUID = 3098233815697987475L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Path(String d, String f) {
            this.directory = d;
            if (f.contains("*")) {
                this.filename = null;
                String pattern = f.replace(".", "\\.");
                pattern = pattern.replace("*", ".*");
                this.filenamePattern = Pattern.compile(pattern);
            } else {
                this.filename = f;
                this.filenamePattern = null;
            }
        }

        public boolean matches(String dir, String fil) {
            boolean match = false;
            match = !this.directory.equals(dir) ? false : (this.filename != null ? this.filename.equals(fil) : this.filenamePattern.matcher(fil).matches());
            return match;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.BundleBlueprintParser$Path", Path.class, null, null);
        }
    }
}

