/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.url.URLService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.annotation.impl.AnnotationScanner;
import org.apache.aries.jpa.container.annotation.impl.AnnotationScannerFactory;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.unit.impl.DataSourceFactoryDataSource;
import org.apache.aries.jpa.container.unit.impl.JndiDataSource;
import org.apache.aries.jpa.container.unit.impl.TempBundleDelegatingClassLoader;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistry;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistryFactory;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final Bundle bundle;
    private final ParsedPersistenceUnit unit;
    private final ServiceReference providerRef;
    private final Boolean useDataSourceFactory;
    private ClassTransformer transformer;
    private final AtomicReference<DataSourceFactoryDataSource> jtaDSFDS = new AtomicReference();
    private final AtomicReference<DataSourceFactoryDataSource> nonJtaDSFDS = new AtomicReference();
    private final AtomicReference<ClassLoader> cl = new AtomicReference();
    private static final Logger _logger;
    private static final String JDBC_PREFIX = "javax.persistence.jdbc.";
    static final long serialVersionUID = 9204722056837975580L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PersistenceUnitInfoImpl(Bundle b, ParsedPersistenceUnit parsedData, ServiceReference providerRef, Boolean globalUsedatasourcefactory) {
        this.bundle = b;
        this.unit = parsedData;
        this.providerRef = providerRef;
        Boolean localUseDataSourceFactory = Boolean.parseBoolean(this.getInternalProperties().getProperty("org.apache.aries.jpa.use.data.source.factory", "true"));
        this.useDataSourceFactory = globalUsedatasourcefactory != false && localUseDataSourceFactory != false;
    }

    public synchronized void addTransformer(ClassTransformer arg0) {
        TransformerRegistry reg = TransformerRegistryFactory.getTransformerRegistry();
        if (reg != null) {
            reg.addTransformer(this.bundle, arg0, this.providerRef);
            this.transformer = arg0;
        }
    }

    public boolean internalExcludeUnlistedClasses() {
        Boolean result = (Boolean)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.exclude.unlisted");
        return result == null ? false : result;
    }

    public boolean excludeUnlistedClasses() {
        return true;
    }

    public ClassLoader getClassLoader() {
        if (this.cl.get() == null) {
            this.cl.compareAndSet(null, AriesFrameworkUtil.getClassLoaderForced((Bundle)this.bundle));
        }
        return this.cl.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getJarFileUrls() {
        List jarFiles = (List)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.jar.files");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (jarFiles != null) {
            ServiceReference urlsr = null;
            URLService service = null;
            BundleContext ctx = null;
            try {
                Bundle thisBundle = FrameworkUtil.getBundle(this.getClass());
                ctx = thisBundle.getBundleContext();
                urlsr = ctx.getServiceReference(URLService.class);
                if (urlsr != null) {
                    service = (URLService)ctx.getService(urlsr);
                }
                for (String jarFile : jarFiles) {
                    URL originalUrl = this.bundle.getResource(jarFile);
                    URL url = null;
                    url = service != null ? service.convertURL(originalUrl, this.bundle) : originalUrl;
                    if (url == null) {
                        _logger.error(NLS.MESSAGES.getMessage("pu.not.found", new Object[]{this.getPersistenceUnitName(), this.bundle.getSymbolicName(), this.bundle.getVersion(), jarFile}));
                        continue;
                    }
                    urls.add(url);
                }
            }
            finally {
                if (ctx != null && service != null && urlsr != null) {
                    try {
                        ctx.ungetService(urlsr);
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"org.apache.aries.jpa.container.unit.impl.PersistenceUnitInfoImpl", (String)"174", (Object)this, (Object[])new Object[0]);
                    }
                }
            }
        }
        return urls;
    }

    public DataSource getJtaDataSource() {
        Properties props;
        String driverName;
        String jndiString = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.jta.datasource");
        DataSource toReturn = null;
        if (jndiString != null) {
            toReturn = new JndiDataSource(jndiString, this.getPersistenceUnitName(), this.bundle, this.getTransactionType() == PersistenceUnitTransactionType.JTA);
        } else if (this.useDataSourceFactory.booleanValue() && (toReturn = (DataSource)this.jtaDSFDS.get()) == null && (driverName = (props = this.getInternalProperties()).getProperty("javax.persistence.jdbc.driver")) != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("using.datasource.factory", new Object[]{this.getPersistenceUnitName(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            boolean jta = this.getTransactionType() == PersistenceUnitTransactionType.JTA;
            this.jtaDSFDS.compareAndSet(null, new DataSourceFactoryDataSource(this.bundle, driverName, this.getDsProps(props), jta));
            toReturn = this.jtaDSFDS.get();
        }
        return toReturn;
    }

    public List<String> getManagedClassNames() {
        AnnotationScanner scanner;
        ArrayList<String> classes = (ArrayList<String>)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.managed.classes");
        if (classes == null) {
            classes = new ArrayList<String>();
        }
        if (!this.internalExcludeUnlistedClasses() && (scanner = AnnotationScannerFactory.getAnnotationScanner()) != null) {
            classes.addAll(scanner.findJPAAnnotatedClasses(this.bundle));
        }
        return Collections.unmodifiableList(classes);
    }

    public List<String> getMappingFileNames() {
        ArrayList mappingFiles = (ArrayList)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.mapping.files");
        if (mappingFiles == null) {
            mappingFiles = new ArrayList();
        }
        return Collections.unmodifiableList(mappingFiles);
    }

    public ClassLoader getNewTempClassLoader() {
        ClassLoader cl = AriesFrameworkUtil.getClassLoader((Bundle)this.providerRef.getBundle());
        return new TempBundleDelegatingClassLoader(this.bundle, cl);
    }

    public DataSource getNonJtaDataSource() {
        Properties props;
        String driverName;
        String jndiString = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.non.jta.datasource");
        DataSource toReturn = null;
        if (jndiString != null) {
            toReturn = new JndiDataSource(jndiString, this.getPersistenceUnitName(), this.bundle, false);
        } else if (this.useDataSourceFactory.booleanValue() && (toReturn = (DataSource)this.nonJtaDSFDS.get()) == null && (driverName = (props = this.getInternalProperties()).getProperty("javax.persistence.jdbc.driver")) != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("using.datasource.factory", new Object[]{this.getPersistenceUnitName(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            this.nonJtaDSFDS.compareAndSet(null, new DataSourceFactoryDataSource(this.bundle, driverName, this.getDsProps(props), false));
            toReturn = this.nonJtaDSFDS.get();
        }
        return toReturn;
    }

    public String getPersistenceProviderClassName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.provider");
    }

    public String getPersistenceUnitName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.unit.name");
    }

    public URL getPersistenceUnitRootUrl() {
        return this.bundle.getResource("/");
    }

    public String getPersistenceXMLSchemaVersion() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.schema.version");
    }

    private Properties getInternalProperties() {
        return (Properties)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.properties");
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getInternalProperties());
        p.put("eclipselink.target-server", "WebSphere_liberty");
        String jdbcClass = p.getProperty("javax.persistence.jdbc.driver");
        if (this.useDataSourceFactory.booleanValue() && jdbcClass != null) {
            p.setProperty("org.apache.aries.jpa.data.source.factory.class", jdbcClass);
            p.remove("javax.persistence.jdbc.driver");
        }
        return p;
    }

    public SharedCacheMode getSharedCacheMode() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa2.shared.cache.mode");
        if (s == null) {
            return SharedCacheMode.UNSPECIFIED;
        }
        return SharedCacheMode.valueOf((String)s);
    }

    public PersistenceUnitTransactionType getTransactionType() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.transaction.type");
        if (s == null) {
            return PersistenceUnitTransactionType.JTA;
        }
        return PersistenceUnitTransactionType.valueOf((String)s);
    }

    public ValidationMode getValidationMode() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa2.validation.mode");
        if (s == null) {
            return ValidationMode.AUTO;
        }
        return ValidationMode.valueOf((String)s);
    }

    public synchronized void clearUp() {
        if (this.transformer != null) {
            TransformerRegistry reg = TransformerRegistryFactory.getTransformerRegistry();
            reg.removeTransformer(this.bundle, this.transformer);
            this.transformer = null;
        }
    }

    public void unregistered() {
        DataSourceFactoryDataSource dsfds = this.jtaDSFDS.get();
        if (dsfds != null) {
            dsfds.closeTrackers();
        }
        if ((dsfds = this.nonJtaDSFDS.get()) != null) {
            dsfds.closeTrackers();
        }
    }

    private Properties getDsProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(JDBC_PREFIX) || key.equals("javax.persistence.jdbc.driver")) continue;
            dsProps.put(key.substring(JDBC_PREFIX.length()), props.get(key));
        }
        return dsProps;
    }

    public String getDataSourceName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.non.jta.datasource");
    }

    public String getJtaDataSourceName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.jta.datasource");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.aries.jpa.container.unit.impl.PersistenceUnitInfoImpl", PersistenceUnitInfoImpl.class, null, null);
        _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    }
}

