/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.blueprint.xml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.annotation.scanning.JPAAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceContextAnnotation;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintElement;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintElementFactory;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintHandler;
import java.util.Collection;
import java.util.Map;

class JPAAnnotationHandler {
    private static final TraceComponent th = Tr.register(JPAAnnotationHandler.class, (String)"Aries.jpa", (String)"com.ibm.ws.eba.jpa.nls.CWSAFAnnotationMessages");
    private final AnnotationSource annotationSource;
    private boolean changed = false;

    JPAAnnotationHandler(AnnotationSource as, BluePrintHandler rootHandler) {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"JPAAnnotationHandler", (Object[])new Object[]{as, rootHandler});
        }
        this.annotationSource = as;
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"JPAAnnotationHandler", (Object)this);
        }
    }

    public boolean isChanged() {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"isChanged", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"isChanged", (Object)this.changed);
        }
        return this.changed;
    }

    public void startElement(BluePrintElement element) {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"startElement", (Object[])new Object[]{element});
        }
        if (this.isComponentElement(element)) {
            String className = element.getAttribute("http://www.osgi.org/xmlns/blueprint/v1.0.0", "class", true);
            if (className == null) {
                className = element.getAttribute("http://www.osgi.org/xmlns/blueprint-compendium/v1.0.0", "class");
            }
            if (className != null) {
                this.enhanceComponent(element, className);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"startElement");
        }
    }

    private void enhanceComponent(BluePrintElement element, String className) {
        Collection<JPAAnnotation> ans;
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"enhanceComponent", (Object[])new Object[]{element, className});
        }
        if ((ans = this.annotationSource.getAnnotations(className)) != null) {
            for (JPAAnnotation an : ans) {
                this.addComponentProperty(element, an);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"enhanceComponent");
        }
    }

    private void addComponentProperty(BluePrintElement element, JPAAnnotation annotation) {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"addComponentProperty", (Object[])new Object[]{element, annotation});
        }
        this.changed = true;
        this.addJPAElement(element, annotation);
        if (annotation.getTargetType() == JPAAnnotation.Target.Field) {
            this.addFieldInjection(element);
        }
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"addComponentProperty");
        }
    }

    private void addJPAElement(BluePrintElement parent, JPAAnnotation an) {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"addJPAElement", (Object[])new Object[]{parent, an});
        }
        String tag = an.getType() == JPAAnnotation.Type.PersistenceContext ? "context" : "unit";
        BluePrintElementFactory fac = new BluePrintElementFactory();
        BluePrintElementFactory.FlowElement fe = fac.newChildElement(parent, "http://aries.apache.org/xmlns/jpa/v1.0.0", tag).attribute("property", an.getTargetName()).attribute("unitname", an.getUnitName());
        if (an.getType() == JPAAnnotation.Type.PersistenceContext) {
            PersistenceContextAnnotation pca = (PersistenceContextAnnotation)an;
            fe = fe.attribute("type", pca.getContextType().toString());
            Map<String, String> props = pca.getProperties();
            if (props != null && !props.isEmpty()) {
                BluePrintElementFactory.FlowElement me = fe.element("http://www.osgi.org/xmlns/blueprint/v1.0.0", "map");
                for (Map.Entry<String, String> e : props.entrySet()) {
                    me.element("http://www.osgi.org/xmlns/blueprint/v1.0.0", "entry").attribute("key", e.getKey()).attribute("value", e.getValue()).finish();
                }
                me.finish();
            }
        }
        fe.finish();
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"addJPAElement");
        }
    }

    private void addFieldInjection(BluePrintElement element) {
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"addFieldInjection", (Object[])new Object[]{element});
        }
        if (!element.hasAttribute("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "field-injection")) {
            String startPrefix;
            Map<String, String> ns = element.getNamespaces();
            String currentPrefix = startPrefix = "ext";
            int counter = 0;
            while (ns.containsKey(currentPrefix) && !ns.get(currentPrefix).equals("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0")) {
                currentPrefix = startPrefix + counter;
                ++counter;
            }
            element.addNamespace(currentPrefix, "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0");
            element.setAttribute("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "field-injection", currentPrefix + ":" + "field-injection", "true");
        } else {
            element.setAttribute("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "field-injection", null, "true");
        }
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"addFieldInjection");
        }
    }

    private boolean isComponentElement(BluePrintElement element) {
        boolean isManComponent;
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.entry((TraceComponent)th, (String)"isComponentElement", (Object[])new Object[]{element});
        }
        String uri = element.getUri();
        String tag = element.getLocalName();
        boolean isComponent = (uri.equals("") || uri.equals("http://www.osgi.org/xmlns/blueprint/v1.0.0")) && tag.equals("bean");
        boolean bl = isManComponent = uri.equals("http://www.osgi.org/xmlns/blueprint-compendium/v1.0.0") && tag.equals("managed-component");
        if (TraceComponent.isAnyTracingEnabled() && th.isEntryEnabled()) {
            Tr.exit((TraceComponent)th, (String)"isComponentElement");
        }
        return isComponent || isManComponent;
    }
}

