/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.annotation.scanning;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.annotation.scanning.BlueprintAnnotations;
import com.ibm.ws.eba.jpa.annotation.scanning.BlueprintAnnotationsBetaHelper;
import com.ibm.ws.eba.jpa.annotation.scanning.JPAAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceContextAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceUnitAnnotation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.FieldInfo;
import com.ibm.wsspi.anno.info.Info;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JpAnnotationSource
implements AnnotationSource {
    private final Bundle bundle;
    private final Container container;
    private final AnnotationTargets_Targets annotationTargets;
    private final InfoStore infoStore;
    private final Map<String, List<FieldAnnotationTarget>> persistenceUnitFieldAnnotations;
    private final Map<String, List<FieldAnnotationTarget>> persistenceContextFieldAnnotations;
    private final Map<String, List<MethodAnnotationTarget>> persistenceUnitMethodAnnotations;
    private final Map<String, List<MethodAnnotationTarget>> persistenceContextMethodAnnotations;
    static final long serialVersionUID = -2203128487894497026L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JpAnnotationSource(Container container, Bundle bundle) throws UnableToAdaptException {
        this.bundle = bundle;
        this.container = container;
        BlueprintAnnotations blueprintAnnotations = this.getBlueprintAnnotations();
        this.annotationTargets = blueprintAnnotations.getWebModuleAnnotationTargets();
        this.infoStore = blueprintAnnotations.getWebModuleInfoStore();
        this.persistenceUnitFieldAnnotations = this.getFieldTargets(PersistenceUnit.class.getName());
        this.persistenceUnitMethodAnnotations = this.getMethodTargets(PersistenceUnit.class.getName());
        this.persistenceContextFieldAnnotations = this.getFieldTargets(PersistenceContext.class.getName());
        this.persistenceContextMethodAnnotations = this.getMethodTargets(PersistenceContext.class.getName());
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Container getDeployedModule() {
        return this.container;
    }

    private BlueprintAnnotations getBlueprintAnnotations() throws UnableToAdaptException {
        return BlueprintAnnotationsBetaHelper.getBlueprintAnnotations(this.getDeployedModule(), this.getBundle());
    }

    public AnnotationTargets_Targets getAnnotationTargets() {
        return this.annotationTargets;
    }

    public InfoStore getInfoStore() {
        return this.infoStore;
    }

    public List<ClassAnnotationTarget> getClassTargets(String annotationClassName) {
        Set annotatedClassNames = this.getAnnotationTargets().getAnnotatedClasses(annotationClassName);
        ArrayList<ClassAnnotationTarget> classTargets = new ArrayList<ClassAnnotationTarget>(annotatedClassNames.size());
        InfoStore useInfoStore = this.getInfoStore();
        for (String annotatedClassName : annotatedClassNames) {
            ClassInfo classInfo = useInfoStore.getDelayableClassInfo(annotatedClassName);
            AnnotationInfo annotationInfo = classInfo.getDeclaredAnnotation(annotationClassName);
            ClassAnnotationTarget classAnnotationTarget = new ClassAnnotationTarget(classInfo, annotationInfo);
            classTargets.add(classAnnotationTarget);
        }
        return classTargets;
    }

    public List<FieldAnnotationTarget> getDeclaredFieldTargets(String annotationClassName) {
        Set annotatedClassNames = this.getAnnotationTargets().getClassesWithFieldAnnotation(annotationClassName);
        ArrayList<FieldAnnotationTarget> allFieldTargets = new ArrayList<FieldAnnotationTarget>(annotatedClassNames.size());
        InfoStore useInfoStore = this.getInfoStore();
        for (String annotatedClassName : annotatedClassNames) {
            ClassInfo classInfo = useInfoStore.getDelayableClassInfo(annotatedClassName);
            for (FieldInfo fieldInfo : classInfo.getDeclaredFields()) {
                AnnotationInfo annotationInfo = fieldInfo.getDeclaredAnnotation(annotationClassName);
                if (annotationInfo == null) continue;
                FieldAnnotationTarget fieldTarget = new FieldAnnotationTarget(classInfo, fieldInfo, annotationInfo);
                allFieldTargets.add(fieldTarget);
            }
        }
        return allFieldTargets;
    }

    public Map<String, List<FieldAnnotationTarget>> getFieldTargets(String annotationClassName) {
        Set annotatedClassNames = this.getAnnotationTargets().getClassesWithFieldAnnotation(annotationClassName);
        HashMap<String, List<FieldAnnotationTarget>> allFieldTargets = new HashMap<String, List<FieldAnnotationTarget>>(annotatedClassNames.size());
        InfoStore useInfoStore = this.getInfoStore();
        for (String annotatedClassName : annotatedClassNames) {
            ClassInfo classInfo = useInfoStore.getDelayableClassInfo(annotatedClassName);
            ArrayList<FieldAnnotationTarget> oneClassFieldTargets = new ArrayList<FieldAnnotationTarget>();
            for (FieldInfo fieldInfo : classInfo.getDeclaredFields()) {
                AnnotationInfo annotationInfo = fieldInfo.getAnnotation(annotationClassName);
                if (annotationInfo == null) continue;
                FieldAnnotationTarget fieldTarget = new FieldAnnotationTarget(classInfo, fieldInfo, annotationInfo);
                oneClassFieldTargets.add(fieldTarget);
            }
            allFieldTargets.put(annotatedClassName, oneClassFieldTargets);
        }
        return allFieldTargets;
    }

    public List<MethodAnnotationTarget> getDeclaredMethodTargets(String annotationClassName) {
        Set annotatedClassNames = this.getAnnotationTargets().getClassesWithMethodAnnotation(annotationClassName);
        ArrayList<MethodAnnotationTarget> allMethodTargets = new ArrayList<MethodAnnotationTarget>(annotatedClassNames.size());
        InfoStore useInfoStore = this.getInfoStore();
        for (String annotatedClassName : annotatedClassNames) {
            ClassInfo classInfo = useInfoStore.getDelayableClassInfo(annotatedClassName);
            for (MethodInfo methodInfo : classInfo.getDeclaredMethods()) {
                AnnotationInfo annotationInfo = methodInfo.getDeclaredAnnotation(annotationClassName);
                if (annotationInfo == null) continue;
                MethodAnnotationTarget methodTarget = new MethodAnnotationTarget(classInfo, methodInfo, annotationInfo);
                allMethodTargets.add(methodTarget);
            }
        }
        return allMethodTargets;
    }

    public Map<String, List<MethodAnnotationTarget>> getMethodTargets(String annotationClassName) {
        Set annotatedClassNames = this.getAnnotationTargets().getClassesWithMethodAnnotation(annotationClassName);
        HashMap<String, List<MethodAnnotationTarget>> allMethodTargets = new HashMap<String, List<MethodAnnotationTarget>>(annotatedClassNames.size());
        InfoStore useInfoStore = this.getInfoStore();
        for (String annotatedClassName : annotatedClassNames) {
            ClassInfo classInfo = useInfoStore.getDelayableClassInfo(annotatedClassName);
            ArrayList<MethodAnnotationTarget> oneClassMethodTargets = new ArrayList<MethodAnnotationTarget>();
            for (MethodInfo methodInfo : classInfo.getDeclaredMethods()) {
                AnnotationInfo annotationInfo = methodInfo.getAnnotation(annotationClassName);
                if (annotationInfo == null) continue;
                MethodAnnotationTarget methodTarget = new MethodAnnotationTarget(classInfo, methodInfo, annotationInfo);
                oneClassMethodTargets.add(methodTarget);
            }
            allMethodTargets.put(annotatedClassName, oneClassMethodTargets);
        }
        return allMethodTargets;
    }

    private PersistenceUnitAnnotation convertPersistenceUnitAnnotation(Info info) {
        AnnotationValue unitNameValue;
        AnnotationValue nameValue;
        try {
            AnnotationInfo annotationInfo = info.getAnnotation(PersistenceUnit.class);
            nameValue = annotationInfo.getCachedAnnotationValue("name");
            unitNameValue = annotationInfo.getCachedAnnotationValue("unitName");
        }
        catch (Exception annotationInfo) {
            FFDCFilter.processException((Throwable)annotationInfo, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"312", (Object)this, (Object[])new Object[]{info});
            nameValue = null;
            unitNameValue = null;
        }
        return new PersistenceUnitAnnotation(nameValue != null ? nameValue.getStringValue() : null, unitNameValue != null ? unitNameValue.getStringValue() : null, info instanceof MethodInfo ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName(info));
    }

    private PersistenceContextAnnotation convertPersistenceContextAnnotation(Info info) {
        AnnotationValue propertiesValue;
        AnnotationValue contextValue;
        AnnotationValue unitNameValue;
        AnnotationValue nameValue;
        try {
            AnnotationInfo annotationInfo = info.getAnnotation(PersistenceContext.class);
            nameValue = annotationInfo.getCachedAnnotationValue("name");
            unitNameValue = annotationInfo.getCachedAnnotationValue("unitName");
            contextValue = annotationInfo.getCachedAnnotationValue("context");
            propertiesValue = annotationInfo.getCachedAnnotationValue("properties");
        }
        catch (Exception annotationInfo) {
            FFDCFilter.processException((Throwable)annotationInfo, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"339", (Object)this, (Object[])new Object[]{info});
            contextValue = null;
            nameValue = null;
            unitNameValue = null;
            propertiesValue = null;
        }
        PersistenceContextAnnotation.ContextType contextType = contextValue != null && contextValue.getStringValue().equals("EXTENDED") ? PersistenceContextAnnotation.ContextType.EXTENDED : PersistenceContextAnnotation.ContextType.TRANSACTION;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propertiesValue != null) {
            for (AnnotationValue annotationValue : propertiesValue.getArrayValue()) {
                PersistenceProperty property = (PersistenceProperty)annotationValue.getObjectValue();
                properties.put(property.name(), property.value());
            }
        }
        return new PersistenceContextAnnotation(nameValue != null ? nameValue.getStringValue() : null, unitNameValue != null ? unitNameValue.getStringValue() : null, info instanceof MethodInfo ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName(info), contextType, properties);
    }

    private String getPropertyName(Info info) {
        String name = info.getName();
        if (!(info instanceof MethodInfo)) {
            return name;
        }
        if (!name.startsWith("get") && !name.startsWith("set")) {
            return name;
        }
        char c0 = (name = name.substring(3)).charAt(0);
        if (!Character.isUpperCase(c0)) {
            return name;
        }
        if (name.length() < 2) {
            return Character.toString(Character.toLowerCase(c0));
        }
        char c1 = name.charAt(1);
        if (Character.isUpperCase(c1)) {
            return name;
        }
        return Character.toString(Character.toLowerCase(c0)) + name.substring(1);
    }

    @Override
    public Collection<JPAAnnotation> getAnnotations(String className) {
        ArrayList<JPAAnnotation> jpaAnnotations = new ArrayList<JPAAnnotation>();
        AnnotationTargets_Targets useTargets = this.getAnnotationTargets();
        while (className != null) {
            List<MethodAnnotationTarget> list;
            List<MethodAnnotationTarget> list2;
            List<FieldAnnotationTarget> contextFieldTargets;
            List<FieldAnnotationTarget> unitFieldTargets = this.persistenceUnitFieldAnnotations.get(className);
            if (unitFieldTargets != null) {
                for (FieldAnnotationTarget fieldAnnotationTarget : unitFieldTargets) {
                    jpaAnnotations.add(this.convertPersistenceUnitAnnotation((Info)fieldAnnotationTarget.targetFieldInfo));
                }
            }
            if ((contextFieldTargets = this.persistenceContextFieldAnnotations.get(className)) != null) {
                for (FieldAnnotationTarget fieldAnnotationTarget : contextFieldTargets) {
                    jpaAnnotations.add(this.convertPersistenceContextAnnotation((Info)fieldAnnotationTarget.targetFieldInfo));
                }
            }
            if ((list2 = this.persistenceUnitMethodAnnotations.get(className)) != null) {
                for (MethodAnnotationTarget methodTarget : list2) {
                    jpaAnnotations.add(this.convertPersistenceUnitAnnotation((Info)methodTarget.targetMethodInfo));
                }
            }
            if ((list = this.persistenceContextMethodAnnotations.get(className)) != null) {
                for (MethodAnnotationTarget methodTarget : list) {
                    jpaAnnotations.add(this.convertPersistenceContextAnnotation((Info)methodTarget.targetMethodInfo));
                }
            }
            className = useTargets.getSuperclassName(className);
        }
        return jpaAnnotations;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", JpAnnotationSource.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ClassAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = -4421661017441598176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassAnnotationTarget(ClassInfo targetClassInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource$ClassAnnotationTarget", ClassAnnotationTarget.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class FieldAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final FieldInfo targetFieldInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = 8061559271760855279L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FieldAnnotationTarget(ClassInfo targetClassInfo, FieldInfo targetFieldInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetFieldInfo = targetFieldInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource$FieldAnnotationTarget", FieldAnnotationTarget.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class MethodAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final MethodInfo targetMethodInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = -1966277689778809768L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MethodAnnotationTarget(ClassInfo targetClassInfo, MethodInfo targetMethodInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetMethodInfo = targetMethodInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource$MethodAnnotationTarget", MethodAnnotationTarget.class, null, null);
        }
    }
}

