/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.annocache.scanning;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.annocache.Annotations;
import com.ibm.ws.container.service.annocache.SpecificAnnotations;
import com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsAdapterImpl;
import com.ibm.ws.eba.jpa.annocache.scanning.SpecificAnnotationsImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.annocache.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import com.ibm.wsspi.annocache.info.ClassInfo;
import com.ibm.wsspi.annocache.info.InfoStore;
import com.ibm.wsspi.annocache.info.InfoStoreException;
import com.ibm.wsspi.annocache.info.InfoStoreFactory;
import com.ibm.wsspi.annocache.service.AnnotationCacheService_Service;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Factory;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AnnotationsImpl
implements Annotations {
    public static final TraceComponent tc = Tr.register(AnnotationsImpl.class, null, null);
    private final AnnotationsAdapterImpl annotationsAdapter;
    private final Container rootContainer;
    private final ArtifactContainer rootDelegateContainer;
    private final OverlayContainer rootOverlayContainer;
    private final Container rootAdaptableContainer;
    private boolean useJandex;
    private String appName;
    private String modName;
    private boolean isUnnamedMod;
    private final String modCatName;
    private boolean isLightweight;
    private final ClassSourceLock classSourceLock = new ClassSourceLock();
    protected ClassLoader classLoader;
    protected ClassSource_Aggregate rootClassSource;
    private final TargetsLock targetsLock = new TargetsLock();
    private boolean isSetTargets;
    private AnnotationTargets_Targets annotationTargets;
    private final InfoStoreLock infoStoreLock = new InfoStoreLock();
    private boolean isSetInfoStore;
    private InfoStore infoStore;
    static final long serialVersionUID = 8073058392095070998L;

    public static String getPath(Container container) throws UnableToAdaptException {
        Entry entry;
        StringBuilder pathBuilder = new StringBuilder();
        while ((entry = (Entry)container.adapt(Entry.class)) != null) {
            pathBuilder.insert(0, entry.getPath());
            container = entry.getRoot();
        }
        return pathBuilder.toString();
    }

    protected String getContainerPath(Container container) {
        String pathCase;
        String containerPath;
        try {
            containerPath = AnnotationsImpl.getPath(container);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"80", (Object)this, (Object[])new Object[]{container});
            return null;
        }
        if (containerPath.isEmpty()) {
            containerPath = this.getModName();
            if (containerPath == null || containerPath.isEmpty()) {
                containerPath = this.getAppName();
                if (containerPath == null || containerPath.isEmpty()) {
                    Tr.warning((TraceComponent)tc, (String)("Unable to obtain path for container [ " + container + " ]"), (Object[])new Object[0]);
                    return null;
                }
                pathCase = "root-of-roots (application name)";
            } else {
                pathCase = "root-of-roots (module name)";
            }
        } else {
            pathCase = "non-root-of-roots (full path)";
        }
        String message = this.getClass().getSimpleName() + ".getContainerPath: Container [ " + container + " ] Path [ " + containerPath + " ]: " + pathCase;
        Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return containerPath;
    }

    protected static <T> T cacheGet(OverlayContainer container, String targetPath, Class<T> targetClass) {
        Object retrievedInfo = container.getFromNonPersistentCache(targetPath, targetClass);
        return (T)retrievedInfo;
    }

    protected static <T> void cachePut(OverlayContainer container, String targetPath, Class<T> targetClass, T targetObject) {
        container.addToNonPersistentCache(targetPath, targetClass, targetObject);
    }

    protected static <T> void cacheRemove(OverlayContainer container, String targetPath, Class<T> targetClass) {
        container.removeFromNonPersistentCache(targetPath, targetClass);
    }

    public AnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootDelegateContainer, Container rootAdaptableContainer, String appName, boolean isUnnamedMod, String modName, String modCatName) {
        this.annotationsAdapter = annotationsAdapter;
        this.rootContainer = rootContainer;
        this.rootDelegateContainer = rootDelegateContainer;
        this.rootOverlayContainer = rootOverlayContainer;
        this.rootAdaptableContainer = rootAdaptableContainer;
        this.appName = appName;
        this.modName = modName;
        this.modCatName = modCatName;
        this.isLightweight = false;
        this.rootClassSource = null;
        this.isSetTargets = false;
        this.annotationTargets = null;
        this.isSetInfoStore = false;
        this.infoStore = null;
        if (tc.isDebugEnabled()) {
            String prefix = this.getClass().getSimpleName() + ".<init>: ";
            Tr.debug((TraceComponent)tc, (String)(prefix + "Root container [ " + rootContainer + " ]"), (Object[])new Object[0]);
            for (URL url : rootContainer.getURLs()) {
                Tr.debug((TraceComponent)tc, (String)(prefix + "  URL [ " + url + " ]"), (Object[])new Object[0]);
            }
            Tr.debug((TraceComponent)tc, (String)(prefix + "Application [ " + appName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(prefix + "Module [ " + modName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(prefix + "Module Category [ " + modCatName + " ]"), (Object[])new Object[0]);
        }
    }

    public AnnotationCacheService_Service getAnnoCacheService() {
        return this.annotationsAdapter.getAnnoCacheService();
    }

    public ClassSource_Factory getClassSourceFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getClassSourceFactory();
    }

    public AnnotationTargets_Factory getTargetsFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getAnnotationTargetsFactory();
    }

    public InfoStoreFactory getInfoStoreFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getInfoStoreFactory();
    }

    public ArtifactContainer getRootDelegateContainer() {
        return this.rootDelegateContainer;
    }

    public OverlayContainer getRootOverlayContainer() {
        return this.rootOverlayContainer;
    }

    protected <T> T cacheGet(Class<T> targetClass) {
        return AnnotationsImpl.cacheGet(this.getRootOverlayContainer(), this.getContainerPath(), targetClass);
    }

    protected <T> void cachePut(Class<T> targetClass, T targetObject) {
        AnnotationsImpl.cachePut(this.getRootOverlayContainer(), this.getContainerPath(), targetClass, targetObject);
    }

    protected <T> void cacheRemove(Class<T> targetClass) {
        AnnotationsImpl.cacheRemove(this.getRootOverlayContainer(), this.getContainerPath(), targetClass);
    }

    public Container getContainer() {
        return this.rootAdaptableContainer;
    }

    public String getContainerName() {
        return this.getContainer().getName();
    }

    public String getContainerPath() {
        return this.getContainer().getPath();
    }

    public boolean getUseJandex() {
        return this.useJandex;
    }

    public void setUseJandex(boolean useJandex) {
        this.useJandex = useJandex;
    }

    protected ClassSource_Options createOptions() {
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return null;
        }
        ClassSource_Options options = classSourceFactory.createOptions();
        if (!options.getIsSetUseJandex()) {
            options.setUseJandex(this.getUseJandex());
        } else {
            Tr.info((TraceComponent)tc, (String)("Application jandex setting [ " + this.getUseJandex() + " ] overridden by property setting [ " + options.getUseJandex() + " ]"), (Object[])new Object[0]);
        }
        return options;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getModName() {
        return this.modName;
    }

    public void setIsUnnamedMod(boolean isUnnamedMod) {
        this.isUnnamedMod = isUnnamedMod;
    }

    public boolean getIsUnnamedMod() {
        return this.isUnnamedMod;
    }

    protected void forceModName() throws UnableToAdaptException {
        if (this.getIsUnnamedMod()) {
            return;
        }
        if (this.modName == null || this.modName.isEmpty()) {
            String modNameCase;
            String useModName = AnnotationsImpl.getPath(this.getContainer());
            if (useModName == null || useModName.isEmpty()) {
                useModName = this.getAppName();
                if (useModName == null || useModName.isEmpty()) {
                    useModName = null;
                    String modNameCase2 = "unavailable";
                    return;
                }
                modNameCase = "assigned from application";
            } else {
                modNameCase = "assigned from module container";
            }
            this.modName = useModName;
            if (tc.isDebugEnabled()) {
                String message = this.getClass().getSimpleName() + ".forceModName: App [ " + this.getAppName() + " ] Container [ " + this.getContainer() + " ] Mod [ " + this.modName + " ] (" + modNameCase + ")";
                Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            }
        }
    }

    public void setModName(String modName) {
        this.modName = modName;
    }

    public String getModCategoryName() {
        return this.modCatName;
    }

    public boolean getIsLightweight() {
        return this.isLightweight;
    }

    public void setIsLightweight(boolean isLightweight) {
        this.isLightweight = isLightweight;
    }

    protected boolean addContainerClassSource(String path, Container container) {
        return this.addContainerClassSource(path, container, ClassSource_Factory.UNUSED_ENTRY_PREFIX);
    }

    protected boolean addContainerClassSource(String path, Container container, String entryPrefix) {
        ClassSource_MappedContainer containerClassSource;
        try {
            containerClassSource = this.getClassSourceFactory().createContainerClassSource(this.rootClassSource, path, container, entryPrefix);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"417", (Object)this, (Object[])new Object[]{path, container, entryPrefix});
            return false;
        }
        this.rootClassSource.addClassSource((ClassSource)containerClassSource);
        return true;
    }

    protected boolean addContainerClassSource(String path, Container container, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        return this.addContainerClassSource(path, container, ClassSource_Factory.UNUSED_ENTRY_PREFIX, scanPolicy);
    }

    protected boolean addContainerClassSource(String path, Container container, String entryPrefix, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        ClassSource_MappedContainer containerClassSource;
        try {
            containerClassSource = this.getClassSourceFactory().createContainerClassSource(this.rootClassSource, path, container, entryPrefix);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"433", (Object)this, (Object[])new Object[]{path, container, entryPrefix, scanPolicy});
            return false;
        }
        this.rootClassSource.addClassSource((ClassSource)containerClassSource, scanPolicy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassLoader(ClassLoader classLoader) {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.classLoader != null) {
                if (this.classLoader != classLoader) {
                    throw new IllegalArgumentException("Duplicate class loader [ " + classLoader + " ]; previous [ " + this.classLoader + " ]");
                }
                return;
            }
            this.classLoader = classLoader;
            this.addExternalToClassSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassSource_Aggregate releaseClassSource() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.rootClassSource == null) {
                return null;
            }
            ClassSource_Aggregate oldClassSource = this.rootClassSource;
            this.rootClassSource = null;
            return oldClassSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassSource_Aggregate getClassSource() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.rootClassSource == null) {
                this.rootClassSource = this.createRootClassSource();
                if (this.rootClassSource == null) {
                    String message = "Null class source created for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
                    Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
                }
                this.addInternalToClassSource();
                this.addExternalToClassSource();
            }
            return this.rootClassSource;
        }
    }

    protected ClassSource_Aggregate createRootClassSource() {
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return null;
        }
        try {
            this.forceModName();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"507", (Object)this, (Object[])new Object[0]);
            return null;
        }
        String useAppName = this.getAppName();
        String useModName = this.getModName();
        String useModCatName = this.getModCategoryName();
        ClassSource_Options options = this.createOptions();
        if (tc.isDebugEnabled()) {
            String prefix = this.getClass().getSimpleName() + ".createRootClassSource:";
            String message1 = prefix + " Class source  app [ " + useAppName + " ] module [ " + useModName + " ] module category [ " + useModCatName + " ]";
            String message2 = prefix + " Scan threads [ " + options.getScanThreads() + " ]";
            Tr.debug((TraceComponent)tc, (String)message1, (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)message2, (Object[])new Object[0]);
        }
        try {
            return classSourceFactory.createAggregateClassSource(useAppName, useModName, useModCatName, options);
        }
        catch (ClassSource_Exception prefix) {
            FFDCFilter.processException((Throwable)prefix, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"535", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    protected abstract void addInternalToClassSource();

    protected void addExternalToClassSource() {
        ClassSource_ClassLoader classLoaderClassSource;
        if (this.rootClassSource == null) {
            return;
        }
        if (this.classLoader == null) {
            return;
        }
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return;
        }
        try {
            classLoaderClassSource = classSourceFactory.createClassLoaderClassSource(this.rootClassSource, "classloader", this.classLoader);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"558", (Object)this, (Object[])new Object[0]);
            return;
        }
        this.rootClassSource.addClassLoaderClassSource(classLoaderClassSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationTargets_Targets getTargets() {
        TargetsLock targetsLock = this.targetsLock;
        synchronized (targetsLock) {
            if (!this.isSetTargets) {
                this.isSetTargets = true;
                this.annotationTargets = this.createTargets();
            }
            return this.annotationTargets;
        }
    }

    public AnnotationTargets_Targets getAnnotationTargets() {
        return this.getTargets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationTargets_Targets releaseTargets() {
        TargetsLock targetsLock = this.targetsLock;
        synchronized (targetsLock) {
            if (!this.isSetTargets) {
                return null;
            }
            this.isSetTargets = false;
            AnnotationTargets_Targets oldTargets = this.annotationTargets;
            this.annotationTargets = null;
            this.cacheRemove(AnnotationTargets_Targets.class);
            return oldTargets;
        }
    }

    protected AnnotationTargets_Targets createTargets() {
        AnnotationTargets_Targets useTargets;
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            String message = "Null class source creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
            return null;
        }
        AnnotationTargets_Factory targetsFactory = this.getTargetsFactory();
        if (targetsFactory == null) {
            String message = "Null factory creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
            return null;
        }
        if (this.classLoader == null) {
            String message = "Null class loader creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.debug((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
        }
        try {
            useTargets = targetsFactory.createTargets(this.getIsLightweight());
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"643", (Object)this, (Object[])new Object[0]);
            return null;
        }
        useTargets.scan(useClassSource);
        return useTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoStore releaseInfoStore() {
        InfoStoreLock infoStoreLock = this.infoStoreLock;
        synchronized (infoStoreLock) {
            if (!this.isSetInfoStore) {
                return null;
            }
            this.isSetInfoStore = false;
            InfoStore oldStore = this.infoStore;
            this.infoStore = null;
            this.cacheRemove(InfoStore.class);
            return oldStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoStore getInfoStore() {
        InfoStoreLock infoStoreLock = this.infoStoreLock;
        synchronized (infoStoreLock) {
            if (!this.isSetInfoStore) {
                this.isSetInfoStore = true;
                this.infoStore = this.createInfoStore();
            }
            return this.infoStore;
        }
    }

    protected InfoStore createInfoStore() {
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            return null;
        }
        InfoStoreFactory infoStoreFactory = this.getInfoStoreFactory();
        if (infoStoreFactory == null) {
            return null;
        }
        try {
            return infoStoreFactory.createInfoStore(useClassSource);
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"709", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public boolean isIncludedClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isSeedClassName(className);
    }

    public boolean isPartialClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isPartialClassName(className);
    }

    public boolean isExcludedClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isExcludedClassName(className);
    }

    public boolean isExternalClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isExternalClassName(className);
    }

    public ClassInfo getClassInfo(String className) {
        return this.getInfoStore().getDelayableClassInfo(className);
    }

    public void openInfoStore() {
        try {
            this.getInfoStore().open();
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"767", (Object)this, (Object[])new Object[0]);
        }
    }

    public void closeInfoStore() {
        try {
            this.getInfoStore().close();
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"776", (Object)this, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SpecificAnnotations getSpecificAnnotations(Set<String> specificClassNames) throws UnableToAdaptException {
        AnnotationTargets_Targets specificTargets;
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            return null;
        }
        AnnotationTargets_Factory useTargetsFactory = this.getTargetsFactory();
        if (useTargetsFactory == null) {
            return null;
        }
        try {
            specificTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"798", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0473E", (Object[])new Object[]{"Failed to obtain annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        try {
            specificTargets.scan(useClassSource, specificClassNames);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl", (String)"806", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0474E", (Object[])new Object[]{"Failed to obtain annotation targets", specificClassNames, e});
            throw new UnableToAdaptException(msg);
        }
        return new SpecificAnnotationsImpl(specificTargets);
    }

    public boolean hasSpecifiedAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        for (String annotationClassName : annotationClassNames) {
            Set annotatedClassNames = useTargets.getAnnotatedClasses(annotationClassName);
            if (annotatedClassNames.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Trivial
    public Set<String> getClassesWithAnnotation(String annotationClassName) {
        return this.getClassesWithAnnotations(Collections.singletonList(annotationClassName));
    }

    public Set<String> getClassesWithAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return Collections.emptySet();
        }
        HashSet annotatedClassNames = null;
        for (String annotationClassName : annotationClassNames) {
            Set nextClassNames = useTargets.getAnnotatedClasses(annotationClassName);
            if (nextClassNames.isEmpty()) continue;
            if (annotatedClassNames == null) {
                annotatedClassNames = new HashSet(nextClassNames);
                continue;
            }
            annotatedClassNames.addAll(nextClassNames);
        }
        if (annotatedClassNames == null) {
            return Collections.emptySet();
        }
        return annotatedClassNames;
    }

    public Set<String> getClassesWithSpecifiedInheritedAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return Collections.emptySet();
        }
        HashSet<String> allAnnotatedClassNames = new HashSet<String>();
        for (String annotationClassName : annotationClassNames) {
            Set annotatedClassNames = useTargets.getAllInheritedAnnotatedClasses(annotationClassName);
            allAnnotatedClassNames.addAll(annotatedClassNames);
        }
        return allAnnotatedClassNames;
    }

    protected long scanStart() {
        long startTime = this.getTimeInNanoSec();
        return startTime;
    }

    protected long scanEnd(long startTime) {
        long endTime = this.getTimeInNanoSec();
        long elapsedTime = endTime - startTime;
        return elapsedTime;
    }

    private long getTimeInNanoSec() {
        return System.nanoTime();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ClassSourceLock {
        static final long serialVersionUID = 3558640501615230695L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl$ClassSourceLock", ClassSourceLock.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class TargetsLock {
        static final long serialVersionUID = 8459833000006698597L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl$TargetsLock", TargetsLock.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class InfoStoreLock {
        static final long serialVersionUID = 1106560208604684789L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.jpa.annocache.scanning.AnnotationsImpl$InfoStoreLock", InfoStoreLock.class, null, null);
        }
    }
}

