/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.util.felix;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.AbstractRequirement;
import org.apache.aries.subsystem.obr.internal.NamespaceTranslator;
import org.apache.aries.subsystem.util.felix.OsgiCapabilityAdapter;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.osgi.resource.Resource;

public class FelixRequirementAdapter
extends AbstractRequirement {
    private final Map<String, String> directives;
    private final Requirement requirement;
    private final Resource resource;

    public FelixRequirementAdapter(Requirement requirement, Resource resource) {
        if (requirement == null) {
            throw new NullPointerException("Missing required parameter: requirement");
        }
        if (resource == null) {
            throw new NullPointerException("Missing required parameter: resource");
        }
        this.requirement = requirement;
        this.resource = resource;
        this.directives = this.computeDirectives();
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public String getNamespace() {
        return NamespaceTranslator.translate(this.requirement.getName());
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean matches(org.osgi.resource.Capability capability) {
        return this.requirement.isSatisfied((Capability)new OsgiCapabilityAdapter(capability));
    }

    private Map<String, String> computeDirectives() {
        HashMap<String, String> result = new HashMap<String, String>(3);
        String namespace = this.getNamespace();
        String filter = this.requirement.getFilter().replaceAll("\\(mandatory\\:\\<\\*[^\\)]*\\)", "").replaceAll("\\(service\\=[^\\)]*\\)", "").replaceAll("objectclass", "objectClass").replaceAll(this.requirement.getName() + '=', namespace + '=');
        if ("osgi.wiring.bundle".equals(namespace)) {
            filter = filter.replaceAll("symbolicname", namespace).replaceAll("version", "bundle-version");
        }
        result.put("filter", filter);
        result.put("resolution", this.requirement.isOptional() ? "optional" : "mandatory");
        result.put("cardinality", this.requirement.isMultiple() ? "multiple" : "single");
        return Collections.unmodifiableMap(result);
    }
}

