/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AdminMetadataParser {
    private static final TraceComponent tc = Tr.register(AdminMetadataParser.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    static final long serialVersionUID = -4950794722759759647L;

    public Map<String, Object> parseAdminMetadata(File file, String resourceType) {
        HashMap<String, Object> allMetadata = new HashMap<String, Object>();
        if (file.exists() && file.getName().equals("admin-metadata.xml")) {
            Document doc = this.parseXML(file);
            if (doc != null) {
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xPath = xpf.newXPath();
                if (resourceType.equals("server")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"retrieve server admin metadata ...", (Object[])new Object[0]);
                    }
                    this.validateMetadataFile("server", doc);
                    if (doc.getElementsByTagName("server").getLength() > 0) {
                        Map<String, Object> serverMetadata = this.buildMetadata(xPath, "server", doc);
                        allMetadata.put("server", serverMetadata);
                    }
                    if (doc.getElementsByTagName("cluster").getLength() > 0) {
                        Map<String, Object> clusterMetadata = this.buildMetadata(xPath, "cluster", doc);
                        allMetadata.put("cluster", clusterMetadata);
                    }
                    if (doc.getElementsByTagName("application").getLength() > 0) {
                        Map<String, Object> applicationMetadata = this.buildMetadata(xPath, "application", doc);
                        allMetadata.put("application", applicationMetadata);
                    }
                } else if (resourceType.equals("runtime")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"retrieve runtime admin metadata ...", (Object[])new Object[0]);
                    }
                    this.validateMetadataFile("runtime", doc);
                    if (doc.getElementsByTagName("runtime").getLength() > 0) {
                        Map<String, Object> runtimeMetadata = this.buildMetadata(xPath, "runtime", doc);
                        allMetadata.put("runtime", runtimeMetadata);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Doc is null, can not retrieve anything", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("admin-metadata.xml does not exist " + file.getName()), (Object[])new Object[0]);
        }
        return allMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> buildMetadata(XPath xPath, String resourceType, Document doc) {
        Map<String, Object> metadata;
        block5: {
            metadata = new HashMap<String, Object>();
            String appName = null;
            String owner = null;
            String[] tags = null;
            String[] contacts = null;
            String note = null;
            resourceType = resourceType.toLowerCase();
            try {
                NodeList nodes = (NodeList)xPath.evaluate("/admin-metadata/" + resourceType, doc, XPathConstants.NODESET);
                if (nodes != null && nodes.getLength() > 0) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        int j = i + 1;
                        XPathExpression nameExpression = xPath.compile("//" + resourceType + "[" + j + "]/@name");
                        appName = (String)nameExpression.evaluate(node, XPathConstants.STRING);
                        XPathExpression ownerExpression = xPath.compile("//" + resourceType + "[" + j + "]/@owner");
                        owner = (String)ownerExpression.evaluate(node, XPathConstants.STRING);
                        XPathExpression tagExpression = xPath.compile("//" + resourceType + "[" + j + "]/tag");
                        NodeList tagList = (NodeList)tagExpression.evaluate(node, XPathConstants.NODESET);
                        tags = this.getValues(tagList);
                        XPathExpression contactExpression = xPath.compile("//" + resourceType + "[" + j + "]/contact");
                        NodeList contactList = (NodeList)contactExpression.evaluate(node, XPathConstants.NODESET);
                        contacts = this.getValues(contactList);
                        XPathExpression noteExpression = xPath.compile("//" + resourceType + "[" + j + "]/note");
                        note = (String)noteExpression.evaluate(node, XPathConstants.STRING);
                        if (resourceType.equals("application")) {
                            Map<String, Object> appMetadata = this.buildMap(owner, tags, contacts, note);
                            metadata.put(appName, appMetadata);
                            continue;
                        }
                        metadata = this.buildMap(owner, tags, contacts, note);
                    }
                }
            }
            catch (XPathExpressionException nodes) {
                void xe;
                FFDCFilter.processException((Throwable)nodes, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataParser", (String)"163", (Object)this, (Object[])new Object[]{xPath, resourceType, doc});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block5;
                Tr.error((TraceComponent)tc, (String)"ADMIN_METADATA_PARSER_UNEXPECTETED_ERROR", (Object[])new Object[]{xe.toString()});
            }
        }
        return metadata;
    }

    /*
     * WARNING - void declaration
     */
    private Document parseXML(File file) {
        Document document;
        block5: {
            document = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = factory.newDocumentBuilder();
                document = db.parse(file);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("root of xml file" + document.getDocumentElement().getNodeName()), (Object[])new Object[0]);
                }
            }
            catch (SAXException factory) {
                FFDCFilter.processException((Throwable)factory, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataParser", (String)"185", (Object)this, (Object[])new Object[]{file});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    void e;
                    Tr.error((TraceComponent)tc, (String)"ADMIN_METADATA_PARSER_UNEXPECTETED_ERROR", (Object[])new Object[]{e.toString()});
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataParser", (String)"190", (Object)this, (Object[])new Object[]{file});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block5;
                Tr.error((TraceComponent)tc, (String)"ADMIN_METADATA_PARSER_UNEXPECTETED_ERROR", (Object[])new Object[]{e.toString()});
            }
        }
        return document;
    }

    private String[] getValues(NodeList list) {
        String[] returnArray = new String[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            String value = list.item(i).getTextContent();
            if (value == null) continue;
            returnArray[i] = value;
        }
        return returnArray;
    }

    private Map<String, Object> buildMap(String owner, String[] tags, String[] contacts, String note) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (owner != null) {
            metadata.put("owner", owner);
        }
        if (tags != null && tags.length > 0) {
            metadata.put("tags", tags);
        }
        if (contacts != null && contacts.length > 0) {
            metadata.put("contacts", contacts);
        }
        if (note != null) {
            metadata.put("note", note);
        }
        return metadata;
    }

    private void validateMetadataFile(String fileType, Document doc) {
        if (fileType.equals("server")) {
            if (doc.getElementsByTagName("runtime").getLength() > 0 && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"UNEXPECTED_ADMIN_METADATA_SPECIFIED", (Object[])new Object[]{"runtime"});
            }
        } else {
            if (doc.getElementsByTagName("server").getLength() > 0 && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"UNEXPECTED_ADMIN_METADATA_SPECIFIED", (Object[])new Object[]{"server"});
            }
            if (doc.getElementsByTagName("cluster").getLength() > 0 && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"UNEXPECTED_ADMIN_METADATA_SPECIFIED", (Object[])new Object[]{"cluster"});
            }
            if (doc.getElementsByTagName("application").getLength() > 0 && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"UNEXPECTED_ADMIN_METADATA_SPECIFIED", (Object[])new Object[]{"application"});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String[] parseDeployVariableAdminMetadata(File file) {
        StringBuffer deployVariableNames = null;
        String delimitor = "<>";
        if (file.exists() && file.getName().equals("admin-metadata.xml")) {
            Document doc = this.parseXML(file);
            if (doc != null) {
                if (doc.getElementsByTagName("deployVariable").getLength() > 0) {
                    try {
                        XPath xPath = XPathFactory.newInstance().newXPath();
                        NodeList nodes = (NodeList)xPath.evaluate("/admin-metadata/deployVariable", doc, XPathConstants.NODESET);
                        if (nodes != null && nodes.getLength() > 0) {
                            for (int i = 0; i < nodes.getLength(); ++i) {
                                deployVariableNames = this.buildDeployVariableNames(deployVariableNames, delimitor, nodes, i);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No deployVariable defined in " + file.getPath()), (Object[])new Object[0]);
                        }
                    }
                    catch (XPathExpressionException xPath) {
                        FFDCFilter.processException((Throwable)xPath, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataParser", (String)"294", (Object)this, (Object[])new Object[]{file});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                            void e;
                            Tr.error((TraceComponent)tc, (String)"ADMIN_METADATA_PARSER_UNEXPECTETED_ERROR", (Object[])new Object[]{e.toString()});
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Doc is null, can not retrieve anything", (Object[])new Object[0]);
            }
        }
        if (deployVariableNames != null) {
            return deployVariableNames.toString().split(delimitor);
        }
        return new String[0];
    }

    private StringBuffer buildDeployVariableNames(StringBuffer deployVariableNames, String delimitor, NodeList nodes, int nodeIndex) {
        Element e = (Element)nodes.item(nodeIndex);
        String deployVariableName = e.getAttribute("name");
        if (deployVariableName != null && !deployVariableName.isEmpty()) {
            deployVariableNames = deployVariableNames != null ? deployVariableNames.append(delimitor + deployVariableName) : new StringBuffer(deployVariableName);
        }
        return deployVariableNames;
    }
}

