/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.ArrayList;
import java.util.List;

@Trivial
public class Endpoint {
    private final String host;
    private final int port;

    public Endpoint(String hostAndPort) {
        this.validateHostAndPort(hostAndPort);
        this.host = hostAndPort.substring(0, hostAndPort.lastIndexOf(":")).trim();
        this.validateHost(this.host);
        String portString = hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1, hostAndPort.length());
        this.port = Integer.parseInt(portString.trim());
        this.validatePort(this.port);
    }

    public Endpoint(String host, int port) {
        this.validateHost(host);
        this.host = host;
        this.validatePort(port);
        this.port = port;
    }

    private void validateHostAndPort(String hostAndPort) {
        if (hostAndPort == null || !hostAndPort.contains(":") || hostAndPort.indexOf(":") != hostAndPort.lastIndexOf(":")) {
            throw new IllegalArgumentException("Malformed host:port string: " + hostAndPort);
        }
    }

    private void validateHost(String host) {
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("Malformed host string: " + host);
        }
    }

    private void validatePort(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port value: " + port);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(Object in) {
        if (this == in) {
            return true;
        }
        if (in instanceof Endpoint) {
            Endpoint that = (Endpoint)in;
            return this.host.equals(that.host) && this.port == that.port;
        }
        return false;
    }

    public int hashCode() {
        return (this.host + this.port).hashCode();
    }

    public static List<String> getStringList(List<Endpoint> endpoints) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Endpoint endpoint : endpoints) {
            stringList.add(endpoint.toString());
        }
        return stringList;
    }
}

