/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String computeCoordinationName(Subsystem subsystem) {
        return subsystem.getSymbolicName() + '-' + subsystem.getSubsystemId();
    }

    public static Coordination createCoordination() {
        return Activator.getInstance().getCoordinator().begin("org.osgi.service.subsystem.root-0", 0L);
    }

    public static Coordination createCoordination(BasicSubsystem subsystem) {
        return Activator.getInstance().getCoordinator().begin(Utils.computeCoordinationName((Subsystem)subsystem), 0L);
    }

    public static BasicSubsystem findFirstSubsystemAcceptingDependenciesStartingFrom(BasicSubsystem subsystem) {
        while (!Utils.isAcceptDependencies(subsystem)) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        return subsystem;
    }

    public static BasicSubsystem findFirstScopedAncestorWithSharingPolicy(SubsystemResource descendant) {
        Collection<BasicSubsystem> parents = descendant.getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        BasicSubsystem result = parents.iterator().next();
        while (!result.isScoped() || result.getState().equals((Object)Subsystem.State.INSTALLING)) {
            result = result.getResource().getParents().iterator().next();
        }
        return result;
    }

    public static BasicSubsystem findScopedSubsystemInRegion(BasicSubsystem subsystem) {
        while (!subsystem.isScoped()) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        return subsystem;
    }

    public static int getActiveUseCount(Resource resource) {
        int result = 0;
        for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystemsReferencing(resource)) {
            if (!Subsystem.State.ACTIVE.equals((Object)subsystem.getState()) && (!subsystem.isRoot() || !Utils.isBundle(resource))) continue;
            ++result;
        }
        return result;
    }

    public static long getId(Resource resource) {
        if (resource instanceof BasicSubsystem) {
            return ((BasicSubsystem)resource).getSubsystemId();
        }
        if (resource instanceof BundleRevision) {
            return ((BundleRevision)resource).getBundle().getBundleId();
        }
        return -1L;
    }

    public static void handleTrowable(Throwable t) {
        if (t instanceof SubsystemException) {
            throw (SubsystemException)t;
        }
        if (t instanceof SecurityException) {
            throw (SecurityException)t;
        }
        throw new SubsystemException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installResource(Resource resource, BasicSubsystem subsystem) {
        Coordination coordination = Utils.createCoordination(subsystem);
        try {
            ResourceInstaller.newInstance(coordination, resource, subsystem).install();
        }
        catch (Throwable t) {
            coordination.fail(t);
        }
        finally {
            try {
                coordination.end();
            }
            catch (CoordinationException e) {
                logger.error("Resource could not be installed", (Throwable)e);
            }
        }
    }

    public static boolean isAcceptDependencies(BasicSubsystem subsystem) {
        return subsystem.getSubsystemManifest().getSubsystemTypeHeader().getProvisionPolicyDirective().isAcceptDependencies();
    }

    public static boolean isBundle(Resource resource) {
        String type = ResourceHelper.getTypeAttribute(resource);
        return "osgi.bundle".equals(type) || "osgi.fragment".equals(type);
    }

    public static boolean isFragment(Resource resource) {
        String type = ResourceHelper.getTypeAttribute(resource);
        return "osgi.fragment".equals(type);
    }

    public static boolean isEffectiveResolve(Requirement requirement) {
        Map directives = requirement.getDirectives();
        String value = (String)directives.get("effective");
        return value == null || "resolve".equals(value);
    }

    public static boolean isMandatory(Requirement requirement) {
        Map directives = requirement.getDirectives();
        String value = (String)directives.get("resolution");
        return value == null || "mandatory".equals(value);
    }

    public static boolean isContent(BasicSubsystem subsystem, Resource resource) {
        SubsystemManifest subsystemManifest = subsystem.getSubsystemManifest();
        if (subsystemManifest == null) {
            return false;
        }
        SubsystemContentHeader subsystemContentHeader = subsystemManifest.getSubsystemContentHeader();
        if (subsystemContentHeader == null) {
            return false;
        }
        return subsystemContentHeader.contains(resource);
    }

    public static boolean isDependency(BasicSubsystem subsystem, Resource resource) {
        DeploymentManifest manifest = subsystem.getDeploymentManifest();
        if (manifest == null) {
            return false;
        }
        ProvisionResourceHeader header = manifest.getProvisionResourceHeader();
        if (header == null) {
            return false;
        }
        return header.contains(resource);
    }

    public static boolean isInstallableResource(Resource resource) {
        return !Utils.isSharedResource(resource);
    }

    public static boolean isRegionContextBundle(Resource resource) {
        return ResourceHelper.getSymbolicNameAttribute(resource).startsWith("org.osgi.service.subsystem.region.context.");
    }

    public static boolean isSharedResource(Resource resource) {
        return resource instanceof BasicSubsystem || resource instanceof BundleRevision || resource instanceof BundleRevisionResource;
    }

    public static boolean isSubsystem(Resource resource) {
        String type = ResourceHelper.getTypeAttribute(resource);
        return "osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type);
    }

    public static boolean isProvisionDependenciesInstall(BasicSubsystem subsystem) {
        return subsystem.getSubsystemManifest().getSubsystemTypeHeader().getAriesProvisionDependenciesDirective().isInstall();
    }
}

