/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class TranslationFile {
    private final String name;
    private final Properties properties;

    private static String normalizeName(String name) {
        int index = name.lastIndexOf(47);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public TranslationFile(String name, Properties properties) {
        if (name == null || properties == null) {
            throw new NullPointerException();
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = TranslationFile.normalizeName(name);
        this.properties = properties;
    }

    public void write(File directory) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(directory, this.name));
        try {
            this.properties.store(fos, null);
        }
        finally {
            fos.close();
        }
    }
}

