/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.RegionContextBundleHelper;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.util.io.IOUtils;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemResourceUninstaller
extends ResourceUninstaller {
    private static final Logger logger = LoggerFactory.getLogger(BasicSubsystem.class);

    private static void removeChild(BasicSubsystem parent, BasicSubsystem child) {
        Activator.getInstance().getSubsystems().removeChild(parent, child);
    }

    public SubsystemResourceUninstaller(Resource resource, BasicSubsystem subsystem) {
        super(resource, subsystem);
    }

    @Override
    public void uninstall() {
        this.removeReferences();
        try {
            if (this.isResourceUninstallable()) {
                this.uninstallSubsystem();
            }
        }
        finally {
            this.removeConstituents();
            this.removeChildren();
            this.removeSubsystem();
        }
    }

    private void removeChildren() {
        if (!this.isExplicit()) {
            SubsystemResourceUninstaller.removeChild(this.subsystem, (BasicSubsystem)this.resource);
            return;
        }
        for (Subsystem subsystem : ((BasicSubsystem)this.resource).getParents()) {
            SubsystemResourceUninstaller.removeChild((BasicSubsystem)subsystem, (BasicSubsystem)this.resource);
        }
    }

    private void removeConstituents() {
        if (!this.isExplicit()) {
            this.removeConstituent();
            return;
        }
        for (Subsystem subsystem : ((BasicSubsystem)this.resource).getParents()) {
            SubsystemResourceUninstaller.removeConstituent((BasicSubsystem)subsystem, (BasicSubsystem)this.resource);
        }
    }

    private void removeReferences() {
        if (!this.isExplicit()) {
            this.removeReference();
        } else {
            for (Subsystem subsystem : ((BasicSubsystem)this.resource).getParents()) {
                SubsystemResourceUninstaller.removeReference((BasicSubsystem)subsystem, (BasicSubsystem)this.resource);
            }
            Subsystems subsystems = Activator.getInstance().getSubsystems();
            for (BasicSubsystem s : subsystems.getSubsystemsReferencing(this.resource)) {
                SubsystemResourceUninstaller.removeReference(s, this.resource);
            }
        }
    }

    private void removeSubsystem() {
        Activator.getInstance().getSubsystems().removeSubsystem((BasicSubsystem)this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallSubsystem() {
        BasicSubsystem subsystem = (BasicSubsystem)this.resource;
        try {
            if (subsystem.getState().equals((Object)Subsystem.State.RESOLVED)) {
                subsystem.setState(Subsystem.State.INSTALLED);
            }
            subsystem.setState(Subsystem.State.UNINSTALLING);
            Throwable firstError = null;
            for (Resource resource : Activator.getInstance().getSubsystems().getResourcesReferencedBy(subsystem)) {
                if (Utils.isRegionContextBundle(resource)) continue;
                try {
                    ResourceUninstaller.newInstance(resource, subsystem).uninstall();
                }
                catch (Throwable t) {
                    logger.error("An error occurred while uninstalling resource " + resource + " of subsystem " + subsystem, t);
                    if (firstError != null) continue;
                    firstError = t;
                }
            }
            subsystem.setState(Subsystem.State.UNINSTALLED);
            Activator activator = Activator.getInstance();
            activator.getSubsystemServiceRegistrar().unregister((Subsystem)subsystem);
            if (subsystem.isScoped()) {
                RegionContextBundleHelper.uninstallRegionContextBundle(subsystem);
                activator.getRegionDigraph().removeRegion(subsystem.getRegion());
            }
            if (firstError != null) {
                throw new SubsystemException(firstError);
            }
        }
        finally {
            IOUtils.deleteRecursive((File)subsystem.getDirectory());
        }
    }
}

