/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class SubsystemGraph {
    private final Map<SubsystemWrapper, Collection<SubsystemWrapper>> adjacencyList = new HashMap<SubsystemWrapper, Collection<SubsystemWrapper>>();

    public SubsystemGraph(BasicSubsystem root) {
        this.adjacencyList.put(new SubsystemWrapper((Subsystem)root), new HashSet());
    }

    public synchronized void add(BasicSubsystem parent, BasicSubsystem child) {
        SubsystemWrapper childWrap = new SubsystemWrapper((Subsystem)child);
        SubsystemWrapper parentWrap = new SubsystemWrapper((Subsystem)parent);
        if (this.containsAncestor(childWrap, parentWrap)) {
            throw new SubsystemException("Cycle detected between '" + parentWrap + "' and '" + childWrap + "'");
        }
        Collection<SubsystemWrapper> subsystems = this.adjacencyList.get(childWrap);
        if (subsystems == null) {
            subsystems = new HashSet<SubsystemWrapper>();
            this.adjacencyList.put(childWrap, subsystems);
        }
        if ((subsystems = this.adjacencyList.get(parentWrap)) == null) {
            subsystems = new HashSet<SubsystemWrapper>();
            this.adjacencyList.put(parentWrap, subsystems);
        }
        subsystems.add(childWrap);
    }

    public synchronized Collection<Subsystem> getChildren(BasicSubsystem parent) {
        Collection<SubsystemWrapper> children = this.adjacencyList.get(new SubsystemWrapper((Subsystem)parent));
        if (children == null || children.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Subsystem> result = new ArrayList<Subsystem>(children.size());
        for (SubsystemWrapper child : children) {
            result.add(child.getSubsystem());
        }
        return Collections.unmodifiableCollection(result);
    }

    public synchronized Collection<Subsystem> getParents(BasicSubsystem child) {
        Collection<SubsystemWrapper> parents = this.getParents(new SubsystemWrapper((Subsystem)child));
        ArrayList<Subsystem> result = new ArrayList<Subsystem>(parents.size());
        for (SubsystemWrapper parent : parents) {
            result.add(parent.getSubsystem());
        }
        return Collections.unmodifiableCollection(result);
    }

    public synchronized void remove(BasicSubsystem child) {
        SubsystemWrapper subsystemWrap = new SubsystemWrapper((Subsystem)child);
        Collection<SubsystemWrapper> parents = this.getParents(subsystemWrap);
        for (SubsystemWrapper parent : parents) {
            this.adjacencyList.get(parent).remove(subsystemWrap);
        }
        this.adjacencyList.remove(subsystemWrap);
    }

    public synchronized void remove(BasicSubsystem parent, BasicSubsystem child) {
        SubsystemWrapper parentWrap = new SubsystemWrapper((Subsystem)parent);
        SubsystemWrapper childWrap = new SubsystemWrapper((Subsystem)child);
        this.adjacencyList.get(parentWrap).remove(childWrap);
    }

    private boolean containsAncestor(SubsystemWrapper subsystem, SubsystemWrapper ancestor) {
        Collection<SubsystemWrapper> subsystems = this.adjacencyList.get(subsystem);
        if (subsystems == null) {
            return false;
        }
        if (subsystems.contains(ancestor)) {
            return true;
        }
        Iterator<SubsystemWrapper> iterator = subsystems.iterator();
        if (iterator.hasNext()) {
            SubsystemWrapper s = iterator.next();
            return this.containsAncestor(s, ancestor);
        }
        return false;
    }

    private Collection<SubsystemWrapper> getParents(SubsystemWrapper child) {
        ArrayList<SubsystemWrapper> result = new ArrayList<SubsystemWrapper>();
        for (Map.Entry<SubsystemWrapper, Collection<SubsystemWrapper>> entry : this.adjacencyList.entrySet()) {
            if (!entry.getValue().contains(child)) continue;
            result.add(entry.getKey());
        }
        result.trimToSize();
        return result;
    }

    private static class SubsystemWrapper {
        private final Subsystem s;

        public SubsystemWrapper(Subsystem subsystem) {
            this.s = subsystem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubsystemWrapper)) {
                return false;
            }
            SubsystemWrapper that = (SubsystemWrapper)o;
            return this.s.getLocation().equals(that.s.getLocation());
        }

        public Subsystem getSubsystem() {
            return this.s;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.s.getLocation().hashCode();
            return result;
        }

        public String toString() {
            return "location=" + this.s.getLocation() + ", symbolicName=" + this.s.getSymbolicName() + ", version=" + this.s.getVersion() + ", type=" + this.s.getType();
        }
    }
}

