/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceUninstaller;
import org.apache.aries.subsystem.core.internal.CustomResourceUninstaller;
import org.apache.aries.subsystem.core.internal.CustomResources;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.SubsystemResourceUninstaller;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceUninstaller {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUninstaller.class);
    protected final BasicSubsystem provisionTo;
    protected final Resource resource;
    protected final BasicSubsystem subsystem;

    public static ResourceUninstaller newInstance(Resource resource, BasicSubsystem subsystem) {
        String type = ResourceHelper.getTypeAttribute(resource);
        if ("osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type)) {
            return new SubsystemResourceUninstaller(resource, subsystem);
        }
        if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
            return new BundleResourceUninstaller(resource, subsystem);
        }
        ServiceReference<ContentHandler> handlerRef = CustomResources.getCustomContentHandler(subsystem, type);
        if (handlerRef != null) {
            return new CustomResourceUninstaller(resource, type, subsystem, handlerRef);
        }
        throw new SubsystemException("No uninstaller exists for resource type: " + type);
    }

    protected static void removeConstituent(BasicSubsystem subsystem, Resource resource) {
        Activator.getInstance().getSubsystems().removeConstituent(subsystem, resource);
    }

    protected static void removeReference(BasicSubsystem subsystem, Resource resource) {
        Activator.getInstance().getSubsystems().removeReference(subsystem, resource);
    }

    public ResourceUninstaller(Resource resource, BasicSubsystem subsystem) {
        if (resource == null) {
            throw new NullPointerException("Missing required parameter: resource");
        }
        if (subsystem == null) {
            throw new NullPointerException("Missing required parameter: subsystem");
        }
        this.resource = resource;
        this.subsystem = subsystem;
        this.provisionTo = this.isTransitive() ? Utils.findFirstSubsystemAcceptingDependenciesStartingFrom(subsystem) : subsystem;
    }

    public abstract void uninstall();

    protected boolean isExplicit() {
        if (this.resource.equals((Object)this.subsystem)) {
            return true;
        }
        if (this.subsystem.isScoped()) {
            if (Utils.isBundle(this.resource)) {
                return this.subsystem.getRegion().contains(((BundleRevision)this.resource).getBundle());
            }
            return !((BasicSubsystem)this.resource).isScoped();
        }
        return false;
    }

    protected boolean isTransitive() {
        ProvisionResourceHeader header = this.subsystem.getDeploymentManifest().getProvisionResourceHeader();
        if (header == null) {
            return false;
        }
        return header.contains(this.resource);
    }

    protected boolean isResourceUninstallable() {
        int referenceCount = Activator.getInstance().getSubsystems().getSubsystemsReferencing(this.resource).size();
        if (referenceCount == 0) {
            return true;
        }
        if (this.isExplicit()) {
            logger.error("Explicitly uninstalling resource still has dependencies: {}", (Object)this.resource);
            return true;
        }
        return false;
    }

    protected void removeConstituent() {
        ResourceUninstaller.removeConstituent(this.subsystem, this.resource);
    }

    protected void removeReference() {
        ResourceUninstaller.removeReference(this.subsystem, this.resource);
    }
}

