/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.SubsystemUri;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IDirectoryFinder;
import org.osgi.framework.Version;

public class Location {
    private final LocationType type;
    private final String value;
    private final URI uri;
    private final URL url;
    private final SubsystemUri subsystemUri;
    private final IllegalArgumentException subsystemUriException;

    public Location(String location) throws MalformedURLException, URISyntaxException {
        this.value = location;
        URI locationUri = null;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (locationUri == null) {
            this.type = LocationType.UNKNOWN;
            this.url = null;
            this.uri = null;
            this.subsystemUri = null;
            this.subsystemUriException = null;
        } else if (locationUri.isAbsolute()) {
            String scheme = locationUri.getScheme();
            if (LocationType.SUBSYSTEM.scheme.equals(scheme)) {
                SubsystemUri ssUri;
                this.type = LocationType.SUBSYSTEM;
                IllegalArgumentException ssUriException = null;
                try {
                    ssUri = new SubsystemUri(location);
                }
                catch (IllegalArgumentException ex) {
                    ssUri = null;
                    ssUriException = ex;
                }
                this.subsystemUri = ssUri;
                this.subsystemUriException = ssUriException;
                if (this.subsystemUri != null) {
                    this.url = this.subsystemUri.getURL();
                    this.uri = this.url == null ? null : this.url.toURI();
                } else {
                    this.url = null;
                    this.uri = locationUri;
                }
            } else if (LocationType.IDIRFINDER.scheme.equals(scheme)) {
                this.type = LocationType.IDIRFINDER;
                this.subsystemUri = null;
                this.subsystemUriException = null;
                this.url = null;
                this.uri = locationUri;
            } else {
                this.type = LocationType.URL;
                this.subsystemUri = null;
                this.subsystemUriException = null;
                URL localUrl = null;
                try {
                    localUrl = locationUri.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.url = localUrl;
                this.uri = locationUri;
            }
        } else {
            this.type = LocationType.UNKNOWN;
            this.url = null;
            this.uri = null;
            this.subsystemUri = null;
            this.subsystemUriException = null;
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getSymbolicName() {
        if (this.subsystemUriException != null) {
            throw this.subsystemUriException;
        }
        return this.subsystemUri != null ? this.subsystemUri.getSymbolicName() : null;
    }

    public Version getVersion() {
        if (this.subsystemUriException != null) {
            throw this.subsystemUriException;
        }
        return this.subsystemUri != null ? this.subsystemUri.getVersion() : null;
    }

    public IDirectory open() throws IOException, URISyntaxException {
        switch (this.type) {
            case IDIRFINDER: {
                return this.retrieveIDirectory();
            }
            case SUBSYSTEM: 
            case URL: {
                if ("file".equals(this.url.getProtocol())) {
                    return FileSystem.getFSRoot((File)new File(this.uri));
                }
                return FileSystem.getFSRoot((InputStream)this.url.openStream());
            }
            case UNKNOWN: {
                return FileSystem.getFSRoot((InputStream)new URL(this.value).openStream());
            }
        }
        throw new UnsupportedOperationException("cannot open location of type " + (Object)((Object)this.type));
    }

    private IDirectory retrieveIDirectory() throws IOException {
        Collection<IDirectoryFinder> iDirectoryFinders = Activator.getInstance().getIDirectoryFinders();
        for (IDirectoryFinder iDirectoryFinder : iDirectoryFinders) {
            IDirectory directory = iDirectoryFinder.retrieveIDirectory(this.uri);
            if (directory == null) continue;
            return directory;
        }
        throw new IOException("cannot find IDirectory corresponding to id " + this.uri);
    }

    public String toString() {
        return this.value;
    }

    static enum LocationType {
        SUBSYSTEM("subsystem", "subsystem"),
        IDIRFINDER("idirfinder", "idirfinder"),
        URL("url", null),
        UNKNOWN("unknown", null);

        final String toString;
        final String scheme;

        private LocationType(String toString, String scheme) {
            this.toString = toString;
            this.scheme = scheme;
        }

        public String toString() {
            return this.toString;
        }
    }
}

