/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.content.ConfigurationHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigAdminContentHandler
implements ContentHandler {
    public static final String FELIXCM_CONTENT_TYPE = "felix.cm.config";
    public static final String PROPERTIES_CONTENT_TYPE = "osgi.config.properties";
    public static final String[] CONTENT_TYPES = new String[]{"osgi.config.properties", "felix.cm.config"};
    private final ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> cmTracker;
    private final BundleContext ctx;
    private Map<String, Dictionary<String, Object>> configurations = new ConcurrentHashMap<String, Dictionary<String, Object>>();

    public ConfigAdminContentHandler(BundleContext ctx) {
        this.ctx = ctx;
        this.cmTracker = new ServiceTracker(ctx, ConfigurationAdmin.class, null);
        this.cmTracker.open();
    }

    public void shutDown() {
        this.cmTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(InputStream is, String symbolicName, String contentType, Subsystem subsystem, Coordination coordination) {
        Dictionary configuration = null;
        try {
            if (PROPERTIES_CONTENT_TYPE.equals(contentType)) {
                Properties p = new Properties();
                p.load(is);
                configuration = p;
            } else if (FELIXCM_CONTENT_TYPE.equals(contentType)) {
                configuration = ConfigurationHandler.read(is);
            }
        }
        catch (IOException e) {
            coordination.fail((Throwable)new Exception("Problem loading configuration " + symbolicName + " for subsystem " + subsystem.getSymbolicName(), e));
            return;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (configuration != null) {
            this.configurations.put(symbolicName, configuration);
        }
    }

    public void start(String symbolicName, String contentType, Subsystem subsystem, Coordination coordination) {
        Dictionary<String, Object> configuration = this.configurations.get(symbolicName);
        if (configuration == null) {
            coordination.fail((Throwable)new Exception("Cannot start configuration " + symbolicName + " for subsystem " + subsystem.getSymbolicName() + " it was not previously loaded"));
            return;
        }
        try {
            ConfigurationAdmin cm = (ConfigurationAdmin)this.cmTracker.getService();
            if (cm == null) {
                coordination.fail((Throwable)new Exception("No Configuration Admin Service found. Cannot apply configuration " + symbolicName + " to subsystem " + subsystem.getSymbolicName()));
                return;
            }
            Configuration[] matchingConfs = cm.listConfigurations(this.ctx.createFilter("(service.pid=" + symbolicName + ")").toString());
            if (matchingConfs == null || matchingConfs.length == 0) {
                Configuration conf = cm.getConfiguration(symbolicName, "?");
                conf.update(configuration);
            }
            this.configurations.remove(symbolicName);
        }
        catch (InvalidSyntaxException e) {
            coordination.fail((Throwable)new Exception("Failed to list existing configurations for " + symbolicName + " in subsystem " + subsystem.getSymbolicName(), e));
        }
        catch (IOException e) {
            coordination.fail((Throwable)new Exception("Problem applying configuration " + symbolicName + " in subsystem " + subsystem.getSymbolicName(), e));
        }
    }

    public void stop(String symbolicName, String contentType, Subsystem subsystem) {
    }

    public void uninstall(String symbolicName, String contentType, Subsystem subsystem) {
    }
}

