/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.capabilityset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.aries.subsystem.core.capabilityset.CapabilitySet;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class CapabilitySetRepository
implements Repository {
    private final Map<String, CapabilitySet> namespace2capabilitySet = Collections.synchronizedMap(new HashMap());

    public CapabilitySetRepository() {
        this.namespace2capabilitySet.put("osgi.identity", new CapabilitySet(Arrays.asList("osgi.identity"), true));
        this.namespace2capabilitySet.put("osgi.native", new CapabilitySet(Arrays.asList("osgi.native"), true));
        this.namespace2capabilitySet.put("osgi.ee", new CapabilitySet(Arrays.asList("osgi.ee"), true));
        this.namespace2capabilitySet.put("osgi.wiring.bundle", new CapabilitySet(Arrays.asList("osgi.wiring.bundle"), true));
        this.namespace2capabilitySet.put("osgi.wiring.host", new CapabilitySet(Arrays.asList("osgi.wiring.host"), true));
        this.namespace2capabilitySet.put("osgi.wiring.package", new CapabilitySet(Arrays.asList("osgi.wiring.package"), true));
        this.namespace2capabilitySet.put("osgi.service", new CapabilitySet(Arrays.asList("objectClass"), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Resource resource) {
        for (Capability capability : resource.getCapabilities(null)) {
            CapabilitySet capabilitySet;
            String namespace = capability.getNamespace();
            Map<String, CapabilitySet> map = this.namespace2capabilitySet;
            synchronized (map) {
                capabilitySet = this.namespace2capabilitySet.get(namespace);
                if (capabilitySet == null) {
                    capabilitySet = new CapabilitySet(Arrays.asList(namespace), true);
                    this.namespace2capabilitySet.put(namespace, capabilitySet);
                }
            }
            capabilitySet.addCapability(capability);
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>(requirements.size());
        for (Requirement requirement : requirements) {
            String filterDirective = (String)requirement.getDirectives().get("filter");
            SimpleFilter simpleFilter = filterDirective == null ? new SimpleFilter(null, null, 0) : SimpleFilter.parse(filterDirective);
            String namespace = requirement.getNamespace();
            CapabilitySet capabilitySet = this.namespace2capabilitySet.get(namespace);
            if (capabilitySet != null) {
                Set<Capability> capabilities = capabilitySet.match(simpleFilter, "osgi.wiring.package".equals(namespace) || "osgi.wiring.bundle".equals(namespace) || "osgi.wiring.host".equals(namespace));
                result.put(requirement, capabilities);
                continue;
            }
            result.put(requirement, Collections.emptyList());
        }
        return result;
    }

    public void removeResource(Resource resource) {
        for (Capability capability : resource.getCapabilities(null)) {
            CapabilitySet capabilitySet = this.namespace2capabilitySet.get(capability.getNamespace());
            if (capabilitySet == null) continue;
            capabilitySet.removeCapability(capability);
        }
    }
}

