/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.AbstractHeader;
import org.apache.aries.subsystem.core.archive.Clause;

public abstract class SymbolicNameHeader
extends AbstractHeader {
    public SymbolicNameHeader(String name, String value) {
        super(name, value);
        if (this.getClauses().size() != 1) {
            throw new IllegalArgumentException("Symbolic name headers must have one, and only one, clause: " + this.getClauses().size());
        }
        if (!Pattern.matches("(?:[0-9]|[A-Za-z]|_|-)+?(?:\\.(?:[0-9]|[A-Za-z]|_|-)+?)*", ((Clause)this.getClauses().get(0)).getPath())) {
            throw new IllegalArgumentException("Invalid symbolic name: " + ((Clause)this.getClauses().get(0)).getPath());
        }
    }

    public String getSymbolicName() {
        return ((Clause)this.getClauses().get(0)).getPath();
    }
}

