/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.CardinalityDirective;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceRequirement;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class SubsystemImportServiceHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Subsystem-ImportService";

    public SubsystemImportServiceHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public SubsystemImportServiceHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<SubsystemImportServiceRequirement> toRequirements(Resource resource) {
        ArrayList<SubsystemImportServiceRequirement> requirements = new ArrayList<SubsystemImportServiceRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String DIRECTIVE_CARDINALITY = "cardinality";
        public static final String DIRECTIVE_EFFECTIVE = "effective";
        public static final String DIRECTIVE_FILTER = "filter";
        public static final String DIRECTIVE_RESOLUTION = "resolution";
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(EffectiveDirective.ACTIVE, ResolutionDirective.MANDATORY, CardinalityDirective.SINGLE);

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.OBJECTCLASS_OR_STAR, false), Clause.parseParameters(clause, false), defaultParameters);
        }

        public Clause(String path, Map<String, Parameter> parameters, Collection<Parameter> defaultParameters) {
            super(path, parameters, defaultParameters);
        }

        public static Clause valueOf(Requirement requirement) {
            String namespace = requirement.getNamespace();
            if (!"osgi.service".equals(namespace)) {
                throw new IllegalArgumentException("Invalid namespace:" + namespace);
            }
            HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
            String filter = null;
            Map directives = requirement.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                String key = (String)entry.getKey();
                if (DIRECTIVE_FILTER.equals(key)) {
                    filter = (String)entry.getValue();
                    continue;
                }
                parameters.put(key, DirectiveFactory.createDirective(key, (String)entry.getValue()));
            }
            Map<String, List<SimpleFilter>> attributes = SimpleFilter.attributes(filter);
            String path = String.valueOf(attributes.remove("objectClass").get(0).getValue());
            HashMap<String, Object> map = new HashMap<String, Object>(attributes.size());
            for (Map.Entry<String, List<SimpleFilter>> entry : attributes.entrySet()) {
                map.put(entry.getKey(), entry.getValue().get(0).getValue());
            }
            if (!map.isEmpty()) {
                parameters.put(DIRECTIVE_FILTER, DirectiveFactory.createDirective(DIRECTIVE_FILTER, SimpleFilter.convert(map).toString()));
            }
            return new Clause(path, parameters, defaultParameters);
        }

        public SubsystemImportServiceRequirement toRequirement(Resource resource) {
            return new SubsystemImportServiceRequirement(this, resource);
        }
    }
}

