/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class SubsystemExportServiceHeader
extends AbstractClauseBasedHeader<Clause> {
    public static final String NAME = "Subsystem-ExportService";

    public SubsystemExportServiceHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public List<Capability> toCapabilities(Resource resource) throws InvalidSyntaxException {
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Clause clause : this.clauses) {
            result.addAll(clause.toCapabilities(resource));
        }
        return result;
    }

    public static class Clause
    extends AbstractClause {
        public static final String DIRECTIVE_FILTER = "filter";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.OBJECTCLASS_OR_STAR, false), Clause.parseParameters(clause, false), Clause.generateDefaultParameters(new Parameter[0]));
        }

        public String getObjectClass() {
            return this.path;
        }

        public List<Capability> toCapabilities(Resource resource) throws InvalidSyntaxException {
            List capabilities = resource.getCapabilities("osgi.service");
            if (capabilities.isEmpty()) {
                return capabilities;
            }
            Filter filter = this.computeFilter();
            ArrayList<Capability> result = new ArrayList<Capability>(capabilities.size());
            for (Capability capability : capabilities) {
                if (!filter.matches(capability.getAttributes())) continue;
                result.add(capability);
            }
            result.trimToSize();
            return result;
        }

        private Filter computeFilter() throws InvalidSyntaxException {
            return FrameworkUtil.createFilter((String)this.computeFilterString());
        }

        private String computeFilterString() {
            Directive directive = this.getDirective(DIRECTIVE_FILTER);
            return "(&(" + "objectClass" + '=' + this.path + ')' + (directive == null ? "" : directive.getValue()) + ')';
        }
    }
}

