/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.CardinalityDirective;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequireCapabilityRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.TypedAttribute;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequireCapabilityHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Require-Capability";

    public RequireCapabilityHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public RequireCapabilityHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<RequireCapabilityRequirement> toRequirements(Resource resource) {
        ArrayList<RequireCapabilityRequirement> requirements = new ArrayList<RequireCapabilityRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String DIRECTIVE_CARDINALITY = "cardinality";
        public static final String DIRECTIVE_EFFECTIVE = "effective";
        public static final String DIRECTIVE_FILTER = "filter";
        public static final String DIRECTIVE_RESOLUTION = "resolution";
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(EffectiveDirective.DEFAULT, ResolutionDirective.MANDATORY, CardinalityDirective.DEFAULT);

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.NAMESPACE, false), Clause.parseTypedParameters(clause), defaultParameters);
        }

        public Clause(String path, Map<String, Parameter> parameters, Collection<Parameter> defaultParameters) {
            super(path, parameters, defaultParameters);
        }

        public static Clause valueOf(Requirement requirement) {
            String key;
            String namespace = requirement.getNamespace();
            if (namespace.startsWith("osgi.wiring.")) {
                throw new IllegalArgumentException();
            }
            Map attributes = requirement.getAttributes();
            Map directives = requirement.getDirectives();
            HashMap<String, Parameter> parameters = new HashMap<String, Parameter>(attributes.size() + directives.size());
            for (Map.Entry entry : attributes.entrySet()) {
                key = (String)entry.getKey();
                parameters.put(key, new TypedAttribute(key, entry.getValue()));
            }
            for (Map.Entry entry : directives.entrySet()) {
                key = (String)entry.getKey();
                parameters.put(key, DirectiveFactory.createDirective(key, (String)entry.getValue()));
            }
            String path = namespace;
            return new Clause(path, parameters, defaultParameters);
        }

        public String getNamespace() {
            return this.path;
        }

        public RequireCapabilityRequirement toRequirement(Resource resource) {
            return new RequireCapabilityRequirement(this, resource);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

