/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.BundleRequiredExecutionEnvironmentHeader;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class OsgiExecutionEnvironmentRequirement
extends AbstractRequirement {
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String DIRECTIVE_FILTER = "filter";
    public static final String NAMESPACE = "osgi.ee";
    private final Map<String, String> directives;
    private final Resource resource;

    public OsgiExecutionEnvironmentRequirement(BundleRequiredExecutionEnvironmentHeader.Clause clause, Resource resource) {
        this(Collections.singleton(clause), resource);
    }

    public OsgiExecutionEnvironmentRequirement(Collection<BundleRequiredExecutionEnvironmentHeader.Clause> clauses, Resource resource) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        StringBuilder filter = new StringBuilder();
        if (clauses.size() > 1) {
            filter.append("(|");
        }
        for (BundleRequiredExecutionEnvironmentHeader.Clause clause : clauses) {
            BundleRequiredExecutionEnvironmentHeader.Clause.ExecutionEnvironment ee = clause.getExecutionEnvironment();
            Version version = ee.getVersion();
            if (version != null) {
                filter.append("(&");
            }
            filter.append("(").append(NAMESPACE).append('=').append(ee.getName()).append(')');
            if (version == null) continue;
            filter.append('(').append(ATTRIBUTE_VERSION).append('=').append(version).append("))");
        }
        if (clauses.size() > 1) {
            filter.append(')');
        }
        this.directives = new HashMap<String, String>(1);
        this.directives.put(DIRECTIVE_FILTER, filter.toString());
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Resource getResource() {
        return this.resource;
    }
}

