/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.AttributeFactory;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.ImportPackageRequirement;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ImportPackageHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String ATTRIBUTE_BUNDLE_SYMBOLICNAME = "bundle-symbolic-name";
    public static final String ATTRIBUTE_BUNDLE_VERSION = "bundle-version";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String NAME = "Import-Package";
    public static final String DIRECTIVE_RESOLUTION = "resolution";
    public static final String RESOLUTION_MANDATORY = "mandatory";
    public static final String RESOLUTION_OPTIONAL = "optional";

    public ImportPackageHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public ImportPackageHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ImportPackageRequirement> toRequirements(Resource resource) {
        Collection clauses = this.getClauses();
        ArrayList<ImportPackageRequirement> result = new ArrayList<ImportPackageRequirement>(clauses.size());
        for (Clause clause : clauses) {
            Collection<String> packageNames = clause.getPackageNames();
            if (packageNames.size() > 1) {
                for (String packageName : packageNames) {
                    Collection<Parameter> parameters = clause.getParameters();
                    HashMap<String, Parameter> name2parameter = new HashMap<String, Parameter>(parameters.size());
                    for (Parameter parameter : parameters) {
                        name2parameter.put(parameter.getName(), parameter);
                    }
                    result.add(new Clause(packageName, name2parameter, null).toRequirement(resource));
                }
                continue;
            }
            result.add(clause.toRequirement(resource));
        }
        return result;
    }

    public static class Clause
    extends AbstractClause {
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(VersionRangeAttribute.DEFAULT_VERSION, ResolutionDirective.MANDATORY);

        public static Clause valueOf(Requirement requirement) {
            String namespace = requirement.getNamespace();
            if (!"osgi.wiring.package".equals(namespace)) {
                throw new IllegalArgumentException("Invalid namespace:" + namespace);
            }
            HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
            String filter = null;
            Map directives = requirement.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                String key = (String)entry.getKey();
                if ("filter".equals(key)) {
                    filter = (String)entry.getValue();
                    continue;
                }
                parameters.put(key, DirectiveFactory.createDirective(key, (String)entry.getValue()));
            }
            Map<String, List<SimpleFilter>> attributes = SimpleFilter.attributes(filter);
            String path = null;
            for (Map.Entry<String, List<SimpleFilter>> entry : attributes.entrySet()) {
                String key = entry.getKey();
                List<SimpleFilter> value = entry.getValue();
                if ("osgi.wiring.package".equals(key)) {
                    path = String.valueOf(value.get(0).getValue());
                    continue;
                }
                if (ImportPackageHeader.ATTRIBUTE_VERSION.equals(key) || ImportPackageHeader.ATTRIBUTE_BUNDLE_VERSION.equals(key)) {
                    parameters.put(key, new VersionRangeAttribute(key, AbstractClauseBasedHeader.parseVersionRange(value)));
                    continue;
                }
                parameters.put(key, AttributeFactory.createAttribute(key, String.valueOf(value.get(0).getValue())));
            }
            return new Clause(path, parameters, defaultParameters);
        }

        public Clause(String path, Map<String, Parameter> parameters, Collection<Parameter> defaultParameters) {
            super(path, parameters, defaultParameters == null ? Clause.defaultParameters : defaultParameters);
        }

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.PACKAGE_NAMES, true), Clause.parseParameters(clause, true), defaultParameters);
        }

        public Collection<String> getPackageNames() {
            return Arrays.asList(this.path.split(";"));
        }

        public VersionRangeAttribute getVersionRangeAttribute() {
            return (VersionRangeAttribute)this.getAttribute(ImportPackageHeader.ATTRIBUTE_VERSION);
        }

        public ImportPackageRequirement toRequirement(Resource resource) {
            return new ImportPackageRequirement(this, resource);
        }
    }
}

