/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceConfiguration {
    private String name;
    private ConfigElement serviceXml;
    private String instructions;
    private List<Library> libraries;
    private List<License> licenses;

    public ServiceConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfigElement getServiceXml() {
        return this.serviceXml;
    }

    public void setServiceXml(ConfigElement serviceXml) {
        this.serviceXml = serviceXml;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<Library> libraries) {
        this.libraries = libraries;
    }

    public void addLibrary(Library library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<Library>();
        }
        this.libraries.add(library);
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public void addLibrary(License license) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<License>();
        }
        this.licenses.add(license);
    }

    public Map<String, License> getLicenseMap() {
        if (this.licenses == null) {
            return null;
        }
        HashMap<String, License> map = new HashMap<String, License>();
        for (License license : this.licenses) {
            map.put(license.getName(), license);
        }
        return map;
    }

    public String toString() {
        return "ServiceConfiguration [name=" + this.name + ", instructions=" + this.instructions + ", libraries=" + this.libraries + ", licenses=" + this.licenses + "]";
    }

    public static class ConfigElement {
        private final String name;
        private Map<String, String> attributes;
        private List<ConfigElement> children;
        private String value;

        public ConfigElement(String name) {
            this.name = name;
        }

        public ConfigElement(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value);
        }

        public String getAttribute(String name) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(name);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void addChild(ConfigElement child) {
            if (this.children == null) {
                this.children = new ArrayList<ConfigElement>();
            }
            this.children.add(child);
        }

        public List<ConfigElement> getChildren() {
            return this.children;
        }

        public void setChildren(List<ConfigElement> children) {
            this.children = children;
        }

        public List<ConfigElement> getChildren(String name) {
            ArrayList<ConfigElement> found = new ArrayList<ConfigElement>();
            for (ConfigElement child : this.children) {
                if (!name.equals(child.getName())) continue;
                found.add(child);
            }
            return found;
        }
    }

    public static class License {
        private final String name;
        private String url;

        public License(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String toString() {
            return "License [name=" + this.name + ", url=" + this.url + "]";
        }
    }

    public static class Library {
        private final String url;
        private String credentials;
        private String displayUrl;
        private String targetPath;
        private String license;

        public Library(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getCredentials() {
            return this.credentials;
        }

        public void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        public String getDisplayUrl() {
            return this.displayUrl;
        }

        public void setDisplayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getLicense() {
            return this.license;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        public String toString() {
            return "Library [url=" + this.url + ", displayUrl=" + this.displayUrl + ", targetPath=" + this.targetPath + ", license=" + this.license + "]";
        }
    }
}

