/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.tx;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.eba.tx.TransactionToken;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public enum TransactionStrategy {
    MANDATORY{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException(TRACE_NLS.getFormattedMessage("CWSAB1000E", null, "No active transaction on the thread."));
            }
            return new TransactionToken(man.getTransaction(), null, null, null, MANDATORY);
        }
    }
    ,
    NEVER{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException, InvalidTransactionException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException(TRACE_NLS.getFormattedMessage("CWSAB1001E", null, "An active transaction is on the thread."));
            }
            LocalTransactionCoordinator oldLTC = ltc.suspend();
            this.beginLTCOrResume(man, ltc, null, oldLTC);
            return new TransactionToken(null, null, ltc.getLocalTranCoord(), oldLTC, NEVER);
        }

        @Override
        public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken token) throws SystemException, RolledbackException, InconsistentLocalTranException, InvalidTransactionException, IllegalStateException {
            this.endLTC(man, ltc, token);
        }
    }
    ,
    NOTSUPPORTED{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException, InvalidTransactionException {
            Transaction oldTran = null;
            LocalTransactionCoordinator oldLTC = null;
            if (man.getStatus() == 0) {
                oldTran = man.suspend();
            } else {
                oldLTC = ltc.suspend();
            }
            this.beginLTCOrResume(man, ltc, oldTran, oldLTC);
            return new TransactionToken(null, oldTran, ltc.getLocalTranCoord(), oldLTC, NOTSUPPORTED);
        }

        @Override
        public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, InconsistentLocalTranException, RolledbackException {
            this.endLTC(man, ltc, tranToken);
        }
    }
    ,
    REQUIRED{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                LocalTransactionCoordinator oldLTC = ltc.suspend();
                try {
                    man.begin();
                }
                catch (SystemException e) {
                    FFDCFilter.processException((Throwable)e, (String)TransactionStrategy.class.getName(), (String)"121");
                    if (oldLTC != null) {
                        ltc.resume(oldLTC);
                    }
                    throw e;
                }
                return new TransactionToken(man.getTransaction(), null, null, oldLTC, REQUIRED, true);
            }
            return new TransactionToken(man.getTransaction(), null, null, null, REQUIRED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                try {
                    if (man.getStatus() == 1) {
                        man.rollback();
                    } else {
                        man.commit();
                    }
                }
                finally {
                    if (tranToken.getSuspendedLTC() != null) {
                        ltc.resume(tranToken.getSuspendedLTC());
                    }
                }
            }
        }
    }
    ,
    REQUIRESNEW{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            TransactionToken tranToken = man.getStatus() == 0 ? new TransactionToken(null, man.suspend(), null, null, REQUIRESNEW) : new TransactionToken(null, null, null, ltc.suspend(), REQUIRESNEW);
            try {
                man.begin();
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, (String)"TransactionStrategy.REQUIRES_NEW.begin", (String)"120", (Object[])new Object[]{man});
                this.resumeFromToken(man, ltc, tranToken);
                throw e;
            }
            catch (NotSupportedException e) {
                FFDCFilter.processException((Throwable)e, (String)"TransactionStrategy.REQUIRES_NEW.begin", (String)"122", (Object[])new Object[]{man});
                this.resumeFromToken(man, ltc, tranToken);
                throw e;
            }
            tranToken.setActiveTransaction(man.getTransaction());
            tranToken.setCompletionAllowed(true);
            return tranToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            try {
                if (tranToken.isCompletionAllowed()) {
                    if (man.getStatus() == 1) {
                        man.rollback();
                    } else {
                        man.commit();
                    }
                }
            }
            finally {
                this.resumeFromToken(man, ltc, tranToken);
            }
        }
    }
    ,
    SUPPORTS{

        @Override
        public TransactionToken begin(TransactionManager man, LocalTransactionCurrent ltc) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, null, null, SUPPORTS);
            }
            LocalTransactionCoordinator oldLTC = ltc.suspend();
            this.beginLTCOrResume(man, ltc, null, oldLTC);
            return new TransactionToken(null, null, ltc.getLocalTranCoord(), oldLTC, SUPPORTS);
        }

        @Override
        public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken token) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException, InconsistentLocalTranException, RolledbackException {
            if (token.getActiveLTC() != null) {
                this.endLTC(man, ltc, token);
            }
        }
    };

    private static final TraceNLS TRACE_NLS;

    protected void beginLTCOrResume(TransactionManager man, LocalTransactionCurrent ltc, Transaction oldTran, LocalTransactionCoordinator oldLTC) throws SystemException, InvalidTransactionException {
        try {
            ltc.begin(false, false, false);
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)TransactionStrategy.class.getName(), (String)"222");
            if (oldTran != null) {
                man.resume(oldTran);
            } else if (oldLTC != null) {
                ltc.resume(oldLTC);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endLTC(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken token) throws IllegalStateException, InconsistentLocalTranException, RolledbackException, InvalidTransactionException, SystemException {
        LocalTransactionCoordinator activeLTC = token.getActiveLTC();
        try {
            if (activeLTC != null) {
                ltc.cleanup();
            }
        }
        finally {
            this.resumeFromToken(man, ltc, token);
        }
    }

    protected void resumeFromToken(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken token) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (token.getSuspendedTransaction() != null) {
            man.resume(token.getSuspendedTransaction());
        } else if (token.getSuspendedLTC() != null) {
            ltc.resume(token.getSuspendedLTC());
        }
    }

    public static TransactionStrategy fromValue(String value) {
        return TransactionStrategy.valueOf(value.toUpperCase());
    }

    public abstract TransactionToken begin(TransactionManager var1, LocalTransactionCurrent var2) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException;

    public void finish(TransactionManager man, LocalTransactionCurrent ltc, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException, RolledbackException, InconsistentLocalTranException {
    }

    static {
        TRACE_NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.eba.tx.nls.TxMessages");
    }
}

