/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.subsystem;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.subsystem.SubsystemPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubsystemPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private transient Map<String, SubsystemPermission> permissions = new HashMap<String, SubsystemPermission>();
    private boolean all_allowed;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof SubsystemPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        SubsystemPermission sp = (SubsystemPermission)permission;
        if (sp.subsystem != null) {
            throw new IllegalArgumentException("cannot add to collection: " + sp);
        }
        String name = sp.getName();
        SubsystemPermissionCollection subsystemPermissionCollection = this;
        synchronized (subsystemPermissionCollection) {
            Map<String, SubsystemPermission> pc = this.permissions;
            SubsystemPermission existing = pc.get(name);
            if (existing != null) {
                int oldMask = existing.action_mask;
                int newMask = sp.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new SubsystemPermission(existing.filter, oldMask | newMask));
                }
            } else {
                pc.put(name, sp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<SubsystemPermission> perms;
        if (!(permission instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission requested = (SubsystemPermission)permission;
        if (requested.filter != null) {
            return false;
        }
        int effective = 0;
        SubsystemPermissionCollection subsystemPermissionCollection = this;
        synchronized (subsystemPermissionCollection) {
            int desired;
            SubsystemPermission sp;
            Map<String, SubsystemPermission> pc = this.permissions;
            if (this.all_allowed && (sp = pc.get("*")) != null && ((effective |= sp.action_mask) & (desired = requested.action_mask)) == desired) {
                return true;
            }
            perms = pc.values();
        }
        for (SubsystemPermission perm : perms) {
            if (!perm.implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<SubsystemPermission> all = new ArrayList<SubsystemPermission>(this.permissions.values());
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", this.permissions);
        pfields.put("all_allowed", this.all_allowed);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        HashMap p;
        ObjectInputStream.GetField gfields = in.readFields();
        this.permissions = p = (HashMap)gfields.get("permissions", null);
        this.all_allowed = gfields.get("all_allowed", false);
    }
}

