/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.tx.jta.impl.XARecoveryDataHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class WSATAsyncResource
implements Serializable {
    private static final long serialVersionUID = 4244509484588694781L;
    private static final transient TraceComponent tc = Tr.register(WSATAsyncResource.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final Xid _xid;
    protected final String _XAResourceFactoryFilter;
    protected final Serializable _XAResourceFactoryKey;

    public WSATAsyncResource(String factoryFilter, Serializable key, Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSATAsyncResource", (Object[])new Object[]{factoryFilter, key, xid});
        }
        this._xid = xid;
        this._XAResourceFactoryFilter = factoryFilter;
        this._XAResourceFactoryKey = key;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSATAsyncResource", (Object)this);
        }
    }

    String getTxIdentifier() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTxIdentifier", (Object[])new Object[]{this._xid});
        }
        return this._xid.toString();
    }

    public int prepareOperation() throws XAException, XAResourceNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareOperation", (Object[])new Object[]{this});
        }
        int retVal = this.getXAResource().prepare(this._xid);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareOperation", (Object)retVal);
        }
        return retVal;
    }

    public void commitOperation() throws XAException, XAResourceNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commitOperation", (Object[])new Object[]{this});
        }
        this.getXAResource().commit(this._xid, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commitOperation");
        }
    }

    public void rollbackOperation() throws XAException, XAResourceNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackOperation", (Object[])new Object[]{this});
        }
        this.getXAResource().rollback(this._xid);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackOperation");
        }
    }

    public void forgetOperation() throws XAException, XAResourceNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forgetOperation", (Object[])new Object[]{this});
        }
        this.getXAResource().forget(this._xid);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forgetOperation");
        }
    }

    byte[] toLogData() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toLogData", (Object[])new Object[]{this});
        }
        byte[] logData = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            logData = baos.toByteArray();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.wstx.WSATAsyncResource.toLogData", (String)"279", (Object)this);
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"toLogData", (Object)se);
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toLogData", (Object)logData);
        }
        return logData;
    }

    static WSATAsyncResource fromLogData(byte[] bytes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fromLogData", (Object[])new Object[]{bytes});
        }
        WSATAsyncResource resource = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            resource = (WSATAsyncResource)obj;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.wstx.WSATAsyncResource.fromLogData", (String)"307");
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fromLogData", (Object)se);
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fromLogData", (Object)resource);
        }
        return resource;
    }

    String describe() {
        return this._XAResourceFactoryKey.toString();
    }

    Serializable getKey() {
        return this._XAResourceFactoryKey;
    }

    private XAResource getXAResource() throws XAResourceNotAvailableException {
        try {
            XAResourceFactory factory = XARecoveryDataHelper.lookupXAResourceFactory((String)this._XAResourceFactoryFilter);
            if (factory == null) {
                throw new XAResourceNotAvailableException();
            }
            return factory.getXAResource(this._XAResourceFactoryKey);
        }
        catch (XAResourceNotAvailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XAResourceNotAvailableException((Throwable)e);
        }
    }
}

