/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.blueprint.transform.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.blueprint.transform.BlueprintXml;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.aries.util.io.IOUtils;

public class BlueprintXmlImpl
implements BlueprintXml {
    private static final TraceComponent tc = Tr.register(BlueprintXmlImpl.class, (String)"Aries.blueprint.extensions", null);
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.eba.blueprint.transform.messages.BPTRANSFORMmessages");
    private final File tempDirectory;
    private final URL url;
    private boolean modified = false;
    private File overriddenXML;
    private File newOutputFile;
    private InputStream is;
    private OutputStream os;

    public BlueprintXmlImpl(File tempFileDirectory, URL u) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BlueprintXmlImpl", (Object[])new Object[]{tempFileDirectory, u});
        }
        this.tempDirectory = tempFileDirectory;
        this.url = u;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BlueprintXmlImpl");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInputStream", (Object[])new Object[0]);
        }
        IOUtils.close((Closeable)this.is);
        this.is = this.overriddenXML == null ? this.url.openStream() : new FileInputStream(this.overriddenXML);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInputStream", (Object)this.is);
        }
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream", (Object[])new Object[0]);
        }
        if (this.modified) {
            throw new IOException(nls.getFormattedMessage("BLUEPRINT_XML_MULTIPLE_OUTPUT_STREAMS", new Object[0], "CWSAA1005E: An internal error has occurred. Only one OutputStream can be obtained for a BlueprintXml."));
        }
        this.modified = true;
        if (this.newOutputFile == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating a new temporary output file for URL " + this.url), (Object[])new Object[0]);
            }
            this.newOutputFile = File.createTempFile("blueprint", "xml", this.tempDirectory);
            this.newOutputFile.deleteOnExit();
        }
        this.os = new FileOutputStream(this.newOutputFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream", (Object)this.os);
        }
        return this.os;
    }

    @Override
    public String getPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPath", (Object[])new Object[0]);
        }
        String s = this.url.getPath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPath", (Object)s);
        }
        return s;
    }

    public void cleanUp(boolean rollBack) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanUp", (Object[])new Object[]{rollBack});
        }
        if (!rollBack && this.modified) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("File for URL " + this.url + "has been modified and being replaced"), (Object[])new Object[0]);
            }
            File tmp = this.overriddenXML;
            this.overriddenXML = this.newOutputFile;
            this.newOutputFile = tmp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.modified && rollBack) {
            Tr.debug((TraceComponent)tc, (String)("File for URL " + this.url + "was modified but there was an error while " + "running the transformer, so the changes will be ignored."), (Object[])new Object[0]);
        }
        this.modified = false;
        IOUtils.close((Closeable)this.is);
        IOUtils.close((Closeable)this.os);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanUp");
        }
    }

    public boolean overridden() {
        boolean overridden;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"overridden", (Object[])new Object[0]);
        }
        boolean bl = overridden = this.overriddenXML != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"overridden", (Object)overridden);
        }
        return overridden;
    }

    public String toString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toString", (Object[])new Object[0]);
            Tr.exit((TraceComponent)tc, (String)"toString", (Object)this.url);
        }
        return this.url.toString();
    }
}

