/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.blueprint.transform.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.blueprint.transform.BlueprintBundle;
import com.ibm.ws.eba.blueprint.transform.impl.BlueprintXmlImpl;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.osgi.framework.Bundle;

public class BlueprintBundleImpl
implements BlueprintBundle {
    private static final TraceComponent tc = Tr.register(BlueprintBundleImpl.class, (String)"Aries.blueprint.extensions", null);
    private final Bundle _bundle;
    private final Collection<BlueprintXmlImpl> _blueprints = new ArrayList<BlueprintXmlImpl>();

    public BlueprintBundleImpl(Bundle bundle, File tempFileDirectory, Collection<URL> bpFiles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BlueprintBundleImpl", (Object[])new Object[]{bundle, tempFileDirectory, bpFiles});
        }
        this._bundle = bundle;
        for (URL u : bpFiles) {
            this._blueprints.add(new BlueprintXmlImpl(tempFileDirectory, u));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BlueprintBundleImpl");
        }
    }

    @Override
    public Bundle getBundle() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBundle", (Object[])new Object[0]);
            Tr.exit((TraceComponent)tc, (String)"getBundle", (Object)this._bundle);
        }
        return this._bundle;
    }

    public Collection<BlueprintXmlImpl> getXmlFiles() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXmlFiles", (Object[])new Object[0]);
            Tr.exit((TraceComponent)tc, (String)"getXmlFiles", this._blueprints);
        }
        return Collections.unmodifiableCollection(this._blueprints);
    }

    public void cleanUp(boolean rollBack) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanUp", (Object[])new Object[]{rollBack});
        }
        for (BlueprintXmlImpl xml : this._blueprints) {
            xml.cleanUp(rollBack);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanUp");
        }
    }

    public String toString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toString", (Object[])new Object[0]);
        }
        String s = this._bundle.getSymbolicName() + "_" + this._bundle.getVersion() + "\n" + this._blueprints;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toString", (Object)s);
        }
        return s;
    }
}

