/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.blueprint.transform.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.blueprint.transform.BlueprintTransformer;
import com.ibm.ws.eba.blueprint.transform.impl.BlueprintBundleImpl;
import com.ibm.ws.eba.blueprint.transform.impl.BlueprintXmlImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Activator
implements BundleActivator {
    public static final String BUNDLE_BLUEPRINT = "Bundle-Blueprint";
    private static final TraceComponent tc = Tr.register(Activator.class, (String)"Aries.blueprint.extensions", (String)"com.ibm.ws.eba.blueprint.transform.messages.BPTRANSFORMmessages");
    private static final String BLUEPRINT_SYM_NAME = "com.ibm.ws.org.apache.aries.blueprint.1.3.0";
    private static final int STATES = 62;
    private static final int ESA_STATES = 60;
    private BundleContext ctx;
    private ServiceTracker st;
    private File tempFileDirectory;
    private BundleTracker<Bundle> subsystemBundles;
    static final long serialVersionUID = -7764369845066989677L;

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private BundleContext getBlueprintBundleContext() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBlueprintBundleContext", (Object[])new Object[0]);
        }
        for (Bundle b : this.ctx.getBundles()) {
            if (!b.getSymbolicName().equals(BLUEPRINT_SYM_NAME)) continue;
            if (b.getState() != 32) {
                try {
                    b.start();
                }
                catch (BundleException bundleException) {
                    void e;
                    FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.eba.blueprint.transform.impl.Activator", (String)"99", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)e, (String)(Activator.class.getName() + ".getBlueprintBundleContext"), (String)"86");
                    IOException ioe = new IOException(Tr.formatMessage((TraceComponent)tc, (String)"ACTIVATOR_CANNOT_START_BLUEPRINT_BUNDLE", (Object[])new Object[0]), (Throwable)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getBlueprintBundleContext", (Object)ioe);
                    }
                    throw ioe;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBlueprintBundleContext", (Object)b.getBundleContext());
            }
            return b.getBundleContext();
        }
        IOException ioe = new IOException(Tr.formatMessage((TraceComponent)tc, (String)"ACTIVATOR_CANNOT_FIND_BLUEPRINT_BUNDLE", (Object[])new Object[0]));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBlueprintBundleContext", (Object)ioe);
        }
        throw ioe;
    }

    /*
     * WARNING - void declaration
     */
    private void processBundle(Bundle b) {
        try {
            this.processBlueprints(b);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.blueprint.transform.impl.Activator", (String)"126", (Object)this, (Object[])new Object[]{b});
            FFDCFilter.processException((Throwable)e, (String)(Activator.class.getName() + ".addingBundle"), (String)"120");
        }
    }

    @ManualTrace
    public void start(BundleContext ctx) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[]{ctx});
        }
        this.ctx = ctx;
        this.st = new ServiceTracker(ctx, BlueprintTransformer.class.getName(), null);
        this.st.open();
        File root = ctx.getDataFile("");
        if (root == null) {
            Tr.error((TraceComponent)tc, (String)"BPTRANSFORM_NO_DATA_FILE_SUPPORT", (Object[])new Object[0]);
            throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"BPTRANSFORM_NO_DATA_FILE_SUPPORT", (Object[])new Object[0]));
        }
        this.tempFileDirectory = new File(root, "com.ibm.ws.eba.blueprint.transform");
        if (!this.tempFileDirectory.exists() && !this.tempFileDirectory.mkdirs()) {
            Tr.error((TraceComponent)tc, (String)"BPTRANSFORM_TEMP_DIR_CREATE_FAILED", (Object[])new Object[0]);
            throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"BPTRANSFORM_TEMP_DIR_CREATE_FAILED", (Object[])new Object[0]));
        }
        this.subsystemBundles = new BundleTracker(Activator.getSystemBundleContext(ctx), 60, (BundleTrackerCustomizer)new ESASubsystemSupport());
        this.subsystemBundles.open();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(BundleContext ctx) {
        if (this.subsystemBundles != null) {
            this.subsystemBundles.close();
        }
        if (this.st != null) {
            this.st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    private void processBlueprints(Bundle bundle) throws IOException {
        Collection<URL> bpFiles;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processBlueprints", (Object[])new Object[]{bundle});
        }
        if (!(bpFiles = this.findBluePrintConfigURLandPaths(bundle)).isEmpty()) {
            Object[] services;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found blueprint files: " + bpFiles), (Object[])new Object[0]);
            }
            if ((services = this.st.getServices()) != null) {
                BlueprintBundleImpl bpBundle = new BlueprintBundleImpl(bundle, this.tempFileDirectory, bpFiles);
                for (Object svc : services) {
                    BlueprintTransformer transformer = (BlueprintTransformer)svc;
                    boolean failed = false;
                    try {
                        transformer.transformBlueprintBundle(bpBundle);
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.blueprint.transform.impl.Activator", (String)"198", (Object)this, (Object[])new Object[]{bundle});
                        FFDCFilter.processException((Throwable)e, (String)(Activator.class.getName() + ".processBlueprints"), (String)"184");
                        failed = true;
                    }
                    bpBundle.cleanUp(failed);
                }
                BundleContext bluprintContext = this.getBlueprintBundleContext();
                for (BlueprintXmlImpl xml : bpBundle.getXmlFiles()) {
                    String overridePath;
                    File output;
                    if (!xml.overridden()) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Override found for file " + xml), (Object[])new Object[0]);
                    }
                    if ((output = bluprintContext.getDataFile(overridePath = Integer.toHexString(bundle.hashCode()) + "/" + xml.getPath())) == null) {
                        throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"NO_FILE_SYSTEM_SUPPORT", (Object[])new Object[0]));
                    }
                    File parent = output.getParentFile();
                    if (parent.exists() || parent.mkdirs()) {
                        FileOutputStream os;
                        block17: {
                            InputStream is = null;
                            os = null;
                            try {
                                byte[] bytes = new byte[8096];
                                is = xml.getInputStream();
                                os = new FileOutputStream(output);
                                int read = is.read(bytes);
                                while (read != -1) {
                                    ((OutputStream)os).write(bytes, 0, read);
                                    read = is.read(bytes);
                                }
                                if (is == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (is != null) {
                                    IOUtils.close((Closeable)is);
                                }
                                if (os != null) {
                                    IOUtils.close(os);
                                }
                                throw throwable;
                            }
                            IOUtils.close((Closeable)is);
                        }
                        if (os == null) continue;
                        IOUtils.close((Closeable)os);
                        continue;
                    }
                    throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"UNABLE_TO_CREATE_BLUEPRINT_OVERRIDE_DIRECTORY", (Object[])new Object[0]));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processBlueprints");
        }
    }

    @ManualTrace
    private Collection<URL> findBluePrintConfigURLandPaths(Bundle toCheck) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findBluePrintConfigURLandPaths", (Object[])new Object[0]);
        }
        AbstractCollection resources = new LinkedHashSet<URL>();
        String bp = (String)toCheck.getHeaders("").get(BUNDLE_BLUEPRINT);
        if (bp != null) {
            if ("".equals(bp)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findBluePrintConfigURLandPaths", resources);
                }
                return resources;
            }
            Map files = ManifestHeaderProcessor.parseImportString((String)bp);
            for (String filePath : files.keySet()) {
                int wildCard = filePath.indexOf(42);
                String wildCardString = null;
                if (wildCard != -1) {
                    wildCardString = filePath.substring(filePath.lastIndexOf(47) + 1);
                    filePath = filePath.substring(0, filePath.lastIndexOf(47));
                } else if (filePath.charAt(filePath.length() - 1) == '/') {
                    wildCardString = "*.xml";
                }
                if (wildCardString != null) {
                    Enumeration urls = toCheck.findEntries(filePath, wildCardString, false);
                    if (urls == null) continue;
                    resources.addAll(Collections.list(urls));
                    continue;
                }
                URL u = toCheck.getResource(filePath);
                if (u == null) continue;
                resources.add((URL)u);
            }
        } else {
            Enumeration urls = toCheck.findEntries("OSGI-INF/blueprint", "*.xml", false);
            if (urls != null) {
                resources = Collections.list(urls);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findBluePrintConfigURLandPaths", resources);
        }
        return resources;
    }

    private static BundleContext getSystemBundleContext(BundleContext ctx) {
        Bundle systemBundle = ctx.getBundle("System Bundle");
        if (systemBundle == null) {
            return ctx;
        }
        return systemBundle.getBundleContext();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ESASubsystemSupport
    implements BundleTrackerCustomizer<Bundle> {
        private Boolean restrictAddingBundle;
        static final long serialVersionUID = -7033061233865050338L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         */
        @ManualTrace
        public ESASubsystemSupport() {
            block4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"ESASubsystemSupport", (Object[])new Object[0]);
                }
                try {
                    this.restrictAddingBundle = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                        static final long serialVersionUID = 633466628483580966L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Boolean run() {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Checking for custom property", (Object[])new Object[0]);
                            }
                            return Boolean.getBoolean("com.ibm.ws.eba.blueprint.transform.impl.RestrictAddingBundle");
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.blueprint.transform.impl.Activator$ESASubsystemSupport$1", 1.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    void e;
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.eba.blueprint.transform.impl.Activator$ESASubsystemSupport", (String)"364", (Object)this, (Object[])new Object[]{Activator.this});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Exception setting custom property", (Object[])new Object[]{e});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ESASubsystemSupport", (Object)this.restrictAddingBundle);
            }
        }

        @ManualTrace
        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
            int eType = 0;
            if (event != null) {
                eType = event.getType();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addingBundle", (Object[])new Object[]{bundle, "event: " + eType, "state:" + bundle.getState()});
            }
            if (!this.restrictAddingBundle.booleanValue() || Activator.this.ctx.getBundle(bundle.getBundleId()) == null && Activator.this.ctx.getBundle(bundle.getLocation()) == bundle) {
                Activator.this.processBundle(bundle);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addingBundle", (Object)bundle);
                }
                return bundle;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addingBundle");
            }
            return null;
        }

        @ManualTrace
        public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle tracked) {
            int eType = 0;
            if (event != null) {
                eType = event.getType();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"modifiedBundle", (Object[])new Object[]{bundle, "event: " + eType, "state:" + bundle.getState()});
            }
            if (event != null && (event.getType() == 8 || event.getType() == 128 && !this.restrictAddingBundle.booleanValue())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Need to reprocess bundle: " + bundle), (Object[])new Object[0]);
                }
                Activator.this.processBundle(bundle);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"modifiedBundle", (Object)bundle);
            }
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Bundle tracked) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.blueprint.transform.impl.Activator$ESASubsystemSupport", ESASubsystemSupport.class, null, null);
        }
    }
}

