/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.futures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
abstract class ESAAggregateFuture
implements Future<Boolean> {
    private static final String BLUEPRINT_CLASS = "org.apache.aries.blueprint.utils.HeaderParser";
    protected final Future<Boolean> initialFuture;
    protected final List<Future<Void>> futuresForThisEsa = new ArrayList<Future<Void>>();
    protected final Subsystem esaSubsystem;
    protected final BundleContext context;
    protected final FutureMonitor monitor;
    static final long serialVersionUID = -3676870053856067842L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ESAAggregateFuture(Future<Boolean> initialFuture, Subsystem esaSubsystem, BundleContext context, FutureMonitor monitor) {
        this.initialFuture = initialFuture;
        this.esaSubsystem = esaSubsystem;
        this.context = context;
        this.monitor = monitor;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    @FFDCIgnore(value={TimeoutException.class})
    public Boolean get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long endTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
        while (!this.isDone() && System.nanoTime() < endTime) {
            Thread.sleep(200L);
        }
        if (this.isDone()) {
            return this.initialFuture.get();
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        if (!this.initialFuture.isDone()) {
            return false;
        }
        AppStateCheck applicationStateResult = this.applicationStateCheck();
        switch (applicationStateResult) {
            case COMPLETE: {
                return true;
            }
            case INCOMPLETE: {
                return false;
            }
        }
        return this.aggregateFuturesDone();
    }

    abstract AppStateCheck applicationStateCheck();

    BundleContext getContext() {
        return this.context;
    }

    FutureMonitor getMonitor() {
        return this.monitor;
    }

    private final boolean aggregateFuturesDone() {
        for (Future<Void> f : this.futuresForThisEsa) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }

    static Bundle[] getBundleConstituentsFromFeature(Subsystem subsystem) {
        Bundle[] bundlesFromContext;
        ArrayList<Bundle> constituentBundleList = new ArrayList<Bundle>();
        Collection<Capability> subsystemConstituentIdentities = ESAAggregateFuture.getIdentities(subsystem.getConstituents());
        for (Bundle ctxtBundle : bundlesFromContext = subsystem.getBundleContext().getBundles()) {
            if (!ESAAggregateFuture.bundleMatchesConstituent(ctxtBundle, subsystemConstituentIdentities)) continue;
            constituentBundleList.add(ctxtBundle);
        }
        return constituentBundleList.toArray(new Bundle[constituentBundleList.size()]);
    }

    private static Collection<Capability> getIdentities(Collection<Resource> constituents) {
        ArrayList<Capability> identities = new ArrayList<Capability>(constituents.size());
        for (Resource res : constituents) {
            List resourceIdentityCaps = res.getCapabilities("osgi.identity");
            if (resourceIdentityCaps.isEmpty()) continue;
            identities.add((Capability)resourceIdentityCaps.get(0));
        }
        return identities;
    }

    private static boolean bundleMatchesConstituent(Bundle srBundle, Collection<Capability> subsystemConstituents) {
        boolean matches = false;
        BundleRevision rev = (BundleRevision)srBundle.adapt(BundleRevision.class);
        if (rev == null) {
            return false;
        }
        List bundleIdentityCaps = rev.getCapabilities("osgi.identity");
        if (bundleIdentityCaps.isEmpty()) {
            return false;
        }
        Capability bundleIdentityCap = (Capability)rev.getCapabilities("osgi.identity").get(0);
        Map bundleIdentityAttrs = bundleIdentityCap.getAttributes();
        for (Capability resourceIdentityCap : subsystemConstituents) {
            Map resourceIdentityAttrs = resourceIdentityCap.getAttributes();
            if (!resourceIdentityAttrs.equals(bundleIdentityAttrs)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    static boolean isBlueprintAvailable() {
        try {
            Class.forName(BLUEPRINT_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.app.manager.esa.internal.futures.ESAAggregateFuture", ESAAggregateFuture.class, null, null);
    }

    static enum AppStateCheck {
        COMPLETE,
        INCOMPLETE,
        FUTURES;

    }
}

