/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.futures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.esa.internal.futures.AbstractElementFuture;
import com.ibm.ws.app.manager.esa.internal.futures.ESAAggregateFuture;
import com.ibm.ws.app.manager.esa.internal.futures.WABDeployedFuture;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
abstract class AbstractWABFuture
extends AbstractElementFuture
implements EventHandler {
    static final String WAB_EVENT_PREFIX = "org/osgi/service/web/";
    static final String WAB_DEPLOYED_EVENT = "org/osgi/service/web/DEPLOYED";
    static final String WAB_DEPLOYING_EVENT = "org/osgi/service/web/DEPLOYING";
    static final String WAB_UNDEPLOYING_EVENT = "org/osgi/service/web/UNDEPLOYING";
    static final String WAB_UNDEPLOYED_EVENT = "org/osgi/service/web/UNDEPLOYED";
    static final String WAB_FAILED_EVENT = "org/osgi/service/web/FAILED";
    private final Long bundleId;
    private final String contextPath;
    private final ServiceRegistration<EventHandler> handlerReg;
    private volatile boolean validated = false;
    static final long serialVersionUID = -5122939238437541399L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    AbstractWABFuture(ESAAggregateFuture esaAggregate, Long bundleId, String contextPath, String ... topics) {
        super(esaAggregate);
        this.bundleId = bundleId;
        this.contextPath = this.WASContextPathNormalize(contextPath);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>(1);
        ((Dictionary)props).put("event.topics", topics);
        this.handlerReg = esaAggregate.getContext().registerService(EventHandler.class, (Object)this, props);
    }

    public void handleEvent(Event event) {
        String eContextPath = (String)event.getProperty("context.path");
        Long eBundleId = (Long)event.getProperty("bundle.id");
        if (this.bundleId.equals(eBundleId) && this.contextPath.equals(eContextPath)) {
            this.eventTopicAction(event, event.getTopic());
        }
    }

    protected abstract void eventTopicAction(Event var1, String var2);

    @FFDCIgnore(value={IllegalStateException.class})
    protected void unregister() {
        try {
            this.handlerReg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private String WASContextPathNormalize(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.endsWith("/") && !contextPath.equals("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isValid()) {
            return (Void)this.elementFuture.get(timeout, unit);
        }
        return null;
    }

    @Override
    public boolean isDone() {
        if (this.isValid()) {
            return this.elementFuture.isDone();
        }
        return !(this instanceof WABDeployedFuture);
    }

    protected void validate() {
        this.validated = true;
    }

    private boolean isValid() {
        switch (this.esaAggregate.applicationStateCheck()) {
            case COMPLETE: 
            case FUTURES: {
                return this.validated;
            }
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.app.manager.esa.internal.futures.AbstractWABFuture", AbstractWABFuture.class, null, null);
    }
}

