/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.featuremanager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.esa.internal.featuremanager.Feature;
import com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureBundleFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureResourceManager
implements RuntimeUpdateListener {
    private final FeatureProvisioner featureProvisioner;
    private final BundleContext parentContext;
    private final Subsystem sharedSubsystem;
    private final Collection<Feature> features = new ArrayList<Feature>();
    private final Set<String> cachedFeatures = new HashSet<String>();
    private final Map<Feature, Bundle> installedVirtualFeatureBundles = new ConcurrentHashMap<Feature, Bundle>();
    private ServiceRegistration<RuntimeUpdateListener> updateListenerReg;
    static final long serialVersionUID = 7984407840904225072L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FeatureResourceManager(FeatureProvisioner featureProvisioner, BundleContext parentContext, Subsystem sharedSubsystem) {
        this.featureProvisioner = featureProvisioner;
        this.parentContext = parentContext;
        this.sharedSubsystem = sharedSubsystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.updateListenerReg = this.parentContext.registerService(RuntimeUpdateListener.class, (Object)this, new Hashtable());
        Collection<Feature> collection = this.features;
        synchronized (collection) {
            String apiServiceHeaderElements = this.featureProvisioner.getKernelApiServices();
            Feature f = new Feature("kernelCore-1.0", apiServiceHeaderElements);
            this.features.add(f);
        }
        this.processInstalledFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.updateListenerReg.unregister();
        Collection<Feature> collection = this.features;
        synchronized (collection) {
            for (Bundle b : this.installedVirtualFeatureBundles.values()) {
                this.uninstallVirtualFeatureBundle(b);
            }
            this.features.clear();
            this.cachedFeatures.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInstalledFeatures() {
        Set featureStrings = this.featureProvisioner.getInstalledFeatures();
        Collection<Feature> collection = this.features;
        synchronized (collection) {
            HashSet addedFeatures = new HashSet();
            addedFeatures.addAll(featureStrings);
            addedFeatures.removeAll(this.cachedFeatures);
            HashSet<String> removedFeatures = new HashSet<String>();
            removedFeatures.addAll(this.cachedFeatures);
            removedFeatures.removeAll(featureStrings);
            if (!addedFeatures.isEmpty() || !removedFeatures.isEmpty()) {
                this.cachedFeatures.clear();
                this.cachedFeatures.addAll(featureStrings);
                Iterator<Feature> it = this.features.iterator();
                while (it.hasNext()) {
                    Feature feature = it.next();
                    if (!removedFeatures.contains(feature.toString())) continue;
                    it.remove();
                    this.uninstallFeature(feature);
                }
                for (String feature : addedFeatures) {
                    this.installFeature(feature);
                }
            }
        }
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if ("FeatureUpdatesCompleted".equals(notification.getName())) {
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 4805700554750374099L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    FeatureResourceManager.this.processInstalledFeatures();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    FeatureResourceManager.this.processInstalledFeatures();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager$1", 1.class, null, null);
                }
            });
        }
    }

    private void createAndInstallFeatureBundle(Feature f) {
        BundleContext sharedSystemBC = this.sharedSubsystem.getBundleContext();
        if (sharedSystemBC != null) {
            try {
                Bundle virtualFeatureBundle = FeatureBundleFactory.createAndInstallFeatureBundle(sharedSystemBC, f);
                this.installedVirtualFeatureBundles.put(f, virtualFeatureBundle);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager", (String)"141", (Object)this, (Object[])new Object[]{f});
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager", (String)"142", (Object)this, (Object[])new Object[]{f});
            }
        }
    }

    private void installFeature(String feature) {
        FeatureDefinition definition = this.featureProvisioner.getFeatureDefinition(feature);
        this.installFeature(definition);
    }

    private void installFeature(FeatureDefinition definition) {
        String apiServiceHeaderElements = definition.getApiServices();
        Feature f = new Feature(definition.getFeatureName(), apiServiceHeaderElements);
        this.features.add(f);
        if (!f.getServices().isEmpty()) {
            this.createAndInstallFeatureBundle(f);
        }
    }

    private void uninstallFeature(Feature feature) {
        this.uninstallVirtualFeatureBundle(this.installedVirtualFeatureBundles.remove(feature));
    }

    private void uninstallVirtualFeatureBundle(Bundle b) {
        try {
            if (b != null) {
                b.uninstall();
            }
        }
        catch (BundleException bundleException) {
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager", (String)"188", (Object)this, (Object[])new Object[]{b});
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager", FeatureResourceManager.class, null, null);
    }
}

