/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.esa.internal.AppInstallsCalledCompletionListener;
import com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction;
import com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring;
import com.ibm.ws.app.manager.esa.internal.OsgiLibraryConfiguration;
import com.ibm.ws.app.manager.esa.internal.SubsystemInformation;
import com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction;
import com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureResourceManager;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.eba.bundle.repository.BundleRepositoriesReady;
import com.ibm.ws.eba.wab.integrator.EbaProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ApiRegion;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.MaskedPathEntry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.artifact.equinox.module.ModuleContainerFinder;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.subsystem.AriesSubsystem;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.repository.Repository;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.app.manager.esa.handler", service={ApplicationHandler.class, EbaProvider.class, ModuleContainerFinder.class, RuntimeUpdateListener.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM", "type=esa"})
public class SubsystemHandler
implements ApplicationHandler<SubsystemInformation>,
EbaProvider,
ModuleContainerFinder,
RuntimeUpdateListener {
    private static final TraceComponent _tc = Tr.register(SubsystemHandler.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler");
    private static final String CLASS_NAME = SubsystemHandler.class.getName();
    private static final String SHARED_SUBSYSTM_LOCATION = "resources/com.ibm.ws.esa.shared.bundle.subsystem.esa";
    private BundleContext _context;
    private FutureMonitor _monitor;
    private AriesSubsystem _rootSubsystem;
    private AriesSubsystem _sharedSubsystem;
    private FeatureProvisioner _featureProvisioner;
    private ServiceRegistration<WeavingHook> _weavingHookReg;
    private FeatureResourceManager _featureResourceManager;
    private ExecutorService _executor;
    private final OsgiLibraryWaiter _libraryWaiter = new OsgiLibraryWaiter();
    private final Object _subsytemLock = new SubsystemInstallUninstallLock();
    private final ConcurrentMap<String, SubsystemInformation> _apps = new ConcurrentHashMap<String, SubsystemInformation>();
    private final ConcurrentMap<String, Container> _appContainers = new ConcurrentHashMap<String, Container>();
    private final AtomicBoolean debugEnabled = new AtomicBoolean(false);
    private AppInstallsCalledCompletionListener installsCalledListener;
    @Reference
    private ApplicationInfoFactory applicationInfoFactory;
    @Reference(name="regionDigraph", service=RegionDigraph.class)
    private RegionDigraph regionDigraph;
    @Reference(name="metaDataService", service=MetaDataService.class)
    private MetaDataService metaDataService;
    @Reference(name="stateChangeService", service=StateChangeService.class)
    private StateChangeService stateChangeService;
    static final long serialVersionUID = -8602965305788266184L;

    @Activate
    protected void activateHandler(ComponentContext cc, Map<String, Object> config) {
        this.modifyHandler(config);
        this._context = cc.getBundleContext();
        WeavingHook wh = new WeavingHook(){
            static final long serialVersionUID = 4694317123561070284L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void weave(WovenClass wovenClass) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$1");
            }
        };
        Hashtable<String, String> weavingHookProps = new Hashtable<String, String>();
        ((Dictionary)weavingHookProps).put("osgi.woven.packages", "org.apache.openjpa.enhance,org.apache.openjpa.util,org.eclipse.persistence.internal.weaving,org.eclipse.persistence.internal.descriptors,org.eclipse.persistence.queries,org.eclipse.persistence.descriptors.changetracking,org.eclipse.persistence.internal.identitymaps,org.eclipse.persistence.sessions,org.eclipse.persistence.internal.jpa.rs.metadata.model,org.eclipse.persistence.indirection");
        this._weavingHookReg = this._context.registerService(WeavingHook.class, (Object)wh, weavingHookProps);
        this.installsCalledListener = new AppInstallsCalledCompletionListener(this.getFutureMonitor());
    }

    @Modified
    protected void modifyHandler(Map<String, Object> config) {
        Object libraryCountConfig = config.get("OsgiLibraryMarker.count");
        if (libraryCountConfig instanceof String) {
            try {
                this._libraryWaiter.setExpected(Integer.valueOf((String)libraryCountConfig));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"178", (Object)this, (Object[])new Object[]{config});
                this._libraryWaiter.setExpected(0);
            }
        } else {
            this._libraryWaiter.setExpected(0);
        }
        Object debugConfig = config.get("enable.debug");
        this.debugEnabled.set(debugConfig instanceof Boolean ? (Boolean)debugConfig : false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Deactivate
    protected void deactivateHandler(ComponentContext c) {
        if (this._weavingHookReg != null) {
            this._weavingHookReg.unregister();
        }
        if (this._featureResourceManager != null) {
            this._featureResourceManager.stop();
        }
        Object object = this._subsytemLock;
        synchronized (object) {
            block8: {
                if (this._sharedSubsystem != null) {
                    try {
                        this._sharedSubsystem.uninstall();
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"207", (Object)this, (Object[])new Object[]{c});
                        if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block8;
                        Tr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred while uninstalling the shared subsystem", (Object[])new Object[]{e});
                    }
                }
            }
        }
    }

    BundleContext getContext() {
        return this._context;
    }

    Object getSubsystemInstallUninstallLock() {
        return this._subsytemLock;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setFutureMonitor(FutureMonitor fm) {
        this._monitor = fm;
    }

    protected void unsetFutureMonitor(FutureMonitor fm) {
    }

    FutureMonitor getFutureMonitor() {
        return this._monitor;
    }

    @Reference(target="(&(subsystem.id=0)(subsystem.state=ACTIVE))")
    protected void setRootSubsystem(AriesSubsystem rootSubsystem) {
        this._rootSubsystem = rootSubsystem;
    }

    protected void unsetRootSubsystem(AriesSubsystem rootSubsystem) {
    }

    @Reference(service=Repository.class)
    protected void setRepository(ServiceReference<Repository> ref) {
    }

    protected void unsetRepository(ServiceReference<?> ref) {
    }

    @Reference
    protected void setFeatureProvisioner(FeatureProvisioner featureProvisioner) {
        this._featureProvisioner = featureProvisioner;
    }

    protected void unsetFeatureProvisioner(FeatureProvisioner featureProvisioner) {
    }

    @Reference
    protected void setBundleRepositoryHelper(BundleRepositoriesReady ref) {
    }

    protected void unsetBundleRepositoryHelper(BundleRepositoriesReady ref) {
    }

    ApplicationInfoFactory getApplicationInfoFactory() {
        return this.applicationInfoFactory;
    }

    protected MetaDataService getMetaDataService() {
        return this.metaDataService;
    }

    public StateChangeService getStateChangeService() {
        return this.stateChangeService;
    }

    @Reference
    protected void setExecutorService(ExecutorService executorService) {
        this._executor = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this._executor = null;
    }

    ExecutorService getExecutor() {
        return this._executor;
    }

    public Future<Boolean> install(ApplicationInformation<SubsystemInformation> applicationInformation) {
        this._libraryWaiter.waitForLibraries();
        DeploySubsystemAction deployAction = new DeploySubsystemAction(applicationInformation, this);
        return deployAction.deploy();
    }

    /*
     * WARNING - void declaration
     */
    AriesSubsystem getSharedSubsystem() {
        AriesSubsystem sharedSubsystem = this._sharedSubsystem;
        if (sharedSubsystem != null) {
            return sharedSubsystem;
        }
        for (Subsystem subsystem : this._rootSubsystem.getChildren()) {
            if (!SHARED_SUBSYSTM_LOCATION.equals(subsystem.getLocation())) continue;
            sharedSubsystem = (AriesSubsystem)subsystem;
            break;
        }
        if (sharedSubsystem == null) {
            try {
                URL url = this._context.getBundle().getEntry(SHARED_SUBSYSTM_LOCATION);
                sharedSubsystem = this._rootSubsystem.install(SHARED_SUBSYSTM_LOCATION, url.openStream());
                sharedSubsystem.start();
                this.updateSharedRegion((Subsystem)sharedSubsystem);
            }
            catch (Exception url) {
                void e;
                FFDCFilter.processException((Throwable)url, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"345", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"36");
                throw new SubsystemException((Throwable)e);
            }
        }
        this._featureResourceManager = new FeatureResourceManager(this._featureProvisioner, this._context, (Subsystem)sharedSubsystem);
        this._featureResourceManager.start();
        this._sharedSubsystem = sharedSubsystem;
        return this._sharedSubsystem;
    }

    private void updateSharedRegion(final Subsystem sharedSubsystem) throws BundleException {
        final RegionDigraph currentDigraph = this.regionDigraph;
        ApiRegion.update((RegionDigraph)this.regionDigraph, (Callable)new Callable<RegionDigraph>(){
            static final long serialVersionUID = 1839261210767641139L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public RegionDigraph call() throws BundleException, InvalidSyntaxException {
                Region oldRegion = currentDigraph.getRegion(sharedSubsystem.getBundleContext().getBundle());
                RegionDigraph copiedDigraph = currentDigraph.copy();
                Region newRegion = copiedDigraph.getRegion(oldRegion.getName());
                Set bundleIds = newRegion.getBundleIds();
                HashMap<String, RegionFilterBuilder> fromFilters = new HashMap<String, RegionFilterBuilder>();
                for (Region region : copiedDigraph) {
                    if (region.equals(newRegion)) continue;
                    for (RegionDigraph.FilteredRegion filteredRegion : region.getEdges()) {
                        if (!filteredRegion.getRegion().equals(newRegion)) continue;
                        RegionFilterBuilder filterBuilder = copiedDigraph.createRegionFilterBuilder();
                        Map sharingPolicy = filteredRegion.getFilter().getSharingPolicy();
                        for (Map.Entry entry : sharingPolicy.entrySet()) {
                            for (String filter : (Collection)entry.getValue()) {
                                filterBuilder.allow((String)entry.getKey(), filter);
                            }
                        }
                        fromFilters.put(region.getName(), filterBuilder);
                    }
                }
                copiedDigraph.removeRegion(newRegion);
                newRegion = copiedDigraph.createRegion(newRegion.getName());
                for (Long bundleId : bundleIds) {
                    newRegion.addBundle(bundleId.longValue());
                }
                Region parentRegion = copiedDigraph.getRegion(ApiRegion.ALL.getRegionName());
                RegionFilterBuilder parentFilter = copiedDigraph.createRegionFilterBuilder();
                parentFilter.allowAll("org.eclipse.equinox.allow.all");
                copiedDigraph.connect(newRegion, parentFilter.build(), parentRegion);
                for (Map.Entry entry : fromFilters.entrySet()) {
                    copiedDigraph.connect(copiedDigraph.getRegion((String)entry.getKey()), ((RegionFilterBuilder)entry.getValue()).build(), newRegion);
                }
                return copiedDigraph;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$2");
            }
        });
    }

    public Future<Boolean> uninstall(ApplicationInformation<SubsystemInformation> applicationInformation) {
        return new UninstallSubsystemAction(applicationInformation, this).uninstall();
    }

    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<SubsystemInformation> applicationInformation) {
        Container container = applicationInformation.getContainer();
        if (!this.hideNonSubsystemEntries(container)) {
            return null;
        }
        String loc = applicationInformation.getLocation();
        if (loc.regionMatches(true, loc.length() - ".xml".length(), ".xml", 0, ".xml".length())) {
            LooseAppMonitoring lam = new LooseAppMonitoring();
            return lam.configureLooseOSGiAppMonitoring(container);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hideNonSubsystemEntries(Container container) {
        MaskedPathEntry masker2;
        Entry entryToHide = container.getEntry("META-INF/application.xml");
        if (entryToHide != null) {
            try {
                masker2 = (MaskedPathEntry)entryToHide.adapt(MaskedPathEntry.class);
                masker2.mask();
            }
            catch (UnableToAdaptException masker2) {
                FFDCFilter.processException((Throwable)masker2, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"511", (Object)this, (Object[])new Object[]{container});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void utae;
                    Tr.debug((TraceComponent)_tc, (String)"UnableToAdaptException", (Object[])new Object[]{utae});
                }
                return false;
            }
        }
        if ((entryToHide = container.getEntry("META-INF/ibm-application-bnd.xml")) != null) {
            try {
                masker2 = (MaskedPathEntry)entryToHide.adapt(MaskedPathEntry.class);
                masker2.mask();
            }
            catch (UnableToAdaptException masker3) {
                FFDCFilter.processException((Throwable)masker3, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"523", (Object)this, (Object[])new Object[]{container});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void utae;
                    Tr.debug((TraceComponent)_tc, (String)"UnableToAdaptException", (Object[])new Object[]{utae});
                }
                return false;
            }
        }
        if ((entryToHide = container.getEntry("META-INF/ibm-application-ext.xml")) != null) {
            try {
                masker2 = (MaskedPathEntry)entryToHide.adapt(MaskedPathEntry.class);
                masker2.mask();
            }
            catch (UnableToAdaptException masker4) {
                FFDCFilter.processException((Throwable)masker4, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"535", (Object)this, (Object[])new Object[]{container});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void utae;
                    Tr.debug((TraceComponent)_tc, (String)"UnableToAdaptException", (Object[])new Object[]{utae});
                }
                return false;
            }
        }
        if ((entryToHide = container.getEntry("META-INF/ibm-application-bnd.xmi")) != null) {
            try {
                masker2 = (MaskedPathEntry)entryToHide.adapt(MaskedPathEntry.class);
                masker2.mask();
            }
            catch (UnableToAdaptException masker5) {
                FFDCFilter.processException((Throwable)masker5, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"547", (Object)this, (Object[])new Object[]{container});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void utae;
                    Tr.debug((TraceComponent)_tc, (String)"UnableToAdaptException", (Object[])new Object[]{utae});
                }
                return false;
            }
        }
        if ((entryToHide = container.getEntry("META-INF/ibm-application-ext.xmi")) != null) {
            try {
                masker2 = (MaskedPathEntry)entryToHide.adapt(MaskedPathEntry.class);
                masker2.mask();
            }
            catch (UnableToAdaptException masker6) {
                FFDCFilter.processException((Throwable)masker6, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"559", (Object)this, (Object[])new Object[]{container});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void utae;
                    Tr.debug((TraceComponent)_tc, (String)"UnableToAdaptException", (Object[])new Object[]{utae});
                }
                return false;
            }
        }
        return true;
    }

    public ApplicationInfo getApplicationInfo(Bundle bundle) {
        for (SubsystemInformation subsystemInfo : this._apps.values()) {
            BundleContext subsystemContext = subsystemInfo.getSubsystem().getBundleContext();
            if (subsystemContext == null || !bundle.equals(subsystemContext.getBundle(bundle.getBundleId()))) continue;
            return subsystemInfo.getApplicationInfo();
        }
        return null;
    }

    ConcurrentMap<String, Container> getContainers() {
        return this._appContainers;
    }

    ConcurrentMap<String, SubsystemInformation> getApplications() {
        return this._apps;
    }

    public Container findContainer(String location) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("SH: MCF: findContainer asked for " + location), (Object[])new Object[0]);
        }
        if (location.contains("!")) {
            String[] parts = location.split("!");
            String key = parts[0];
            String path = parts[1];
            SubsystemHandler.debug("SH: MCF: Checking containermap for " + key + " ::: " + path);
            Container c = (Container)this._appContainers.get(key);
            if (c != null) {
                SubsystemHandler.debug("SH: MCF: found container mapping for " + key);
                Entry entryAtPath = c.getEntry(path);
                if (entryAtPath != null) {
                    Container requested = null;
                    try {
                        SubsystemHandler.debug("SH: MCF: path was known, checking if it can be a container..");
                        requested = (Container)entryAtPath.adapt(Container.class);
                        if (requested != null) {
                            SubsystemHandler.debug("SH: MCF: container found, returning.");
                        }
                    }
                    catch (UnableToAdaptException unableToAdaptException) {
                        FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler", (String)"622", (Object)this, (Object[])new Object[]{location});
                    }
                    return requested;
                }
                SubsystemHandler.debug("SH: MCF: path was unknown to container found.");
            } else {
                SubsystemHandler.debug("SH: MCF: did not find a container, current keys are " + this._apps.keySet());
            }
        }
        return null;
    }

    @Trivial
    private static void debug(String message) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)message, (Object[])new Object[0]);
        }
    }

    @Trivial
    boolean isApplicationDebugEnabled() {
        return this.debugEnabled.get();
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if ("ApplicationsInstallCalled".equals(notification.getName())) {
            this.installsCalledListener.createInstallsCompleteFuture(notification);
        }
    }

    AppInstallsCalledCompletionListener getInstallsCalledListener() {
        return this.installsCalledListener;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOsgiLibraryMarker(OsgiLibraryConfiguration.OsgiLibraryMarker marker) {
        this._libraryWaiter.increment();
    }

    protected void unsetOsgiLibraryMarker(OsgiLibraryConfiguration.OsgiLibraryMarker marker) {
        this._libraryWaiter.decrement();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class OsgiLibraryWaiter {
        private int expectedNum = 0;
        private int currentNum = 0;
        static final long serialVersionUID = -6893201447496908510L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        OsgiLibraryWaiter() {
        }

        synchronized void setExpected(int expectedNum) {
            this.expectedNum = expectedNum;
            this.notifyAll();
        }

        synchronized void increment() {
            ++this.currentNum;
            this.notifyAll();
        }

        synchronized void decrement() {
            --this.currentNum;
            this.notifyAll();
        }

        synchronized void waitForLibraries() {
            while (this.expectedNum != this.currentNum) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$OsgiLibraryWaiter", (String)"687", (Object)this, (Object[])new Object[0]);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OsgiLibraryWaiter.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$OsgiLibraryWaiter");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class SubsystemInstallUninstallLock {
        static final long serialVersionUID = 1134652308686132173L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SubsystemInstallUninstallLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SubsystemInstallUninstallLock.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$SubsystemInstallUninstallLock");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SyntheticRequirement
    implements Requirement {
        private final String namespace;
        private final Map<String, String> directives;
        static final long serialVersionUID = -494651269349869435L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SyntheticRequirement(String namespace, String filter) {
            this.namespace = namespace;
            this.directives = Collections.singletonMap("filter", filter);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public Map<String, Object> getAttributes() {
            return Collections.emptyMap();
        }

        public Resource getResource() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SyntheticRequirement.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.SubsystemHandler$SyntheticRequirement");
        }
    }
}

