/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.esa.internal.SubsystemInformation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AddEntryToOverlay;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.manifest.ManifestProcessor;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EBAToSubsystemHandler
implements ApplicationHandler<SubsystemInformation> {
    static final TraceComponent _tc = Tr.register(EBAToSubsystemHandler.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.EBAToSubsystemHandler");
    static final String EBA_MANIFEST_FILENAME = "META-INF/APPLICATION.MF";
    static final String ESA_MANIFEST_FILENAME = "OSGI-INF/SUBSYSTEM.MF";
    static final String SUBSYSTEM_MANIFEST_VERSION_NAME = "Subsystem-ManifestVersion";
    static final String SUBSYSTEM_MANIFEST_VERSION_VALUE = "1.0";
    static final Map<String, String> EBA_TO_ESA_MANIFEST_ENTRY_NAME_MAP;
    private ApplicationHandler<SubsystemInformation> _subsystemApplicationHandler;
    static final long serialVersionUID = 8579223958138947887L;

    boolean hasSubsystemManifest(ApplicationInformation<SubsystemInformation> applicationInformation) {
        Container container = applicationInformation.getContainer();
        Entry esaManifestEntry = container.getEntry(ESA_MANIFEST_FILENAME);
        return esaManifestEntry != null;
    }

    /*
     * WARNING - void declaration
     */
    private static void convertApp(ApplicationInformation<SubsystemInformation> ebaAppInfo) {
        block11: {
            try {
                Container container = ebaAppInfo.getContainer();
                IDirectory directory = (IDirectory)container.adapt(IDirectory.class);
                Manifest ebaManifest = ManifestProcessor.obtainManifestFromAppDir((IDirectory)directory, (String)EBA_MANIFEST_FILENAME);
                Entry ebaEntry = container.getEntry(EBA_MANIFEST_FILENAME);
                if (ebaManifest != null && ebaEntry != null) {
                    Map caseSensitiveManifest = ManifestProcessor.readManifestIntoMap((Manifest)ebaManifest);
                    TreeMap ebaManifestMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    ebaManifestMap.putAll(caseSensitiveManifest);
                    AddEntryToOverlay esaManifestEntry = (AddEntryToOverlay)container.adapt(AddEntryToOverlay.class);
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry ebaManifestEntry : ebaManifestMap.entrySet()) {
                        String entryName = (String)ebaManifestEntry.getKey();
                        String entryValue = (String)ebaManifestEntry.getValue();
                        String mappedEntryName = EBA_TO_ESA_MANIFEST_ENTRY_NAME_MAP.get(entryName);
                        if (mappedEntryName != null) {
                            entryName = mappedEntryName;
                        }
                        if (SUBSYSTEM_MANIFEST_VERSION_NAME.equals(entryName)) {
                            entryValue = SUBSYSTEM_MANIFEST_VERSION_VALUE;
                        }
                        sb.append(entryName).append(": ").append(entryValue).append("\n");
                    }
                    sb.append("Subsystem-Type").append(": ").append("osgi.subsystem.application").append("; apache-aries-provision-dependencies:=install\n");
                    String esaManifestString = sb.toString();
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("esa subsystem manifest is :\n" + esaManifestString), (Object[])new Object[0]);
                    }
                    esaManifestEntry.add(ESA_MANIFEST_FILENAME, esaManifestString);
                } else if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"no eba manifest file found", (Object[])new Object[0]);
                }
            }
            catch (IOException container) {
                FFDCFilter.processException((Throwable)container, (String)"com.ibm.ws.app.manager.esa.internal.EBAToSubsystemHandler", (String)"145", null, (Object[])new Object[]{ebaAppInfo});
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    void ioe;
                    Tr.debug((TraceComponent)_tc, (String)ioe.toString(), (Object[])new Object[0]);
                }
            }
            catch (UnableToAdaptException ioe) {
                void utae;
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.app.manager.esa.internal.EBAToSubsystemHandler", (String)"153", null, (Object[])new Object[]{ebaAppInfo});
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)_tc, (String)utae.toString(), (Object[])new Object[0]);
            }
        }
    }

    public void setSubsystemApplicationHandler(ApplicationHandler<SubsystemInformation> handler) {
        this._subsystemApplicationHandler = handler;
    }

    public void unsetSubsystemApplicationHandler(ApplicationHandler<ApplicationMonitoringInformation> handler) {
    }

    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<SubsystemInformation> ebaAppInfo) {
        EBAToSubsystemHandler.convertApp(ebaAppInfo);
        return this._subsystemApplicationHandler.setUpApplicationMonitoring(ebaAppInfo);
    }

    public Future<Boolean> install(ApplicationInformation<SubsystemInformation> ebaAppInfo) {
        return this._subsystemApplicationHandler.install(ebaAppInfo);
    }

    public Future<Boolean> uninstall(ApplicationInformation<SubsystemInformation> ebaAppInfo) {
        return this._subsystemApplicationHandler.uninstall(ebaAppInfo);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        HashMap<String, String> ebaToEsaManifestEntryNameMap = new HashMap<String, String>();
        ebaToEsaManifestEntryNameMap.put("Application-ManifestVersion", SUBSYSTEM_MANIFEST_VERSION_NAME);
        ebaToEsaManifestEntryNameMap.put("Application-Name", "Subsystem-Name");
        ebaToEsaManifestEntryNameMap.put("Application-SymbolicName", "Subsystem-SymbolicName");
        ebaToEsaManifestEntryNameMap.put("Application-Version", "Subsystem-Version");
        ebaToEsaManifestEntryNameMap.put("Application-Content", "Subsystem-Content");
        ebaToEsaManifestEntryNameMap.put("Use-Bundle", "Preferred-Provider");
        EBA_TO_ESA_MANIFEST_ENTRY_NAME_MAP = Collections.unmodifiableMap(ebaToEsaManifestEntryNameMap);
    }
}

