/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBlueprintParser {
    public static final String DEFAULT_HEADER = "OSGI-INF/blueprint/*.xml";
    private static final Logger logger = LoggerFactory.getLogger(BundleBlueprintParser.class);
    String _mfHeader = null;
    List<Path> _paths;
    static final boolean _blueprintHeaderMandatory;

    public BundleBlueprintParser(BundleManifest bundleMf) {
        String bundleBPHeader = bundleMf.getRawAttributes().getValue("Bundle-Blueprint");
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser(String bundleBPHeader) {
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser() {
        this.setup(null);
    }

    public boolean mightContainBlueprint() {
        return this._mfHeader != null && this._mfHeader.trim().length() > 0;
    }

    private void setup(String bundleBPHeader) {
        this._paths = new LinkedList<Path>();
        this._mfHeader = bundleBPHeader == null ? (_blueprintHeaderMandatory ? null : DEFAULT_HEADER) : bundleBPHeader;
        logger.debug("Bundle-Blueprint header: {}", (Object)this._mfHeader);
        List files = ManifestHeaderProcessor.split((String)this._mfHeader, (String)",");
        for (String fileClause : files) {
            String f;
            List yetMoreFiles = ManifestHeaderProcessor.split((String)fileClause, (String)";");
            Iterator i$ = yetMoreFiles.iterator();
            while (i$.hasNext() && !(f = (String)i$.next()).contains("=")) {
                if ((f = f.trim()).startsWith("\"") && f.endsWith("\"")) {
                    f = f.substring(1, f.length() - 1);
                }
                int index = f.lastIndexOf(47);
                String path = "";
                String file = f;
                if (index != -1) {
                    path = f.substring(0, index);
                    file = f.substring(index + 1);
                }
                this._paths.add(new Path(path, file));
            }
        }
    }

    public boolean isBPFile(String directory, String filename) {
        logger.debug("Method entry: {}, args {}", (Object)"isBPFile", (Object)new Object[]{directory, filename});
        boolean result = false;
        for (Path path : this._paths) {
            if (!path.matches(directory, filename)) continue;
            result = true;
            break;
        }
        logger.debug("Method exit: {}, returning {}", (Object)"isBPFile", (Object)result);
        return result;
    }

    static {
        String blueprintHeaderMandatory = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.apache.aries.blueprint.header.mandatory", "false");
            }
        });
        _blueprintHeaderMandatory = blueprintHeaderMandatory.toLowerCase().equals("true");
    }

    static class Path {
        String directory;
        String filename;
        Pattern filenamePattern;

        public Path(String d, String f) {
            this.directory = d;
            if (f.contains("*")) {
                this.filename = null;
                String pattern = f.replace(".", "\\.");
                pattern = pattern.replace("*", ".*");
                this.filenamePattern = Pattern.compile(pattern);
            } else {
                this.filename = f;
                this.filenamePattern = null;
            }
        }

        public boolean matches(String dir, String fil) {
            boolean match = false;
            match = !this.directory.equals(dir) ? false : (this.filename != null ? this.filename.equals(fil) : this.filenamePattern.matcher(fil).matches());
            return match;
        }
    }
}

