/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.utils.impl.ModellingHelperImpl;
import org.apache.aries.application.utils.FilterUtils;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportedPackageImpl
implements ImportedPackage {
    private final boolean _optional;
    private final String _filterString;
    private final Filter _filter;
    private final String _package;
    private final String _versionRange;
    private final Map<String, String> _attributes;
    private final Logger logger = LoggerFactory.getLogger(ImportedPackageImpl.class);

    public ImportedPackageImpl(String pkg, Map<String, String> attributes) throws InvalidAttributeException {
        this.logger.debug("Method entry: {}, args {}", (Object)"ImportedPackageImpl", (Object)new Object[]{pkg, attributes});
        this._package = pkg;
        String versionRange = null;
        if (attributes != null) {
            this._optional = "optional".equals(attributes.get("resolution:"));
            versionRange = attributes.get("version");
            this._attributes = new HashMap<String, String>(attributes);
        } else {
            this._optional = false;
            this._attributes = new HashMap<String, String>();
        }
        this._versionRange = versionRange == null ? Version.emptyVersion.toString() : versionRange;
        this._attributes.put("version", this._versionRange);
        this._filterString = ManifestHeaderProcessor.generateFilter((String)ResourceType.PACKAGE.toString(), (String)this._package, this._attributes);
        try {
            this._filter = FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken((String)this._filterString));
        }
        catch (InvalidSyntaxException isx) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"ImportedPackageImpl", (Object)new Object[]{isx});
            throw new InvalidAttributeException((Exception)((Object)isx));
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"ImportedPackageImpl");
    }

    public Map<String, String> getAttributes() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributes");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributes", (Object)new Object[]{this._attributes});
        return Collections.unmodifiableMap(this._attributes);
    }

    public String getPackageName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getPackageName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getPackageName", (Object)new Object[]{this._package});
        return this._package;
    }

    public String getVersionRange() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersionRange");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersionRange", (Object)new Object[]{this._versionRange});
        return this._versionRange;
    }

    public String getAttributeFilter() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributeFilter");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributeFilter", (Object)new Object[]{this._filterString});
        return this._filterString;
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)new Object[]{ResourceType.PACKAGE});
        return ResourceType.PACKAGE;
    }

    public boolean isMultiple() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isMultiple");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isMultiple", (Object)new Object[]{false});
        return false;
    }

    public boolean isOptional() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isOptional");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isOptional", (Object)new Object[]{this._optional});
        return this._optional;
    }

    public boolean isSatisfied(Provider capability) {
        boolean allPresent;
        this.logger.debug("Method entry: {}, args {}", (Object)"isSatisfied", (Object)new Object[]{capability});
        if (capability.getType() != ResourceType.PACKAGE) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)new Object[]{false});
            return false;
        }
        Hashtable<String, Version> dict = new Hashtable<String, Version>(capability.getAttributes());
        String version = (String)((Dictionary)dict).get("version");
        if (version != null) {
            ((Dictionary)dict).put("version", Version.parseVersion((String)version));
        }
        boolean result = (allPresent = ModellingHelperImpl.areMandatoryAttributesPresent_(this._attributes, capability)) && this._filter.match(dict);
        this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)new Object[]{result});
        return result;
    }

    public String toDeploymentString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toDeploymentString");
        StringBuilder sb = new StringBuilder(this._package);
        for (Map.Entry<String, String> entry : this._attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!(key.equals("bundle-symbolic-name") || key.equals("bundle-version") || key.equals(ResourceType.PACKAGE.toString()) || key.equals("specification-version"))) {
                sb.append(";").append(key).append("=\"").append(value).append('\"');
                continue;
            }
            this.logger.debug("ignoring attribute {" + key + "=" + value + "} in ImportedPackageImpl.toDeploymentString()");
        }
        String result = sb.toString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toDeploymentString", (Object)new Object[]{result});
        return result;
    }

    public String toString() {
        return this.toDeploymentString();
    }

    public boolean equals(Object thing) {
        if (thing == this) {
            return true;
        }
        if (thing instanceof ImportedPackage) {
            ImportedPackage otherPackage = (ImportedPackage)thing;
            if (!this.getPackageName().equals(otherPackage.getPackageName())) {
                return false;
            }
            if (!this.getVersionRange().equals(otherPackage.getVersionRange())) {
                return false;
            }
            if (!this.getPackageName().equals(otherPackage.getPackageName())) {
                return false;
            }
            Map otherAttributes = otherPackage.getAttributes();
            if (!this.attributesAreEqual(otherAttributes)) {
                return false;
            }
        }
        return true;
    }

    private boolean attributesAreEqual(Map<String, String> otherAttributes) {
        if (this.getAttributes().size() != otherAttributes.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            String key = entry.getKey();
            if (otherAttributes != null && otherAttributes.containsKey(key)) {
                String otherValue = otherAttributes.get(key);
                String value = entry.getValue();
                if (!(value == null ? otherValue != null : !value.equals(otherValue))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getPackageName().hashCode();
    }
}

