/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.WrappedServiceMetadata;
import org.apache.aries.application.utils.service.ExportedServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportedServiceImpl
implements ExportedService {
    private final Logger logger = LoggerFactory.getLogger(ExportedServiceImpl.class);
    private final Map<String, Object> _attributes;
    private final Collection<String> _interfaces;
    private final Map<String, Object> _serviceProperties;
    private final String _name;
    private final int _ranking;
    private String _toString = null;

    public ExportedServiceImpl(String name, int ranking, Collection<String> ifaces, Map<String, Object> serviceProperties) {
        this.logger.debug("Method entry: {}, args {}", (Object)"ExportedServiceImpl", (Object)new Object[]{name, ranking, ifaces});
        this._interfaces = new TreeSet<String>(ifaces);
        this._name = !"".equals(name) ? name : null;
        this._ranking = ranking;
        this._serviceProperties = serviceProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(serviceProperties);
        this._attributes = new HashMap<String, Object>(this._serviceProperties);
        StringBuilder sb = new StringBuilder();
        for (String i : this._interfaces) {
            sb.append(i + ",");
        }
        sb = sb.deleteCharAt(sb.length() - 1);
        this._attributes.put("objectClass", sb.toString());
        this._attributes.put("service.ranking", String.valueOf(this._ranking));
        this._attributes.put("service", "service");
        this.logger.debug("Method exit: {}, returning {}", (Object)"ExportedServiceImpl");
    }

    @Deprecated
    public ExportedServiceImpl(String ifaceName, Map<String, String> attrs) {
        this.logger.debug("Method entry: {}, args {}", (Object)"ExportedServiceImpl", (Object)new Object[]{ifaceName, attrs});
        this._interfaces = new TreeSet<String>(Arrays.asList(ifaceName));
        this._ranking = 0;
        this._attributes = new HashMap<String, String>(attrs);
        this._attributes.put("objectClass", ifaceName);
        this._attributes.put("service.ranking", String.valueOf(this._ranking));
        this._attributes.put("service", "service");
        this._serviceProperties = new HashMap<String, Object>();
        this._name = null;
        this.logger.debug("Method exit: {}, returning {}", (Object)"ExportedServiceImpl");
    }

    public Map<String, Object> getAttributes() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributes");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributes", this._attributes);
        return Collections.unmodifiableMap(this._attributes);
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)ResourceType.SERVICE);
        return ResourceType.SERVICE;
    }

    public Collection<String> getInterfaces() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getInterfaces");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getInterfaces", this._interfaces);
        return Collections.unmodifiableCollection(this._interfaces);
    }

    public String getName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getName", (Object)this._name);
        return this._name;
    }

    public int getRanking() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRanking");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRanking", (Object)this._ranking);
        return this._ranking;
    }

    public Map<String, Object> getServiceProperties() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getServiceProperties");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getServiceProperties", this._serviceProperties);
        return Collections.unmodifiableMap(this._serviceProperties);
    }

    public int compareTo(WrappedServiceMetadata o) {
        this.logger.debug("Method entry: {}, args {}", (Object)"compareTo", (Object)o);
        int result = ExportedServiceHelper.portableExportedServiceCompareTo((ExportedService)this, (WrappedServiceMetadata)o);
        this.logger.debug("Method exit: {}, returning {}", (Object)"compareTo", (Object)result);
        return result;
    }

    public boolean equals(Object o) {
        this.logger.debug("Method entry: {}, args {}", (Object)"equals", o);
        boolean eq = ExportedServiceHelper.portableExportedServiceEquals((ExportedService)this, (Object)o);
        this.logger.debug("Method exit: {}, returning {}", (Object)"equals", (Object)eq);
        return eq;
    }

    public int hashCode() {
        this.logger.debug("Method entry: {}, args {}", (Object)"hashCode");
        int result = ExportedServiceHelper.portableExportedServiceHashCode((ExportedService)this);
        this.logger.debug("Method exit: {}, returning {}", (Object)"hashCode", (Object)result);
        return result;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = ExportedServiceHelper.generatePortableExportedServiceToString((ExportedService)this);
        }
        return this._toString;
    }

    public boolean identicalOrDiffersOnlyByName(WrappedServiceMetadata wsmi) {
        this.logger.debug("Method entry: {}, args {}", (Object)"identicalOrDiffersOnlyByName", (Object)wsmi);
        boolean result = ExportedServiceHelper.portableExportedServiceIdenticalOrDiffersOnlyByName((ExportedService)this, (WrappedServiceMetadata)wsmi);
        this.logger.debug("Method exit: {}, returning {}", (Object)"identicalOrDiffersOnlyByName", (Object)result);
        return result;
    }
}

