/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ExportedBundle;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.utils.ModellingHelper;
import org.apache.aries.application.resolver.internal.MessageUtil;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelledBundleResource
implements ModelledResource {
    private final Resource resource;
    private final ExportedBundle exportedBundle;
    private final Collection<ImportedPackage> packageRequirements;
    private final Collection<ImportedService> serviceRequirements;
    private final Collection<ExportedPackage> packageCapabilities;
    private final Collection<ExportedService> serviceCapabilties;
    private final Collection<ImportedBundle> bundleRequirements;
    private final ResourceType type;
    private final ModellingManager modellingManager;
    private final ModellingHelper modellingHelper;
    private final Logger logger = LoggerFactory.getLogger(ModelledBundleResource.class);

    public ModelledBundleResource(Resource r, ModellingManager mm, ModellingHelper mh) throws InvalidAttributeException {
        String name;
        this.logger.debug("Method entry: {}, args {}", (Object)"ModelledBundleResource", (Object)new Object[]{r, mm, mh});
        this.resource = r;
        this.modellingManager = mm;
        this.modellingHelper = mh;
        ArrayList<ExportedBundle> exportedBundles = new ArrayList<ExportedBundle>();
        ResourceType thisResourceType = ResourceType.BUNDLE;
        for (Capability capability : r.getCapabilities()) {
            String capName = capability.getName();
            if (capName.equals(ResourceType.BUNDLE.toString())) {
                Property[] props = capability.getProperties();
                HashMap<String, String> sanitizedMap = new HashMap<String, String>();
                for (Property entry : props) {
                    sanitizedMap.put(entry.getName(), entry.getValue());
                }
                exportedBundles.add(this.modellingManager.getExportedBundle(sanitizedMap, this.modellingHelper.buildFragmentHost((String)sanitizedMap.get("Fragment-Host"))));
                continue;
            }
            if (!capability.getName().equals(ResourceType.COMPOSITE.toString())) continue;
            thisResourceType = ResourceType.COMPOSITE;
        }
        this.type = thisResourceType;
        if (exportedBundles.size() == 0) {
            throw new InvalidAttributeException(MessageUtil.getMessage("NO_EXPORTED_BUNDLE", new Object[0]));
        }
        if (exportedBundles.size() != 1) {
            throw new InvalidAttributeException(MessageUtil.getMessage("TOO_MANY_EXPORTED_BUNDLES", new Object[0]));
        }
        this.exportedBundle = (ExportedBundle)exportedBundles.get(0);
        this.packageCapabilities = new HashSet<ExportedPackage>();
        this.packageRequirements = new HashSet<ImportedPackage>();
        this.serviceCapabilties = new HashSet<ExportedService>();
        this.serviceRequirements = new HashSet<ImportedService>();
        this.bundleRequirements = new HashSet<ImportedBundle>();
        for (Capability capability : r.getRequirements()) {
            String reqName = capability.getName();
            if (ResourceType.PACKAGE.toString().equals(reqName)) {
                Map filter = ManifestHeaderProcessor.parseFilter((String)capability.getFilter());
                name = (String)filter.remove(ResourceType.PACKAGE.toString());
                if (capability.isOptional()) {
                    filter.put("resolution:", "optional");
                }
                ImportedPackage info = this.modellingManager.getImportedPackage(name, filter);
                this.packageRequirements.add(info);
                continue;
            }
            if (ResourceType.SERVICE.toString().equals(capability.getName())) {
                boolean optional = capability.isOptional();
                String id = null;
                boolean isMultiple = capability.isMultiple();
                Map attrs = ManifestHeaderProcessor.parseFilter((String)capability.getFilter());
                String iface = (String)attrs.get("objectClass");
                String componentName = (String)attrs.get("osgi.service.blueprint.compname");
                String blueprintFilter = capability.getFilter();
                ImportedService svc = this.modellingManager.getImportedService(optional, iface, componentName, blueprintFilter, id, isMultiple);
                this.serviceRequirements.add(svc);
                continue;
            }
            if (!ResourceType.BUNDLE.toString().equals(capability.getName())) continue;
            String filter = capability.getFilter();
            Map atts = ManifestHeaderProcessor.parseFilter((String)filter);
            if (capability.isOptional()) {
                atts.put("resolution:", "optional");
            }
            this.bundleRequirements.add(this.modellingManager.getImportedBundle(filter, atts));
        }
        for (Capability capability : r.getCapabilities()) {
            Object rawObjectClass;
            Property[] properties;
            HashMap<String, String> props = new HashMap<String, String>();
            for (Property prop : properties = capability.getProperties()) {
                props.put(prop.getName(), prop.getValue());
            }
            if (ResourceType.PACKAGE.toString().equals(capability.getName())) {
                Object pkg = props.remove(ResourceType.PACKAGE.toString());
                ExportedPackage info = this.modellingManager.getExportedPackage((ModelledResource)this, pkg.toString(), props);
                this.packageCapabilities.add(info);
                continue;
            }
            if (!ResourceType.SERVICE.toString().equals(capability.getName())) continue;
            name = null;
            int ranking = 0;
            String rankingText = (String)props.remove("service.ranking");
            if (rankingText != null) {
                ranking = Integer.parseInt(rankingText);
            }
            List<String> ifaces = (rawObjectClass = props.remove("objectClass")) == null ? Arrays.asList((String)props.get("service")) : (rawObjectClass.getClass().isArray() ? Arrays.asList((String[])rawObjectClass) : Arrays.asList((String)rawObjectClass));
            ExportedService svc = this.modellingManager.getExportedService(name, ranking, ifaces, props);
            this.serviceCapabilties.add(svc);
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"ModelledBundleResource");
    }

    public ExportedBundle getExportedBundle() {
        this.logger.debug("Method entry: {}, args {}", (Object)"AbstractExportedBundle");
        this.logger.debug("Method exit: {}, returning {}", (Object)"AbstractExportedBundle", (Object)this.exportedBundle);
        return this.exportedBundle;
    }

    public Collection<? extends ExportedPackage> getExportedPackages() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExportedPackages");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExportedPackages", this.packageCapabilities);
        return Collections.unmodifiableCollection(this.packageCapabilities);
    }

    public Collection<? extends ExportedService> getExportedServices() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExportedServices");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExportedServices", this.serviceCapabilties);
        return Collections.unmodifiableCollection(this.serviceCapabilties);
    }

    public Collection<? extends ImportedPackage> getImportedPackages() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getImportedPackages");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getImportedPackages", this.packageRequirements);
        return Collections.unmodifiableCollection(this.packageRequirements);
    }

    public Collection<? extends ImportedService> getImportedServices() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getImportedServices");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getImportedServices", this.serviceRequirements);
        return Collections.unmodifiableCollection(this.serviceRequirements);
    }

    public Collection<? extends ImportedBundle> getRequiredBundles() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRequiredBundles");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRequiredBundles", this.bundleRequirements);
        return Collections.unmodifiableCollection(this.bundleRequirements);
    }

    public String getSymbolicName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getSymbolicName");
        String result = this.resource.getSymbolicName();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getSymbolicName", (Object)result);
        return result;
    }

    public String getLocation() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getLocation");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getLocation", (Object)this.resource.getURI());
        return this.resource.getURI();
    }

    public String getVersion() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersion");
        String result = this.resource.getVersion().toString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersion", (Object)result);
        return result;
    }

    public String toDeploymentString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toDeploymentString");
        String result = this.getSymbolicName() + ";" + "deployed-version" + "=" + this.getVersion();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toDeploymentString", (Object)result);
        return result;
    }

    public String toString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toString");
        String result = this.toDeploymentString() + " uri=" + this.getLocation();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toString", (Object)result);
        return result;
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)this.type);
        return this.type;
    }

    public ImportedBundle getFragmentHost() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getFragmentHost");
        ImportedBundle result = this.exportedBundle.getFragmentHost();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getFragmentHost", (Object)result);
        return result;
    }

    public boolean isFragment() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isFragment");
        boolean result = this.exportedBundle.isFragment();
        this.logger.debug("Method exit: {}, returning {}", (Object)"isFragment", (Object)result);
        return result;
    }
}

