/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.member.metadata.AdminMetadataParser;
import com.ibm.ws.collective.utility.IAdminMetadataManagerMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRepositoryMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.EncodingProperty;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class JoinTask
extends BaseCommandTask {
    private static final String className = JoinTask.class.getName();
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private File collectiveResourcesDir;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private final IAdminMetadataManagerMBeanConnection metadataManagerMBean;
    private final ICollectiveRepositoryMBeanConnection repositoryMBean;
    private static final List<String> BETA_ARG_TABLE = Arrays.asList("--base64Key", "--aesConfigFile");
    private static final List<String> BETA_OPTS = BETA_ARG_TABLE.stream().map(s -> s.startsWith("--") ? s.substring(2) : s).collect(Collectors.toList());

    public JoinTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean, IAdminMetadataManagerMBeanConnection metadataManagerMBean, ICollectiveRepositoryMBeanConnection repositoryMBean) {
        super(scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.metadataManagerMBean = metadataManagerMBean;
        this.repositoryMBean = repositoryMBean;
        this.reqArgs.add("--keystorePassword");
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.flagArgs.add("--createConfigFile");
        this.flagArgs.add("--useHostCredentials");
        this.flagArgs.add("--genDeployVariables");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        if (ProductInfo.getBetaEdition()) {
            this.knownArgs.add("--base64Key");
            this.knownArgs.add("--aesConfigFile");
        }
        this.knownArgs.add("--hostJavaHome");
        this.addHostAuthInfoArgs(false);
        this.addAutoAcceptAndDisableHostnameVerificationArguments();
        this.noValueRequiredArgs.add("--setupSAF");
        this.knownArgs.addAll(this.noValueRequiredArgs);
        this.knownArgs.add("--certificateRdn");
        this.knownArgs.add("--serverIdentityKeystore");
        this.knownArgs.add("--serverIdentityKeystoreAlias");
        this.knownArgs.add("--collectiveTrustKeystore");
        this.knownArgs.add("--safKeystoreType");
        this.knownArgs.add("--safKeystoreProvider");
    }

    @Override
    public String getTaskName() {
        return "join";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("join.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("keystore.option-key.", "keystore.option-desc.") + this.buildScriptOptions("certProps.option-key.", "certProps.option-desc.") + this.buildScriptOptions("join.option-key.", "join.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.");
        return this.getTaskHelp("join.desc", "join.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("join.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            Trlog.debug(className, "abortAndPerform", "cleaning up generated files. Unable to delete " + collectiveResourcesDir);
            this.stdout.println(this.getMessage("join.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    private void abortAndPerformCleanup(String message, File collectiveResourcesDir, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            Trlog.debug(className, "abortAndPerform", "cleaning up generated files. Unable to delete " + collectiveResourcesDir);
            this.stdout.println(this.getMessage("join.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> join(String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String serverName, String installDir, String keystorePassword, Map<String, Object> certProps, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        String methodName;
        block19: {
            methodName = "join";
            Trlog.enter(className, methodName, new Object[]{controllerHost, controllerPort, user, password.replaceAll(".", "*"), hostName, userDir, serverName, installDir, keystorePassword.replaceAll(".", "*")});
            try {
                Map<String, byte[]> ret = this.registrationMBean.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
                this.stdout.println(this.getMessage("join.mbeanComplete", new Object[0]));
                Trlog.exit(className, methodName, "Successfully completed MBean request to the controller");
                return ret;
            }
            catch (RuntimeMBeanException e) {
                Trlog.debug(className, methodName, "Caught RuntimeMBeanException: ", e);
                if (e.getCause() instanceof IllegalStateException) {
                    this.abortAndPerformCleanup(this.getMessage("join.registeredAlready", serverName), this.collectiveResourcesDir, methodName);
                }
                if (e.getCause() instanceof IllegalArgumentException) {
                    try {
                        if (certProps != null && certProps.containsKey("18004member")) {
                            certProps.remove("18004member");
                        }
                        Map<String, byte[]> ret = this.registrationMBean.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
                        this.stdout.println(this.getMessage("join.mbeanComplete", new Object[0]));
                        Trlog.exit(className, methodName, "Successfully completed MBean request to the controller");
                        return ret;
                    }
                    catch (RuntimeMBeanException e1) {
                        Trlog.debug(className, methodName, "Caught RuntimeMBeanException: ", e);
                        if (e.getCause() instanceof IllegalStateException) {
                            this.abortAndPerformCleanup(this.getMessage("join.registeredAlready", serverName), this.collectiveResourcesDir, methodName);
                        } else if (e.getCause() instanceof IllegalArgumentException) {
                            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
                        } else {
                            this.stderr.println(this.getMessage("error", e.getMessage()));
                            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
                        }
                        break block19;
                    }
                    catch (UnknownHostException e1) {
                        this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir, methodName);
                        break block19;
                    }
                    catch (ConnectException e1) {
                        this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir, methodName);
                        break block19;
                    }
                    catch (IOException e1) {
                        this.stdout.println("IOException while invoking the MBean: " + e1);
                        this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e1.getMessage()), this.collectiveResourcesDir, methodName);
                        break block19;
                    }
                    catch (Exception e1) {
                        this.stdout.println("Unexpected Exception while invoking the MBean: " + e1);
                        this.stderr.println(this.getMessage("error", e1.getMessage()));
                        this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e1.getMessage()), this.collectiveResourcesDir, methodName);
                        break block19;
                    }
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            }
            catch (UnknownHostException e) {
                this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir, methodName);
            }
            catch (ConnectException e) {
                this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir, methodName);
            }
            catch (IOException e) {
                this.stdout.println("IOException while invoking the MBean: " + e);
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            }
            catch (Exception e) {
                this.stdout.println("Unexpected Exception while invoking the MBean: " + e);
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            }
        }
        Trlog.exit(className, methodName, "return null");
        return null;
    }

    private void deployAdminMetadata(String controllerHost, int controllerPort, String user, String password, String resourceType, String identity, Map<String, Object> metadata) throws TaskErrorException {
        String methodName = "deployAdminMetadata";
        Trlog.enter(className, methodName, new Object[]{controllerHost, controllerPort, user, password.replaceAll(".", "*"), resourceType, identity});
        try {
            this.metadataManagerMBean.deployAdminMetadata(controllerHost, controllerPort, user, password, resourceType, identity, metadata);
            Trlog.debug(className, methodName, "Successfully completed AdminMetadataManagerMBean request to the controller");
            this.stdout.println(this.getMessage("deployAdminMetadata.mbeanComplete", new Object[0]));
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            }
        }
        catch (UnknownHostException e) {
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir, methodName);
        }
        catch (ConnectException e) {
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir, methodName);
        }
        catch (IOException e) {
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
        }
        catch (Exception e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
        }
        Trlog.exit(className, methodName);
    }

    private Map<String, Integer> allocateDeployVariables(String controllerHost, int controllerPort, String user, String password, String hostName, String[] names) throws TaskErrorException {
        String methodName = "allocateDeployVariables";
        Trlog.enter(className, methodName, new Object[]{controllerHost, controllerPort, user, password.replaceAll(".", "*"), hostName, names});
        try {
            Map<String, Integer> deployVars = this.repositoryMBean.allocateDeployVariables(controllerHost, controllerPort, user, password, hostName, names);
            Trlog.exit(className, methodName, "Successfully completed CollectiveRepositoryMBean request to the controller for allocating deploy variables.");
            this.stdout.println(this.getMessage("allocateDeployVariables.mbeanComplete", new Object[0]));
            return deployVars;
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
            }
        }
        catch (UnknownHostException e) {
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir, methodName);
        }
        catch (ConnectException e) {
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir, methodName);
        }
        catch (IOException e) {
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                this.abortAndPerformCleanup(this.getMessage("common.compatibilityError", e.getMessage()), this.collectiveResourcesDir, methodName);
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, methodName);
        }
        Trlog.exit(className, methodName);
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        File runtimeMetadataFile;
        Map metadata;
        Map adminMetadata;
        File serverMetadataFile;
        AdminMetadataParser parser;
        Boolean genDeployVariables;
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        boolean upLevelMember = true;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        String predType = "FILE";
        predType = this.customArgsFound(args);
        String configXML = "";
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String installDir = this.fileUtility.getInstallDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir), methodName);
        }
        this.collectiveResourcesDir = new File(serverDir + "resources/collective");
        if (this.fileUtility.exists(this.collectiveResourcesDir) && !this.fileUtility.isDirectoryEmpty(this.collectiveResourcesDir)) {
            this.abort(this.getMessage("join.errorAlreadyHasResources", new Object[0]), methodName);
        }
        serverName = this.fileUtility.fixServerNameCase(serverName);
        Trlog.debug(installDir, methodName, "Some key join arguments: ", new Object[]{"serverName = " + serverName, "userDir = " + userDir, "installDir = " + installDir, "serverDir = " + serverDir});
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
        this.handleAutoAcceptAndDisableHostnameVerificationArgs(args);
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        Integer serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
        Integer httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        if (serverIdentityCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--serverIdentityCertificateValidity"), methodName);
        }
        if (httpsCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--httpsCertificateValidity"), methodName);
        }
        try {
            new LdapName(httpsCertificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject), methodName);
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String aesConfigFile = this.getArgumentValue("--aesConfigFile", args, null);
        String key = this.getArgumentValue("--key", args, null);
        String base64Key = this.getArgumentValue("--base64Key", args, null);
        EncodingProperty prop = this.validateEncoding(encoding, key, aesConfigFile, base64Key);
        Map<Object, Object> hostAuthInfo = null;
        List<String> list = Arrays.asList(args);
        Boolean useHostCredentials = list.contains("--useHostCredentials");
        Boolean useCollectiveSSHKey = list.contains("--useCollectiveSSHKey");
        this.validateUseHostCredentialsOverrides(list, useHostCredentials);
        this.validateUseSSHKeyOverrides(list, useCollectiveSSHKey);
        if (useHostCredentials.booleanValue()) {
            hostAuthInfo = new HashMap<String, Object>();
            hostAuthInfo.put("useHostCredentials", Boolean.TRUE);
        } else {
            hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, this.registrationMBean, this.collectiveResourcesDir, controllerHost, controllerPort, user, password, hostName, true, true, serverName, serverDir);
        }
        String java_home = System.getProperty("java.home");
        java_home = this.getArgumentValue("--hostJavaHome", args, java_home);
        hostAuthInfo.put("hostJavaHome", java_home);
        Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
        if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
            hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerHost");
            userDir = "Docker";
            serverName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerName");
            Trlog.debug(className, methodName, "setup the docker member identity:", new Object[]{hostName, userDir, serverName});
            hostAuthInfo.put("collectiveMemberType", "Liberty");
            hostAuthInfo.put("sys.container.type", "Docker");
        }
        boolean contollerUsingCustom = this.isContollerUsingCustomKeystore(controllerHost, controllerPort, user, password, this.registrationMBean, this.collectiveResourcesDir);
        if (predType.equals("SAF") || predType.equals("CUSTOMFILE")) {
            if (!contollerUsingCustom) {
                this.abortAndPerformCleanup(this.getMessage("custom.MemberCustomControllerDefault", new Object[0]), this.collectiveResourcesDir, methodName);
            }
            configXML = this.processBYO_SSLOptions(args, serverName, controllerHost, controllerPort, user, password, hostName, userDir, installDir, hostAuthInfo, prop, predType, keystorePassword, serverIdentityKeystorePassword, collectiveTrustKSPassword, contollerUsingCustom);
        } else {
            String encodedKeystorePassword;
            if (contollerUsingCustom) {
                this.abortAndPerformCleanup(this.getMessage("custom.ControllerCustomMemberDefault", new Object[0]), this.collectiveResourcesDir, methodName);
            }
            if ((encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", prop)) == null) {
                this.abort("Encoded kyestore password is null", methodName);
            }
            String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", prop);
            String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--collectiveTrustKeystorePassword", prop);
            String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", prop);
            String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", prop);
            if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
                this.abort(null, methodName);
            }
            HashMap<String, Object> certProps = new HashMap<String, Object>();
            certProps.put("serverIdentityKeystorePassword", encodedServerIdentityKeystorePassword);
            certProps.put("serverIdentityCertificateValidity", serverIdentityCertificateValidity);
            certProps.put("collectiveTrustKeystorePassword", encodedCollectiveTrustKSPassword);
            certProps.put("httpsKeystorePassword", encodedHTTPSKSPassword);
            certProps.put("httpsCertificateSubject", httpsCertificateSubject);
            certProps.put("httpsCertificateValidity", httpsCertificateValidity);
            certProps.put("httpsTruststorePassword", encodedHTTPSTSPassword);
            certProps.put("18004member", "true");
            File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.p12");
            File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.p12");
            File httpsKSFile = new File(serverDir + "resources/security/key.p12");
            File tmpHttpsKSFile = new File(serverDir + "resources/security/key.p12" + ".tmp");
            if (httpsKSFile.exists()) {
                Trlog.debug(className, methodName, "Default HTTPS keystore file exists at " + httpsKSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
            } else {
                Trlog.debug(className, methodName, "Default HTTPS keystore file does not exists.");
            }
            File httpsTSFile = new File(serverDir + "resources/security/trust.p12");
            File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.p12" + ".tmp");
            if (httpsTSFile.exists()) {
                Trlog.debug(className, methodName, "Default HTTPS truststore file exists at " + httpsTSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
            } else {
                Trlog.debug(className, methodName, "Default HTTPS truststore file does not exists.");
            }
            if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            Trlog.debug(className, methodName, "Join starts ...");
            stdout.println(this.getMessage("join.start", controllerHost, String.valueOf(controllerPort)));
            Map<String, byte[]> joinResult = this.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
            Trlog.debug(className, methodName, "Join mbean call completed.");
            if (joinResult.get("18004controller") != null) {
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("serverIdentity.p12"), serverIdentityKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.p12"), collectiveTrustKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.p12"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.p12"), tmpHttpsTSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
            } else {
                upLevelMember = false;
                serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.jks");
                collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.jks");
                httpsKSFile = new File(serverDir + "resources/security/key.jks");
                tmpHttpsKSFile = new File(serverDir + "resources/security/key.jks" + ".tmp");
                httpsTSFile = new File(serverDir + "resources/security/trust.jks");
                tmpHttpsTSFile = new File(serverDir + "resources/security/trust.jks" + ".tmp");
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("serverIdentity.jks"), serverIdentityKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.jks"), collectiveTrustKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.jks"), tmpHttpsTSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath(), methodName), this.collectiveResourcesDir);
                }
            }
            Trlog.debug(className, methodName, "Completed writing out returned keystores");
            this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, this.collectiveResourcesDir);
            configXML = this.getConfigXML(args, controllerHost, controllerPort, hostName, prop, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword, upLevelMember);
        }
        if (hostAuthInfo.containsKey("useCollectiveSSHKey") && Boolean.valueOf(hostAuthInfo.get("useCollectiveSSHKey").toString()).booleanValue()) {
            this.updateAuthorizedKeysFiles(this.sshKeyUtil);
        }
        if ((genDeployVariables = Boolean.valueOf(list.contains("--genDeployVariables"))).booleanValue()) {
            Trlog.debug(className, methodName, "Generating deploy variables.");
            parser = new AdminMetadataParser();
            serverMetadataFile = new File(serverDir + "admin-metadata.xml");
            String[] names = parser.parseDeployVariableAdminMetadata(serverMetadataFile);
            Trlog.debug(className, methodName, "Allocating deployment variables in the collective repository...");
            stdout.println(this.getMessage("allocateDeployVariables.start", new Object[0]));
            Map<String, Integer> deployVars = this.allocateDeployVariables(controllerHost, controllerPort, user, password, hostName, names);
            String parentDir = serverDir + "configDropins/overrides";
            if (deployVars != null && deployVars.size() > 0) {
                HashSet<String> unresolvedDeployVars = this.createDeployVariableXMLFile(parentDir, deployVars, "deployVariables.xml");
                if (unresolvedDeployVars.isEmpty()) {
                    Trlog.debug(className, methodName, "Deployment variables were allocated and deployVariables.xml was created in the server /configDropins/overrides directory.");
                    stdout.println(this.getMessage("deployVarsAreAllocated", new Object[0]));
                } else {
                    Trlog.debug(className, methodName, "The undefined deployment variable: ", unresolvedDeployVars);
                    stdout.println(this.getMessage("deployVarsNotFound", unresolvedDeployVars));
                }
            } else {
                Trlog.debug(className, methodName, "No deployment variable is found.");
                stdout.println(this.getMessage("deployVarsNotFound", deployVars));
            }
        }
        if ((adminMetadata = (parser = new AdminMetadataParser()).parseAdminMetadata(serverMetadataFile = new File(serverDir + "admin-metadata.xml"), "server")) != null && adminMetadata.containsKey("server")) {
            Map serverMetadata = (Map)adminMetadata.get("server");
            boolean userDirExists = this.fileUtility.exists(userDir);
            if (userDirExists) {
                String serverIdentity = RepositoryPathUtility.buildServerTuple((String)hostName, (String)userDir, (String)serverName);
                serverIdentity = RepositoryPathUtility.encodeServerTuple((String)serverIdentity);
                Trlog.debug(className, methodName, "Deploying server metadata to the collective respository...");
                stdout.println(this.getMessage("deployAdminMetadata.start", new Object[0]));
                this.deployAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity, serverMetadata);
            } else {
                Trlog.debug(className, methodName, "Specified userDir " + userDir + " was not found ");
                stdout.println(this.getMessage("userDirNotFound", userDir));
            }
        }
        if ((metadata = parser.parseAdminMetadata(runtimeMetadataFile = new File(installDir + "etc/admin-metadata.xml"), "runtime")) != null && metadata.containsKey("runtime")) {
            Map runtimeMetadata = (Map)adminMetadata.get("runtime");
            boolean installDirExists = this.fileUtility.exists(installDir);
            if (installDirExists) {
                String runtimeIdentity = hostName + "," + installDir;
                Trlog.debug(className, methodName, "Deploying runtime metadata to the collective respository...");
                stdout.println(this.getMessage("deployAdminMetadata.start", new Object[0]));
                this.deployAdminMetadata(controllerHost, controllerPort, user, password, "runtime", runtimeIdentity, runtimeMetadata);
            } else {
                Trlog.debug(className, methodName, "Specified userDir " + installDir + " was not found ");
                stdout.println(this.getMessage("installDirNotFound", installDir));
            }
        }
        Trlog.debug(className, methodName, "Successfully joined the collective for server " + serverName);
        stdout.println();
        stdout.println(this.getMessage("join.successful", serverName));
        this.handleConfigXML(stdout, args, serverDir, configXML);
        Trlog.exit(className, methodName);
    }

    private String getConfigXML(String[] args, String controllerHost, int controllerPort, String hostName, EncodingProperty prop, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword, boolean upLevelMember) {
        String xmlSnippet = null;
        xmlSnippet = upLevelMember ? "    <featureManager>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Connection to the collective controller -->" + NL + "    <collectiveMember controllerHost=\"" + controllerHost + "\"" + NL + "                      controllerPort=\"" + controllerPort + "\" />" + NL + NL + this.insertEncodingKey(prop) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.p12" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.p12" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.p12" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.p12" + "\" />" + NL : "    <featureManager>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Connection to the collective controller -->" + NL + "    <collectiveMember controllerHost=\"" + controllerHost + "\"" + NL + "                      controllerPort=\"" + controllerPort + "\" />" + NL + NL + this.insertEncodingKey(prop) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.jks" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.jks" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.jks" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.jks" + "\" />" + NL;
        return xmlSnippet;
    }

    private HashSet<String> createDeployVariableXMLFile(String parentDir, Map<String, Integer> deployVars, String deployVariablesFileName) {
        String methodName = "createDeployVariableXMLFile";
        Trlog.enter(className, methodName, deployVariablesFileName);
        File deployVariableFile = new File(parentDir, deployVariablesFileName);
        this.fileUtility.createParentDirectory(this.stdout, deployVariableFile);
        StringBuffer xmlBuffer = new StringBuffer();
        HashSet<String> unResolvedDeployVars = new HashSet<String>();
        Trlog.debug(className, methodName, "AllocatedDeployVars");
        this.stdout.println(this.getMessage("AllocatedDeployVars", new Object[0]));
        for (String deployVarName : deployVars.keySet()) {
            Integer value = deployVars.get(deployVarName);
            if (value != null) {
                String xmlStanzas = "    <variable name=\"" + deployVarName + "\" value=\"" + value + "\" />" + NL;
                xmlBuffer.append(xmlStanzas);
                Trlog.debug(className, methodName, "[" + deployVarName + " = " + value + "]");
                this.stdout.println("[" + deployVarName + " = " + value + "]");
                continue;
            }
            unResolvedDeployVars.add(deployVarName);
        }
        String xmlTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + NL + "<server description=\"This file was generated by the join command.\">" + NL + NL + "{1}" + NL + "</server>" + NL;
        String xmlData = MessageFormat.format(xmlTemplate, Calendar.getInstance().getTime(), xmlBuffer.toString());
        this.fileUtility.writeToFile(this.stderr, xmlData, deployVariableFile);
        Trlog.exit(className, methodName, unResolvedDeployVars);
        return unResolvedDeployVars;
    }

    private String getCustomConfigXML(String[] args, String controllerHost, int controllerPort, String hostName, EncodingProperty prop, String safCertificateRdn, String serverIdentityKS, String serverIdentityAlias, String encodedServerIdentityKeystorePassword, String collectiveTrustKS, String encodedCollectiveTrustKSPassword) {
        StringBuffer SSLkeyStoreInfoXML = new StringBuffer();
        SSLkeyStoreInfoXML.append("    <featureManager>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Connection to the collective controller -->" + NL + "    <collectiveMember controllerHost=\"" + controllerHost + "\"" + NL + "                      controllerPort=\"" + controllerPort + "\" />" + NL + NL + this.insertEncodingKey(prop) + NL + NL + this.insertCustomSSLConfigs(args, safCertificateRdn, serverIdentityKS, serverIdentityAlias, encodedServerIdentityKeystorePassword, collectiveTrustKS, encodedCollectiveTrustKSPassword));
        return SSLkeyStoreInfoXML.toString();
    }

    protected String processBYO_SSLOptions(String[] args, String serverName, String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String installDir, Map<String, Object> hostAuthInfo, EncodingProperty prop, String predType, String keystorePassword, String serverIdentityKeystorePassword, String collectiveTrustKSPassword, boolean contollerUsingCustom) throws TaskErrorException {
        String safCertificateRdn;
        String methodName = "processBYO_SSLOptions";
        List<String> list = Arrays.asList(args);
        Boolean setupSAF = list.contains("--setupSAF");
        String serverIdentitycustomKS = this.getArgumentValue("--serverIdentityKeystore", args, null);
        String serverIdentityAlias = this.getArgumentValue("--serverIdentityKeystoreAlias", args, null);
        String collectiveTrustcustomKS = this.getArgumentValue("--collectiveTrustKeystore", args, null);
        String safDefaultRDN = null;
        if (setupSAF.booleanValue()) {
            String SSLKeystoreName;
            String prefix = "LZMember";
            serverIdentitycustomKS = SSLKeystoreName = "safkeyring:///" + prefix + ".Ring";
            collectiveTrustcustomKS = SSLKeystoreName;
            serverIdentityAlias = prefix + ".CERT";
            safDefaultRDN = "OU=LZCollective";
        }
        if ((safCertificateRdn = this.getArgumentValue("--certificateRdn", args, safDefaultRDN)) != null) {
            try {
                new Rdn(safCertificateRdn);
            }
            catch (InvalidNameException e) {
                Trlog.debug(className, methodName, "Caught InvalidNameException while getting Rdn", e);
                this.abortAndPerformCleanup(this.getMessage("common.invalidDN", "--certificateRdn", safCertificateRdn), this.collectiveResourcesDir, methodName);
            }
        }
        String encodedServerIdentityKeystorePassword = null;
        String encodedCollectiveTrustKSPassword = null;
        if (predType.equals("CUSTOMFILE")) {
            encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", prop);
            encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--serverIdentityKeystorePassword", prop);
            if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null) {
                this.abort(null, methodName);
            }
            this.verifyFileSSL(serverIdentitycustomKS, collectiveTrustcustomKS, serverIdentityAlias, serverIdentityKeystorePassword, collectiveTrustKSPassword, true, this.collectiveResourcesDir);
        } else {
            String safKeystoreType = this.getArgumentValue("--safKeystoreType", args, "JCERACFKS");
            String safKeystoreProvider = this.getArgumentValue("--safKeystoreProvider", args, null);
            this.verifySAFSSL(Arrays.asList(serverIdentitycustomKS, collectiveTrustcustomKS), serverIdentityAlias, safKeystoreType, safKeystoreProvider, true, this.collectiveResourcesDir);
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        certProps.put("CustomKeystores", "true");
        Trlog.debug(className, methodName, "Join starts ...");
        this.stdout.println(this.getMessage("join.start", controllerHost, String.valueOf(controllerPort)));
        Map<String, byte[]> joinResult = this.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
        Trlog.debug(className, methodName, "Join mbean call completed.");
        return this.getCustomConfigXML(args, controllerHost, controllerPort, hostName, prop, safCertificateRdn, serverIdentitycustomKS, serverIdentityAlias, encodedServerIdentityKeystorePassword, collectiveTrustcustomKS, encodedCollectiveTrustKSPassword);
    }

    @Override
    protected List<String> getBetaOptions() {
        return BETA_OPTS;
    }
}

