/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility.utils;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.liberty.MainRepository;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.ConfigSnippetResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class RepositoryAccessUtility {
    private static Collection<ConfigSnippetResource> snippet_cache;

    public static StringBuilder getConfigSnippet(String configName) throws IOException, RepositoryBackendException, RepositoryResourceException, InstallException {
        RepositoryConnectionList loginInfo = RepositoryAccessUtility.getLoginInfo();
        Collection configSnippets = loginInfo.getAllConfigSnippets();
        for (ConfigSnippetResource snippet : configSnippets) {
            AttachmentResource att = snippet.getMainAttachment();
            if (att == null || !att.getName().equalsIgnoreCase(configName.concat(".xml"))) continue;
            InputStream is = att.getInputStream();
            StringBuilder sb = new StringBuilder();
            RepositoryAccessUtility.writeInputStream(is, sb);
            return sb;
        }
        return null;
    }

    public static List<String> getConfigSnippetList() throws RepositoryException, InstallException {
        Collection configSnippets;
        ArrayList<String> snippetList = new ArrayList<String>();
        RepositoryConnectionList loginInfo = RepositoryAccessUtility.getLoginInfo();
        if (snippet_cache != null) {
            configSnippets = snippet_cache;
        } else {
            snippet_cache = configSnippets = loginInfo.getAllConfigSnippets();
        }
        for (ConfigSnippetResource snippet : configSnippets) {
            AttachmentResource att = snippet.getMainAttachment();
            if (att == null) continue;
            snippetList.add(att.getName().substring(0, att.getName().lastIndexOf(46)));
        }
        return snippetList;
    }

    public static String getConfigSnippetDescription(String configName) throws RepositoryException, InstallException {
        Collection configSnippets;
        RepositoryConnectionList loginInfo = RepositoryAccessUtility.getLoginInfo();
        if (snippet_cache != null) {
            configSnippets = snippet_cache;
        } else {
            snippet_cache = configSnippets = loginInfo.getAllConfigSnippets();
        }
        for (ConfigSnippetResource snippet : configSnippets) {
            AttachmentResource att = snippet.getMainAttachment();
            if (att == null || !att.getName().equalsIgnoreCase(configName.concat(".xml"))) continue;
            String desc = snippet.getName() + ": " + System.getProperty("line.separator") + snippet.getShortDescription();
            return desc;
        }
        return null;
    }

    private static RepositoryConnectionList getLoginInfo() throws RepositoryBackendIOException, InstallException {
        RestRepositoryConnectionProxy proxy = RepositoryAccessUtility.getProxy();
        RepositoryConnectionList loginInfo = new RepositoryConnectionList((RepositoryConnection)MainRepository.createConnection((RestRepositoryConnectionProxy)proxy));
        return loginInfo;
    }

    public static RestRepositoryConnectionProxy getProxy() throws InstallException {
        Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
        RestRepositoryConnectionProxy proxy = RepositoryConfigUtils.getProxyInfo((Properties)repoProperties);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInputStream(InputStream is, StringBuilder sb) throws IOException {
        byte[] buffer = new byte[2048];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, length));
            }
        }
        finally {
            is.close();
        }
    }
}

