/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility.utils;

import com.ibm.ws.config.utility.IFileUtility;
import com.ibm.ws.config.utility.utils.RepositoryPathUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class FileUtility
implements IFileUtility {
    static final String SLASH = String.valueOf(File.separatorChar);
    private final String WLP_INSTALL_DIR;
    private final String WLP_USER_DIR;

    public FileUtility(String WLP_INSTALL_DIR, String WLP_USER_DIR) {
        File remoteAccessUtilityJarFile;
        this.WLP_INSTALL_DIR = WLP_INSTALL_DIR == null ? ((remoteAccessUtilityJarFile = this.getConfigUtilityJar()) == null ? System.getProperty("user.dir") + SLASH : remoteAccessUtilityJarFile.getParentFile().getParentFile().getAbsolutePath() + SLASH) : (WLP_INSTALL_DIR.endsWith("/") || WLP_INSTALL_DIR.endsWith("\\") ? WLP_INSTALL_DIR : WLP_INSTALL_DIR + SLASH);
        this.WLP_USER_DIR = WLP_USER_DIR == null ? this.WLP_INSTALL_DIR + "usr" + SLASH : (WLP_USER_DIR.endsWith("/") || WLP_USER_DIR.endsWith("\\") ? WLP_USER_DIR : WLP_USER_DIR + SLASH);
    }

    @Override
    public String getInstallDir() {
        return this.WLP_INSTALL_DIR;
    }

    @Override
    public String getUserDir() {
        return this.WLP_USER_DIR;
    }

    @Override
    public boolean createParentDirectory(PrintStream stdout, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.exists()) {
            if (!this.createParentDirectory(stdout, parent)) {
                return false;
            }
            return parent.mkdir();
        }
        return true;
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToFile(PrintStream stderr, String toWrite, File outFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            fos.write(toWrite.getBytes(Charset.forName("UTF-8")));
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            stderr.println(e.getMessage());
        }
        catch (IOException e) {
            stderr.println(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    @Override
    public StringBuilder readFileToStringBuilder(File file) throws IOException {
        return new StringBuilder(FileUtils.readFileToString((File)file, (String)"UTF-8"));
    }

    private String getPath(URL url) {
        String encodedPath = RepositoryPathUtility.getURLEncodedPath(url.toString());
        return RepositoryPathUtility.decodeURLEncodedDir(encodedPath);
    }

    private File getConfigUtilityJar() {
        File launchHome = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.config.utility.ConfigUtility");
        }
        catch (Exception e) {
            return null;
        }
        URL home = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!home.getProtocol().equals("file")) {
            return null;
        }
        String path = this.getPath(home);
        launchHome = new File(path);
        return launchHome;
    }
}

