/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.Symbol;
import com.ibm.xml.xlxp2.scan.util.UTF8Support;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class SymbolMap
implements Cloneable {
    private static int[] PRIMES = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727};
    private static final int MAX_HASH_COLLISIONS = 75;
    private static final int MULTIPLIERS_SIZE = 32;
    private static final int MULTIPLIERS_MASK = 31;
    private static final int DEFAULT_MAX_SYMBOL_COUNT = Integer.MAX_VALUE;
    private static final int MAX_SYMBOL_COUNT = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xlxp2.scan.util.SymbolMap.maxSymbolCount", Integer.MAX_VALUE);
            }
            catch (SecurityException securityException) {
                return Integer.MAX_VALUE;
            }
        }
    });
    private static final boolean TRACE_REBALANCING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("trace.symbol.map.rebalancing");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final boolean TRACE_ADDITIONS = false;
    private static final boolean CHECK_DUPLICATES = false;
    private static final boolean DUMP_TABLES = false;
    private static final boolean CHECK_SYMBOLS = false;
    private static final boolean USE_COMPLEX_SECONDARY_HASH = true;
    private static final boolean REBALANCE_BUCKETS = true;
    private static final int PRUNE_IF_NOT_REFERRENCED_LIMIT = 2;
    private static final int INITIAL_ALLOCATION_SIZE = 8192;
    private static final int B_HASHCODE = 0;
    private static final int B_NEXT = 1;
    private static final int B_NSTART = 2;
    private static final int B_NEND = 3;
    private static final int B_SYMINDEX = 4;
    private static final int B_SIZE = 5;
    private static final Comparator<Symbol> fgHitCountReverseComparator = new Comparator<Symbol>(){

        @Override
        public int compare(Symbol symbol, Symbol symbol2) {
            if (symbol.hitCount == symbol2.hitCount) {
                return 0;
            }
            if (symbol.hitCount > symbol2.hitCount) {
                return -1;
            }
            return 1;
        }
    };
    private static final ReentrantReadWriteLock fgRWLock = new ReentrantReadWriteLock();
    private static final Lock fgMutableMapReadLock = fgRWLock.readLock();
    private static final Lock fgMutableMapWriteLock = fgRWLock.writeLock();
    private static int fgInstanceCounter;
    private static SymbolMap fgSharedMap;
    private static SymbolMap fgMutableMap;
    private int id;
    private final DataBuffer fSymbolBuffer;
    private Symbol[] fSymbols;
    private boolean immutable;
    private boolean rebalancing;
    private int[] fTable;
    private int[] fBuckets;
    private int fNextBucketBase;
    private int fMask;
    private int fSymbolCount;
    private int fResetCount;
    private int fNextRebalanceCount;
    private final int fCountHitsResetCount;
    private int fRebalanceCountFreq;
    private boolean fCountHits;
    private int[] fHashFunctionMultipliers;

    static void generateSequence(int[] nArray) {
        Random random = new Random();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = PRIMES[random.nextInt(PRIMES.length)];
        }
    }

    private static String threadLabel() {
        return "***XLXP[" + Thread.currentThread().getId() + "]*** ";
    }

    private static String mapLabel(SymbolMap symbolMap) {
        return symbolMap != null ? "SymbolMap " + symbolMap.id : "null";
    }

    private SymbolMap() {
        this.fSymbolBuffer = NullDataBufferFactory.createNewBuffer();
        this.id = fgInstanceCounter++;
        this.fCountHitsResetCount = 16;
        this.fNextRebalanceCount = this.fRebalanceCountFreq = 64;
        this.fRebalanceCountFreq <<= 1;
        this.fSymbolCount = 0;
        this.fSymbols = ArrayAllocator.newObjectArray(Symbol.class, 256);
        this.fMask = 511;
        this.fTable = ArrayAllocator.newIntArray(2560);
        this.fBuckets = ArrayAllocator.newIntArray(640);
        this.fNextBucketBase = 5;
        this.fSymbolBuffer.bytes = ArrayAllocator.newByteArray(8192);
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = 1;
        this.immutable = true;
        this.fHashFunctionMultipliers = null;
    }

    private SymbolMap(SymbolMap symbolMap, Symbol[] symbolArray, int n) {
        byte[] byArray = ArrayAllocator.newByteArray(n);
        this.fSymbolBuffer = NullDataBufferFactory.createNewBuffer();
        this.id = fgInstanceCounter++;
        this.fCountHitsResetCount = symbolMap.fCountHitsResetCount;
        this.fRebalanceCountFreq = symbolMap.fRebalanceCountFreq;
        this.fNextRebalanceCount = symbolMap.fNextRebalanceCount;
        this.fSymbolCount = symbolMap.fSymbolCount;
        this.fSymbols = symbolArray;
        this.fSymbolBuffer.bytes = byArray;
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = 1;
        this.fMask = symbolMap.fMask;
        this.fTable = ArrayAllocator.newIntArray(symbolMap.fTable.length);
        this.fBuckets = ArrayAllocator.newIntArray(symbolMap.fBuckets.length);
        this.fNextBucketBase = 5;
        int n2 = this.fSymbolBuffer.endOffset;
        this.fHashFunctionMultipliers = symbolMap.fHashFunctionMultipliers;
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol = this.fSymbols[i];
            int n3 = n2;
            int n4 = symbol.nameEnd - symbol.nameStart;
            n2 += n4;
            System.arraycopy(symbol.nameBuffer.bytes, symbol.nameStart, byArray, n3, n4);
            this.fSymbols[i] = symbol = new Symbol(symbol, this.fSymbolBuffer, n3, n3 + n4);
            int n5 = this.fHashFunctionMultipliers == null ? UTF8Support.hashCode(symbol.str) : this.randomHashFunction(symbol.str);
            this.addHashedSymbolToBucket(i, symbol.nameStart, symbol.nameEnd, n5);
        }
        this.fSymbolBuffer.endOffset = n2;
        this.rebalancing = symbolMap.rebalancing;
        this.fResetCount = symbolMap.fResetCount;
        this.fCountHits = symbolMap.fCountHits;
        this.immutable = true;
    }

    public SymbolMap clone() {
        assert (this.immutable);
        try {
            SymbolMap symbolMap = (SymbolMap)super.clone();
            symbolMap.id = fgInstanceCounter++;
            symbolMap.immutable = false;
            symbolMap.fSymbols = (Symbol[])this.fSymbols.clone();
            symbolMap.fTable = (int[])this.fTable.clone();
            symbolMap.fBuckets = (int[])this.fBuckets.clone();
            return symbolMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetMap(boolean bl) {
        SymbolMap symbolMap = fgMutableMap;
        if (symbolMap != null && symbolMap.fSymbolCount != SymbolMap.fgSharedMap.fSymbolCount) {
            fgMutableMapWriteLock.lock();
            try {
                if (fgMutableMap != null && SymbolMap.fgMutableMap.fSymbolCount != SymbolMap.fgSharedMap.fSymbolCount) {
                    SymbolMap.fgMutableMap.immutable = true;
                    fgSharedMap = fgMutableMap;
                    fgMutableMap = null;
                }
            }
            finally {
                fgMutableMapWriteLock.unlock();
            }
        }
        fgSharedMap.reset(bl);
    }

    private void reset(boolean bl) {
        if (this.fSymbolCount > MAX_SYMBOL_COUNT) {
            this.clear();
        } else if (!this.rebalancing && ++this.fResetCount == this.fNextRebalanceCount) {
            this.rebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebalance() {
        if (!this.fCountHits) {
            for (int i = 0; i < this.fSymbolCount; ++i) {
                this.fSymbols[i].hitCount = 0;
            }
            this.fCountHits = true;
            SymbolMap symbolMap = fgMutableMap;
            if (symbolMap != null) {
                symbolMap.fCountHits = true;
            }
            this.fNextRebalanceCount = this.fResetCount + this.fCountHitsResetCount;
            return;
        }
        this.rebalancing = true;
        this.fCountHits = false;
        SymbolMap symbolMap = fgMutableMap;
        if (symbolMap != null) {
            symbolMap.fCountHits = false;
        }
        if (this.tablesBalanced()) {
            this.fRebalanceCountFreq <<= 1;
        } else {
            fgMutableMapWriteLock.lock();
            try {
                if (fgMutableMap != null) {
                    SymbolMap.fgMutableMap.immutable = true;
                    fgSharedMap = fgMutableMap.createBalancedMap();
                    fgMutableMap = null;
                } else {
                    fgSharedMap = fgSharedMap.createBalancedMap();
                }
            }
            finally {
                fgMutableMapWriteLock.unlock();
            }
        }
        this.fNextRebalanceCount += this.fRebalanceCountFreq;
        this.fRebalanceCountFreq <<= 1;
        this.rebalancing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        fgMutableMapWriteLock.lock();
        try {
            fgSharedMap = new SymbolMap();
            fgMutableMap = null;
        }
        finally {
            fgMutableMapWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SymbolMap holdMutableMap() {
        fgMutableMapReadLock.lock();
        if (fgMutableMap != null) {
            return fgMutableMap;
        }
        fgMutableMapReadLock.unlock();
        fgMutableMapWriteLock.lock();
        if (fgMutableMap != null) {
            fgMutableMapReadLock.lock();
            fgMutableMapWriteLock.unlock();
            return fgMutableMap;
        }
        try {
            fgMutableMap = fgSharedMap.clone();
        }
        finally {
            fgMutableMapReadLock.lock();
            fgMutableMapWriteLock.unlock();
        }
        return fgMutableMap;
    }

    private static void releaseMutableMap() {
        fgMutableMapReadLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol addSymbol(XMLString xMLString) {
        int n = SymbolMap.fgSharedMap.fHashFunctionMultipliers == null ? xMLString.hashCode() : fgSharedMap.randomHashFunction(xMLString);
        Symbol symbol = fgSharedMap.get(xMLString, n);
        if (symbol != null) {
            return symbol;
        }
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                if (SymbolMap.fgSharedMap.fHashFunctionMultipliers != symbolMap.fHashFunctionMultipliers) {
                    n = symbolMap.randomHashFunction(xMLString);
                }
                if ((symbol = symbolMap.get(xMLString, n)) == null) {
                    symbol = symbolMap.put(xMLString, n);
                }
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol addSymbol(String string) {
        int n = SymbolMap.fgSharedMap.fHashFunctionMultipliers == null ? UTF8Support.hashCode(string) : fgSharedMap.randomHashFunction(string);
        Symbol symbol = fgSharedMap.get(string, n);
        if (symbol != null) {
            return symbol;
        }
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                if (SymbolMap.fgSharedMap.fHashFunctionMultipliers != symbolMap.fHashFunctionMultipliers) {
                    n = symbolMap.randomHashFunction(string);
                }
                if ((symbol = symbolMap.get(string, n)) == null) {
                    symbol = symbolMap.put(string, n);
                }
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol getQNameSymbol(QName qName, int n) {
        Symbol symbol;
        if (SymbolMap.fgSharedMap.fHashFunctionMultipliers != null) {
            n = fgSharedMap.randomHashFunction(qName);
        }
        if ((symbol = fgSharedMap.get(qName, n)) == null) {
            SymbolMap symbolMap = SymbolMap.holdMutableMap();
            try {
                SymbolMap symbolMap2 = symbolMap;
                synchronized (symbolMap2) {
                    if (SymbolMap.fgSharedMap.fHashFunctionMultipliers != symbolMap.fHashFunctionMultipliers) {
                        n = symbolMap.randomHashFunction(qName);
                    }
                    if ((symbol = symbolMap.get(qName, n)) == null) {
                        symbol = symbolMap.put(qName, n);
                    }
                }
            }
            finally {
                SymbolMap.releaseMutableMap();
            }
        }
        symbol.setQNameValues(qName);
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol getQNameSymbol(QName qName) {
        int n = SymbolMap.fgSharedMap.fHashFunctionMultipliers == null ? qName.hashcode : fgSharedMap.randomHashFunction(qName);
        Symbol symbol = fgSharedMap.get(qName.bytes, qName.startOffset, qName.endOffset, n);
        if (symbol == null) {
            SymbolMap symbolMap = SymbolMap.holdMutableMap();
            try {
                SymbolMap symbolMap2 = symbolMap;
                synchronized (symbolMap2) {
                    block12: {
                        if (SymbolMap.fgSharedMap.fHashFunctionMultipliers != symbolMap.fHashFunctionMultipliers) {
                            n = symbolMap.randomHashFunction(qName);
                        }
                        if ((symbol = symbolMap.get(qName.bytes, qName.startOffset, qName.endOffset, n)) != null) break block12;
                        if (DocumentScanner.checkQName(qName)) {
                            symbol = symbolMap.put(qName, n);
                            break block12;
                        }
                        Symbol symbol2 = null;
                        return symbol2;
                    }
                }
            }
            finally {
                SymbolMap.releaseMutableMap();
            }
        }
        if (symbol.setValuesIfKnownQName(qName)) {
            return symbol;
        }
        return null;
    }

    private int randomHashFunction(String string) {
        return UTF8Support.hashCode(string, this.fHashFunctionMultipliers, 31);
    }

    private int randomHashFunction(XMLString xMLString) {
        return UTF8Support.hashCode(xMLString, this.fHashFunctionMultipliers, 31);
    }

    private Symbol get(byte[] byArray, int n, int n2, int n3) {
        int[] nArray = this.fTable;
        int n4 = (SymbolMap.hash(n3) & this.fMask) * 5;
        if (nArray[n4 + 2] != 0) {
            int n5;
            int n6;
            byte[] byArray2 = this.fSymbolBuffer.bytes;
            if (nArray[n4 + 0] == n3) {
                int n7 = n;
                n6 = nArray[n4 + 2];
                n5 = nArray[n4 + 3];
                while (byArray[n7++] == byArray2[n6] && ++n6 < n5) {
                }
                if (n6 == n5 && n7 == n2) {
                    Symbol symbol = this.fSymbols[nArray[n4 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
            }
            int[] nArray2 = this.fBuckets;
            n6 = nArray[n4 + 1];
            while (n6 != 0) {
                if (nArray2[n6 + 0] == n3) {
                    n5 = n;
                    int n8 = nArray2[n6 + 2];
                    int n9 = nArray2[n6 + 3];
                    while (byArray[n5++] == byArray2[n8] && ++n8 < n9) {
                    }
                    if (n8 == n9 && n5 == n2) {
                        Symbol symbol = this.fSymbols[nArray2[n6 + 4]];
                        if (this.fCountHits) {
                            ++symbol.hitCount;
                        }
                        return symbol;
                    }
                }
                n6 = nArray2[n6 + 1];
            }
        }
        return null;
    }

    private Symbol get(XMLString xMLString, int n) {
        int[] nArray = this.fTable;
        int n2 = (SymbolMap.hash(n) & this.fMask) * 5;
        if (nArray[n2 + 2] != 0) {
            byte[] byArray = this.fSymbolBuffer.bytes;
            if (nArray[n2 + 0] == n && xMLString.equalsString(byArray, nArray[n2 + 2], nArray[n2 + 3])) {
                Symbol symbol = this.fSymbols[nArray[n2 + 4]];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            int[] nArray2 = this.fBuckets;
            int n3 = nArray[n2 + 1];
            while (n3 != 0) {
                if (nArray2[n3 + 0] == n && xMLString.equalsString(byArray, nArray2[n3 + 2], nArray2[n3 + 3])) {
                    Symbol symbol = this.fSymbols[nArray2[n3 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
                n3 = nArray2[n3 + 1];
            }
        }
        return null;
    }

    private Symbol get(String string, int n) {
        int[] nArray = this.fTable;
        int n2 = (SymbolMap.hash(n) & this.fMask) * 5;
        if (nArray[n2 + 2] != 0) {
            if (nArray[n2 + 0] == n && this.bucketEquals(string, nArray[n2 + 2], nArray[n2 + 3])) {
                Symbol symbol = this.fSymbols[nArray[n2 + 4]];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            int[] nArray2 = this.fBuckets;
            int n3 = nArray[n2 + 1];
            while (n3 != 0) {
                if (nArray2[n3 + 0] == n && this.bucketEquals(string, nArray2[n3 + 2], nArray2[n3 + 3])) {
                    Symbol symbol = this.fSymbols[nArray2[n3 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
                n3 = nArray2[n3 + 1];
            }
        }
        return null;
    }

    private Symbol put(XMLString xMLString, int n) {
        assert (!this.immutable);
        int n2 = this.fSymbolBuffer.endOffset;
        this.appendToSymbolBytes(xMLString);
        return this.put(xMLString.toString().intern(), n, n2, this.fSymbolBuffer.endOffset);
    }

    private int checkString(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) < '\u0080'; ++n) {
        }
        if (n == n2) {
            return n2;
        }
        int n3 = n;
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) < '\u0080') {
                ++n3;
                continue;
            }
            if (c < '\u0800') {
                n3 += 2;
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                n3 += 3;
                continue;
            }
            if (c < '\udc00') {
                if (n == n2) {
                    return -1;
                }
                if ((c = string.charAt(n++)) < '\udc00' || c >= '\ue000') {
                    return -1;
                }
                n3 += 4;
                continue;
            }
            return -1;
        }
        return n3;
    }

    private Symbol put(String string, int n) {
        assert (!this.immutable);
        int n2 = this.checkString(string);
        if (n2 >= 0) {
            int n3 = this.fSymbolBuffer.endOffset;
            this.appendToSymbolBytes(string, n2);
            return this.put(string.intern(), UTF8Support.hashCode(string), n3, this.fSymbolBuffer.endOffset);
        }
        return null;
    }

    private static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private boolean bucketEquals(String string, int n, int n2) {
        byte[] byArray = this.fSymbolBuffer.bytes;
        int n3 = string.length();
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            int n5 = string.charAt(i);
            if (n5 == byArray[n4]) {
                ++n4;
                continue;
            }
            if (n5 < 128) {
                return false;
            }
            if (n5 < 2048) {
                if (byArray[n4] != (byte)(0xC0 | n5 >> 6)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (byArray[n4] != (byte)(0xE0 | n5 >> 12)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5 >> 6)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            if (n5 < 56320) {
                if (++i == n3) {
                    return false;
                }
                char c = string.charAt(i);
                if (c < '\udc00' || c >= '\ue000') {
                    return false;
                }
                if (byArray[n4] != (byte)(0xF0 | (n5 = 65536 + (n5 - 55296 << 10) + (c - 56320)) >> 18)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5 >> 12)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5 >> 6)) {
                    return false;
                }
                if (byArray[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            return false;
        }
        return n4 == n2;
    }

    private int allocateBucket() {
        int n = this.fNextBucketBase;
        if (n == this.fBuckets.length) {
            this.fBuckets = ArrayAllocator.resizeIntArray(this.fBuckets, n << 1);
        }
        this.fNextBucketBase += 5;
        return n;
    }

    private int addHashedSymbolToBucket(int n, int n2, int n3, int n4) {
        int n5;
        if (this.fHashFunctionMultipliers == null && (n5 = UTF8Support.hashCode(this.fSymbolBuffer.bytes, n2, n3)) != n4) {
            n4 = n5;
        }
        n5 = (SymbolMap.hash(n4) & this.fMask) * 5;
        int[] nArray = this.fTable;
        int n6 = 0;
        if (nArray[n5 + 2] != 0) {
            int n7 = this.allocateBucket();
            if (nArray[n5 + 1] == 0) {
                nArray[n5 + 1] = n7;
                nArray = this.fBuckets;
            } else {
                n5 = nArray[n5 + 1];
                nArray = this.fBuckets;
                while (nArray[n5 + 1] != 0) {
                    ++n6;
                    n5 = nArray[n5 + 1];
                }
                nArray[n5 + 1] = n7;
            }
            n5 = n7;
        }
        nArray[n5 + 0] = n4;
        nArray[n5 + 1] = 0;
        nArray[n5 + 2] = n2;
        nArray[n5 + 3] = n3;
        nArray[n5 + 4] = n;
        return n6;
    }

    private void rehash(boolean bl) {
        if (bl) {
            this.fTable = ArrayAllocator.replaceIntArray(this.fTable, this.fTable.length << 1);
            this.fMask = (this.fMask + 1 << 1) - 1;
        }
        this.fNextBucketBase = 5;
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol = this.fSymbols[i];
            int n = this.fHashFunctionMultipliers == null ? UTF8Support.hashCode(symbol.str) : this.randomHashFunction(symbol.str);
            this.addHashedSymbolToBucket(i, symbol.nameStart, symbol.nameEnd, n);
        }
    }

    private Symbol put(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        assert (!this.immutable);
        Symbol symbol = new Symbol(string, this.fSymbolBuffer, n2, n3);
        if ((n5 = this.fSymbolCount++) == this.fSymbols.length) {
            this.fSymbols = ArrayAllocator.resizeObjectArray(Symbol.class, this.fSymbols, this.fSymbols.length << 1);
        }
        this.fSymbols[n5] = symbol;
        if (n5 == this.fMask - (this.fMask >> 2)) {
            this.rehash(true);
        }
        if ((n4 = this.addHashedSymbolToBucket(n5, n2, n3, n)) >= 75) {
            if (this.fHashFunctionMultipliers == SymbolMap.fgSharedMap.fHashFunctionMultipliers) {
                this.fHashFunctionMultipliers = new int[32];
            }
            SymbolMap.generateSequence(this.fHashFunctionMultipliers);
            this.rehash(false);
        }
        return symbol;
    }

    private void checkSymbols() {
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol;
            int n;
            Symbol symbol2 = this.fSymbols[i];
            if (symbol2.nameBuffer != this.fSymbolBuffer) {
                throw new RuntimeException("SymbolMap corrupted");
            }
            try {
                String string = new String(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd - symbol2.nameStart, "UTF8");
                if (!string.equals(symbol2.str)) {
                    throw new RuntimeException("SymbolMap corrupted");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("SymbolMap corrupted");
            }
            int n2 = n = this.fHashFunctionMultipliers == null ? UTF8Support.hashCode(symbol2.str) : this.randomHashFunction(symbol2.str);
            if (symbol2.nameStart != symbol2.nameEnd && (symbol = this.get(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd, n)) != symbol2) {
                symbol = this.get(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd, n);
                throw new RuntimeException("SymbolMap corrupted");
            }
            symbol = this.get(symbol2.str, n);
            if (symbol == symbol2) continue;
            symbol = this.get(symbol2.str, n);
            throw new RuntimeException("SymbolMap corrupted");
        }
    }

    private boolean tablesBalanced() {
        for (int i = 0; i < this.fTable.length; i += 5) {
            if (this.fTable[i + 2] == 0 || this.fTable[i + 1] == 0) continue;
            int n = this.fTable[i + 4];
            int n2 = this.fSymbols[n].hitCount;
            int n3 = this.fTable[i + 1];
            while (n3 != 0) {
                n = this.fBuckets[n3 + 4];
                int n4 = this.fSymbols[n].hitCount;
                if (n2 < n4) {
                    return false;
                }
                n2 = n4;
                n3 = this.fBuckets[n3 + 1];
            }
        }
        return true;
    }

    private SymbolMap createBalancedMap() {
        int n;
        int n2;
        assert (this.immutable);
        int n3 = 1;
        Symbol[] symbolArray = ArrayAllocator.newObjectArray(Symbol.class, this.fSymbols.length);
        int n4 = 0;
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(this.fSymbolCount);
        Symbol symbol = this.fSymbols[0];
        n3 += symbol.nameEnd - symbol.nameStart;
        arrayList.add(symbol);
        int n5 = this.fSymbols[0].hitCount == 0 ? 0 : 1;
        for (int i = 1; i < this.fSymbolCount; ++i) {
            int n6;
            symbol = this.fSymbols[i];
            n3 += symbol.nameEnd - symbol.nameStart;
            int n7 = symbol.hitCount;
            if (n7 == 0) {
                arrayList.add(symbol);
                continue;
            }
            if (n5 > 0) {
                n6 = Collections.binarySearch(arrayList, symbol, fgHitCountReverseComparator);
                if (n6 < 0) {
                    n6 = -(n6 + 1);
                }
            } else {
                n6 = 0;
            }
            arrayList.add(n6, symbol);
            ++n5;
        }
        n4 = this.fSymbolCount;
        arrayList.toArray(symbolArray);
        for (n2 = n = this.fSymbolBuffer.bytes.length; n2 < n3; n2 <<= 1) {
        }
        if (TRACE_REBALANCING) {
            if (n != n2) {
                System.err.println("rebalanced symbol bytes array length changed from " + n + " to " + n2);
            }
            if (n3 != this.fSymbolBuffer.endOffset) {
                System.err.println("rebalanced symbol bytes offset changed from " + this.fSymbolBuffer.endOffset + " to " + n3);
            }
        }
        SymbolMap symbolMap = new SymbolMap(this, symbolArray, n2);
        return symbolMap;
    }

    private void grow(int n) {
        int n2;
        for (n2 = this.fSymbolBuffer.bytes.length << 1; n2 < n; n2 <<= 1) {
        }
        byte[] byArray = ArrayAllocator.resizeByteArray(this.fSymbolBuffer.bytes, n2);
        this.fSymbolBuffer.bytes = byArray;
    }

    private void allocate(int n) {
        if (this.fSymbolBuffer.endOffset + n > this.fSymbolBuffer.bytes.length) {
            this.grow(this.fSymbolBuffer.endOffset + n);
        }
        this.fSymbolBuffer.endOffset += n;
    }

    private void appendToSymbolBytes(XMLString xMLString) {
        int n = this.fSymbolBuffer.endOffset;
        this.allocate(xMLString.length);
        byte[] byArray = this.fSymbolBuffer.bytes;
        if (xMLString.bytes != null) {
            System.arraycopy(xMLString.bytes, xMLString.startOffset, byArray, n, xMLString.length);
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            int n2 = dataBuffer.endOffset - xMLString.startOffset;
            System.arraycopy(dataBuffer.bytes, xMLString.startOffset, byArray, n, n2);
            n += n2;
            while ((dataBuffer = dataBuffer.next) != xMLString.lastBuffer) {
                n2 = dataBuffer.endOffset - dataBuffer.startOffset;
                System.arraycopy(dataBuffer.bytes, dataBuffer.startOffset, byArray, n, n2);
                n += n2;
            }
            n2 = xMLString.endOffset - dataBuffer.startOffset;
            System.arraycopy(dataBuffer.bytes, dataBuffer.startOffset, byArray, n, n2);
        }
    }

    private void appendToSymbolBytes(String string, int n) {
        int n2;
        int n3;
        int n4 = this.fSymbolBuffer.endOffset;
        this.allocate(n);
        byte[] byArray = this.fSymbolBuffer.bytes;
        int n5 = string.length();
        for (n3 = 0; n3 < n5 && (n2 = string.charAt(n3)) < 128; ++n3) {
            byArray[n4++] = (byte)n2;
        }
        while (n3 < n5) {
            if ((n2 = string.charAt(n3++)) < 128) {
                byArray[n4++] = (byte)n2;
                continue;
            }
            if (n2 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n2 >> 6);
                byArray[n4++] = (byte)(0x80 | 0x3F & n2);
                continue;
            }
            if (n2 < 55296 || n2 >= 57344) {
                byArray[n4++] = (byte)(0xE0 | n2 >> 12);
                byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 6);
                byArray[n4++] = (byte)(0x80 | 0x3F & n2);
                continue;
            }
            char c = string.charAt(n3);
            ++n3;
            n2 = 65536 + (n2 - 55296 << 10) + (c - 56320);
            byArray[n4++] = (byte)(0xF0 | n2 >> 18);
            byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 12);
            byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 6);
            byArray[n4++] = (byte)(0x80 | 0x3F & n2);
        }
    }

    private void dumpTables() {
    }

    static {
        fgSharedMap = new SymbolMap();
        fgMutableMap = null;
    }
}

